/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.hardware;

import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.hardware.AbstractHwContinuousControl;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwRelativeKnob;
import de.mossgrabers.framework.controller.valuechanger.RelativeEncoding;
import de.mossgrabers.framework.controller.valuechanger.RelativeValueChangers;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.observer.IValueObserver;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.reaper.framework.daw.data.parameter.IParameterEx;
import de.mossgrabers.reaper.framework.graphics.GraphicsContextImpl;
import de.mossgrabers.reaper.framework.hardware.Bounds;
import de.mossgrabers.reaper.framework.hardware.HwControlLayout;
import de.mossgrabers.reaper.framework.hardware.IReaperHwControl;
import de.mossgrabers.reaper.framework.midi.MidiInputImpl;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.ShortMessage;

public class HwRelativeKnobImpl
extends AbstractHwContinuousControl
implements IHwRelativeKnob,
IReaperHwControl {
    private final HwControlLayout layout;
    private final RelativeEncoding encoding;
    private MidiInputImpl inputImpl;
    private int control;
    private IParameter parameter;
    private boolean isPressed;
    private double pressedX;
    private double pressedY;
    private boolean shouldAdaptSensitivity = true;
    private final List<IValueObserver<Void>> observers = new ArrayList<IValueObserver<Void>>();

    public HwRelativeKnobImpl(String id, IHost host, String label) {
        this(id, host, label, RelativeEncoding.TWOS_COMPLEMENT);
    }

    public HwRelativeKnobImpl(String id, IHost host, String label, RelativeEncoding encoding) {
        super(host, label);
        this.layout = new HwControlLayout(id);
        this.encoding = encoding;
    }

    @Override
    public void addHasChangedObserver(IValueObserver<Void> observer) {
        this.observers.add(observer);
    }

    @Override
    public void bind(IParameter parameter) {
        this.parameter = parameter;
    }

    @Override
    public boolean isBound() {
        return this.parameter != null || super.isBound();
    }

    @Override
    public void bind(IMidiInput input, BindType type, int channel, int control) {
        this.inputImpl = (MidiInputImpl)input;
        this.type = type;
        this.channel = channel;
        this.control = control;
        input.bind(this, type, channel, control, this.encoding);
    }

    @Override
    public void unbind() {
        if (this.input != null) {
            this.input.unbind(this);
        }
    }

    @Override
    public void rebind() {
        if (this.input != null) {
            this.input.bind(this, this.type, this.channel, this.control, this.encoding);
        }
    }

    @Override
    public void bindTouch(TriggerCommand command, IMidiInput input, BindType type, int channel, int control) {
        this.touchCommand = command;
        input.bindTouch(this, type, channel, control);
    }

    @Override
    public void handleValue(double value) {
        this.notifyHasChangedObservers();
        int intValue = (int)Math.round(value * 127.0);
        if (this.parameter != null) {
            this.parameter.changeValue(intValue);
        } else if (this.command != null) {
            this.command.execute(intValue);
        }
    }

    @Override
    public void setBounds(double x, double y, double width, double height) {
        this.layout.setBounds(x, y, width, height);
    }

    @Override
    public void draw(IGraphicsContext gc, double scale) {
        Bounds bounds = this.layout.getBounds();
        if (bounds == null) {
            return;
        }
        double radius = Math.min(bounds.width(), bounds.height()) / 2.0;
        double centerX = (bounds.x() + radius) * scale;
        double centerY = (bounds.y() + radius) * scale;
        gc.fillCircle(centerX, centerY, radius * scale, ColorEx.BLACK);
        IParameter iParameter = this.parameter;
        if (iParameter instanceof IParameterEx) {
            IParameterEx pi = (IParameterEx)iParameter;
            double paramValue = pi.getInternalValue();
            int l = (int)Math.round(paramValue * 360.0);
            ((GraphicsContextImpl)gc).fillArc(centerX, centerY, radius * scale, ColorEx.RED, 270 - l - 4, 4);
        }
    }

    @Override
    public void mouse(int mouseEvent, double x, double y, double scale) {
        Bounds bounds = this.layout.getBounds();
        if (bounds == null) {
            return;
        }
        double scaleX = x / scale;
        double scaleY = y / scale;
        switch (mouseEvent) {
            case 501: {
                if (!bounds.contains(scaleX, scaleY)) break;
                this.isPressed = true;
                this.pressedX = scaleX;
                this.pressedY = scaleY;
                break;
            }
            case 502: {
                this.isPressed = false;
                break;
            }
            case 506: {
                try {
                    if (!this.isPressed) {
                        return;
                    }
                    int speed = (int)Math.min(3L, Math.max(-3L, Math.round(this.pressedX - scaleX + (this.pressedY - scaleY))));
                    if (speed == 0) {
                        return;
                    }
                    this.pressedX = scaleX;
                    this.pressedY = scaleY;
                    int value = RelativeValueChangers.get(this.encoding).encode(speed);
                    if (this.inputImpl == null) {
                        this.command.execute(value);
                        return;
                    }
                    if (this.type != BindType.CC) break;
                    this.inputImpl.handleMidiMessage(new ShortMessage(176, this.channel, this.control, value));
                }
                catch (InvalidMidiDataException ex) {
                    this.host.error("Invalid MIDI message.", ex);
                }
                break;
            }
        }
    }

    @Override
    public void setSensitivity(double sensitivity) {
        RelativeValueChangers.setSensitivity(sensitivity);
    }

    @Override
    public void setIndexInGroup(int index) {
    }

    @Override
    public boolean shouldAdaptSensitivity() {
        return this.shouldAdaptSensitivity;
    }

    @Override
    public void setShouldAdaptSensitivity(boolean shouldAdaptSensitivity) {
        this.shouldAdaptSensitivity = shouldAdaptSensitivity;
    }

    private void notifyHasChangedObservers() {
        for (IValueObserver<Void> observer : this.observers) {
            observer.update(null);
        }
    }
}

