/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device.column;

import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.device.column.BaseColumn;
import de.mossgrabers.reaper.framework.device.column.BaseColumnItem;
import java.util.Collections;
import java.util.List;

public class DeviceTagsFilterColumn
extends BaseColumn {
    public DeviceTagsFilterColumn(int columnIndex, int numFilterColumnEntries) {
        super(columnIndex, "Tags", numFilterColumnEntries);
        for (int i = 0; i < numFilterColumnEntries; ++i) {
            this.items[i] = new DeviceTagsBrowserColumnItem(i);
        }
    }

    @Override
    protected int getMaxNumItems() {
        return 0;
    }

    @Override
    public List<String> getAllItems() {
        return Collections.emptyList();
    }

    private class DeviceTagsBrowserColumnItem
    extends BaseColumnItem {
        public DeviceTagsBrowserColumnItem(int index) {
            super(index);
        }

        @Override
        public int getIndex() {
            return DeviceTagsFilterColumn.this.calcPosition(this.index);
        }

        @Override
        public boolean isSelected() {
            return this.getIndex() == DeviceTagsFilterColumn.this.selectedRow;
        }

        @Override
        protected String getCachedName() {
            if (this.position == 0) {
                return "All";
            }
            return "";
        }

        @Override
        protected int getCachedHitCount() {
            if (this.position == 0) {
                return DeviceManager.get().getNumDevices();
            }
            return 0;
        }
    }
}

