/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.ItemImpl;

public class SceneImpl
extends ItemImpl
implements IScene {
    private ColorEx color = new ColorEx(0.2, 0.2, 0.2);
    private double beginPosition;
    private double endPosition;

    public SceneImpl(DataSetupEx dataSetup, int index) {
        super(dataSetup, index);
        this.setExists(false);
    }

    @Override
    public String getName() {
        String name = super.getName();
        return this.doesExist() && name != null && name.isBlank() ? "Scene " + (this.getPosition() + 1) : name;
    }

    @Override
    public void setName(String name) {
        this.sendPositionedItemOSC("name", name);
    }

    @Override
    public ColorEx getColor() {
        return this.color;
    }

    @Override
    public void setColor(ColorEx color) {
        int[] rgb = color.toIntRGB255();
        this.sendPositionedItemOSC("color", "RGB(" + rgb[0] + "," + rgb[1] + "," + rgb[2] + ")");
    }

    public void setColorState(ColorEx color) {
        this.color = color;
    }

    @Override
    public void launch(boolean isPressed, boolean isAlternative) {
        if (isPressed) {
            this.sendPositionedItemOSC("launch");
        }
    }

    @Override
    public void remove() {
        this.sendPositionedItemOSC("remove");
    }

    @Override
    public void select() {
        this.sendPositionedItemOSC("select");
    }

    @Override
    public void duplicate() {
        this.sendPositionedItemOSC("duplicate");
    }

    @Override
    protected Processor getProcessor() {
        return Processor.SCENE;
    }

    public void setBeginPosition(double beginPosition) {
        this.beginPosition = beginPosition;
    }

    public void setEndPosition(double endPosition) {
        this.endPosition = endPosition;
    }

    public double getBeginPosition() {
        return this.beginPosition;
    }

    public double getEndPosition() {
        return this.endPosition;
    }
}

