/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.mode.device;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import java.util.Optional;

public class BrowserMode<S extends IControlSurface<C>, C extends Configuration>
extends AbstractParameterMode<S, C, IItem> {
    public BrowserMode(S surface, IModel model) {
        super("Browser", surface, model, false);
    }

    @Override
    public void onKnobValue(int index, int value) {
        IBrowser browser = this.model.getBrowser();
        if (browser == null) {
            return;
        }
        boolean increase = this.model.getValueChanger().isIncrease(value);
        if (index == 7) {
            if (increase) {
                browser.selectNextResult();
            } else {
                browser.selectPreviousResult();
            }
            return;
        }
        if (increase) {
            browser.selectNextFilterItem(index);
        } else {
            browser.selectPreviousFilterItem(index);
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        if (isTouched && this.surface.isDeletePressed()) {
            this.surface.setTriggerConsumed(ButtonID.DELETE);
            IBrowser browser = this.model.getBrowser();
            if (browser != null) {
                browser.resetFilterColumn(index);
            }
        }
    }

    @Override
    public Optional<String> getSelectedItemName() {
        IBrowser browser = this.model.getBrowser();
        if (browser == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(browser.getSelectedResult());
    }

    @Override
    public void selectPreviousItem() {
        IBrowser browser = this.model.getBrowser();
        if (browser != null) {
            browser.previousContentType();
        }
    }

    @Override
    public void selectNextItem() {
        IBrowser browser = this.model.getBrowser();
        if (browser != null) {
            browser.nextContentType();
        }
    }

    @Override
    public void selectPreviousItemPage() {
        IBrowser browser = this.model.getBrowser();
        if (browser != null && browser.isActive()) {
            browser.stopBrowsing(false);
        }
    }

    @Override
    public void selectNextItemPage() {
        IBrowser browser = this.model.getBrowser();
        if (browser != null && browser.isActive()) {
            browser.stopBrowsing(true);
        }
    }

    @Override
    public void selectItem(int index) {
        IBrowser browser = this.model.getBrowser();
        if (browser == null) {
            return;
        }
        if (index == 7) {
            browser.selectNextResult();
        } else {
            browser.selectNextFilterItem(index);
        }
    }
}

