/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.mode;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class ModeSelectCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    protected final ModeManager modeManager;
    protected final Modes modeId;
    protected final boolean toggle;
    protected boolean notify;

    public ModeSelectCommand(IModel model, S surface, Modes modeId) {
        this(model, surface, modeId, false);
    }

    public ModeSelectCommand(ModeManager modeManager, IModel model, S surface, Modes modeId) {
        this(modeManager, model, surface, modeId, false);
    }

    public ModeSelectCommand(IModel model, S surface, Modes modeId, boolean toggle) {
        this(null, model, surface, modeId, toggle);
    }

    public ModeSelectCommand(ModeManager modeManager, IModel model, S surface, Modes modeId, boolean toggle) {
        this(modeManager, model, surface, modeId, toggle, true);
    }

    public ModeSelectCommand(ModeManager modeManager, IModel model, S surface, Modes modeId, boolean toggle, boolean notify) {
        super(model, surface);
        this.notify = notify;
        this.modeManager = modeManager == null ? surface.getModeManager() : modeManager;
        this.modeId = modeId;
        this.toggle = toggle;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.modeManager.isActive(new Modes[]{this.modeId})) {
            if (!this.toggle) {
                return;
            }
            this.modeManager.restore();
        } else {
            this.modeManager.setActive(this.modeId);
        }
        this.displayMode();
    }

    protected void displayMode() {
        if (this.notify) {
            this.surface.getDisplay().notify(((IMode)this.modeManager.getActive()).getName());
        }
    }
}

