/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.clip;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.utils.ButtonEvent;

public class QuantizeCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    public QuantizeCommand(IModel model, S surface) {
        super(model, surface);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (this.surface.isPressed(ButtonID.SELECT)) {
            this.selectRecordQuantization(false);
        } else {
            this.quantize();
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            this.selectRecordQuantization(true);
        }
    }

    protected void quantize() {
        INoteClip clip = this.model.getCursorClip();
        if (clip.doesExist()) {
            clip.quantize((double)this.surface.getConfiguration().getQuantizeAmount() / 100.0);
        }
    }

    protected void selectRecordQuantization(boolean next) {
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        if (cursorTrack.doesExist()) {
            if (next) {
                cursorTrack.nextRecordQuantization();
            } else {
                cursorTrack.previousRecordQuantization();
            }
            this.mvHelper.delayDisplay(() -> "Record Quantization: " + cursorTrack.getRecordQuantizationGrid().getName());
        }
    }
}

