/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.application;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class PaneCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private final Panels panel;

    public PaneCommand(Panels panel, IModel model, S surface) {
        super(model, surface);
        this.panel = panel;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        IApplication application = this.model.getApplication();
        switch (this.panel.ordinal()) {
            case 0: {
                application.toggleNoteEditor();
                break;
            }
            case 1: {
                application.toggleAutomationEditor();
                break;
            }
            case 2: {
                application.toggleDevices();
                break;
            }
            case 3: {
                application.toggleMixer();
            }
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.model.getApplication().toggleDevices();
        }
    }

    public static enum Panels {
        NOTE,
        AUTOMATION,
        DEVICE,
        MIXER;

    }
}

