/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command;

import de.mossgrabers.framework.command.core.AbstractContinuousCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.utils.ButtonEvent;

public class TempoCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractContinuousCommand<S, C>
implements TriggerCommand {
    protected final ITransport transport;
    protected final boolean doIncrease;
    protected final boolean isAbsolute;
    protected final int minTempo;
    protected final int tempoRange;
    protected boolean isTempoChange;

    public TempoCommand(IModel model, S surface) {
        this(model, surface, false, false, -1, -1);
    }

    public TempoCommand(IModel model, S surface, int minTempo, int maxTempo) {
        this(model, surface, false, true, minTempo, maxTempo);
    }

    public TempoCommand(boolean doIncrease, IModel model, S surface) {
        this(model, surface, doIncrease, false, -1, -1);
    }

    protected TempoCommand(IModel model, S surface, boolean doIncrease, boolean isAbsolute, int minTempo, int maxTempo) {
        super(model, surface);
        this.doIncrease = doIncrease;
        this.isAbsolute = isAbsolute;
        this.minTempo = minTempo == -1 ? 20 : minTempo;
        int max = maxTempo == -1 ? 666 : maxTempo;
        this.tempoRange = max - this.minTempo;
        this.transport = this.model.getTransport();
    }

    @Override
    public void execute(int value) {
        IValueChanger valueChanger = this.model.getValueChanger();
        if (this.isAbsolute) {
            double tempo = (double)this.minTempo + valueChanger.toNormalizedValue(value) * (double)this.tempoRange;
            if (!this.surface.isShiftPressed()) {
                tempo = Math.round(tempo);
            }
            this.transport.setTempo(tempo);
            return;
        }
        this.transport.changeTempo(valueChanger.isIncrease(value), this.surface.isKnobSensitivitySlow());
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event == ButtonEvent.DOWN) {
            this.isTempoChange = true;
        } else if (event == ButtonEvent.UP) {
            this.isTempoChange = false;
        }
        this.doChangeTempo();
    }

    private void doChangeTempo() {
        if (!this.isTempoChange) {
            return;
        }
        this.transport.changeTempo(this.doIncrease, this.surface.isKnobSensitivitySlow());
        this.surface.scheduleTask(this::doChangeTempo, 200L);
    }
}

