/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.mode;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOneControlSurface;
import de.mossgrabers.controller.oxi.one.mode.IOxiModeReset;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.AbstractMode;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleValueMenuComponent;
import de.mossgrabers.framework.scale.Scale;
import de.mossgrabers.framework.scale.ScaleLayout;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.TransposeView;

public class OxiOnePlayModeConfigurationMode
extends AbstractMode<OxiOneControlSurface, OxiOneConfiguration>
implements IOxiModeReset {
    private static final String[] MENU = new String[]{"Octv", "Scle", "Base", "Chro"};
    private static final String[] SHIFTED_MENU = new String[]{"Layt", "", "", ""};
    private int selectedIndex = 0;
    private final Scales scales = this.model.getScales();

    public OxiOnePlayModeConfigurationMode(OxiOneControlSurface surface, IModel model) {
        super("PlayConfiguration", surface, model, false);
    }

    @Override
    public void updateDisplay() {
        this.updateSelectedIndex();
        IGraphicDisplay display = ((OxiOneControlSurface)this.surface).getGraphicsDisplay();
        String desc = "";
        Object label = "";
        int value = -1;
        int upperBound = this.model.getValueChanger().getUpperBound();
        switch (this.selectedIndex) {
            case 0: {
                int octave = this.scales.getOctave();
                label = "Octave: " + octave;
                value = (octave + 4) / 8;
                break;
            }
            case 1: {
                Scale scale = this.scales.getScale();
                label = "Scale: " + scale.getName();
                value = (int)((double)scale.ordinal() / (double)(Scale.values().length - 1) * (double)upperBound);
                break;
            }
            case 2: {
                int scaleOffsetIndex = this.scales.getScaleOffsetIndex();
                label = "Base Note: " + Scales.BASES.get(scaleOffsetIndex);
                value = (int)((double)scaleOffsetIndex / (double)(Scales.BASES.size() - 1) * (double)upperBound);
                break;
            }
            case 3: {
                boolean chromatic = this.scales.isChromatic();
                label = chromatic ? "Chromatic" : "In-Key";
                value = chromatic ? upperBound : 0;
                break;
            }
            case 4: {
                ScaleLayout scaleLayout = this.scales.getScaleLayout();
                label = "Layout: " + scaleLayout.getName();
                value = (int)((double)scaleLayout.ordinal() / (double)(ScaleLayout.values().length - 1) * (double)upperBound);
                break;
            }
        }
        display.addElement(new TitleValueMenuComponent("", (String)label, ((OxiOneControlSurface)this.surface).isShiftPressed() ? SHIFTED_MENU : MENU, value, 0, 0, false));
        display.send();
    }

    private void updateSelectedIndex() {
        if (((OxiOneControlSurface)this.surface).isPressed(ButtonID.SHIFT)) {
            if (this.selectedIndex < 4) {
                this.selectedIndex += 4;
            }
        } else if (this.selectedIndex >= 4) {
            this.selectedIndex -= 4;
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.selectedIndex = ((OxiOneControlSurface)this.surface).isPressed(ButtonID.SHIFT) ? index + 4 : index;
    }

    @Override
    public void onKnobValue(int index, int value) {
        boolean isInc = this.model.getValueChanger().isIncrease(value);
        switch (this.selectedIndex) {
            case 0: {
                IView activeView = (IView)((OxiOneControlSurface)this.surface).getViewManager().getActive();
                if (activeView instanceof TransposeView) {
                    TransposeView transposeView = (TransposeView)((Object)activeView);
                    if (isInc) {
                        transposeView.onOctaveUp(ButtonEvent.DOWN);
                        break;
                    }
                    transposeView.onOctaveDown(ButtonEvent.DOWN);
                    break;
                }
                if (isInc) {
                    this.scales.incOctave();
                    break;
                }
                this.scales.decOctave();
                break;
            }
            case 1: {
                this.scales.changeScale(value);
                break;
            }
            case 2: {
                this.scales.setScaleOffsetByIndex(this.scales.getScaleOffsetIndex() + (isInc ? 1 : -1));
                break;
            }
            case 3: {
                this.scales.setChromatic(isInc);
                break;
            }
            case 4: {
                if (isInc) {
                    this.scales.nextScaleLayout();
                    break;
                }
                this.scales.prevScaleLayout();
                break;
            }
            default: {
                return;
            }
        }
        this.updateScaleProperties();
    }

    protected void updateScaleProperties() {
        this.scales.updateScaleProperties((Configuration)((OxiOneControlSurface)this.surface).getConfiguration());
    }

    @Override
    public void resetValue(int index) {
        switch (this.selectedIndex) {
            case 0: {
                IView activeView = (IView)((OxiOneControlSurface)this.surface).getViewManager().getActive();
                if (activeView instanceof TransposeView) {
                    TransposeView transposeView = (TransposeView)((Object)activeView);
                    transposeView.resetOctave();
                    break;
                }
                this.scales.setOctave(2);
                break;
            }
            case 1: {
                this.scales.setScale(Scale.MAJOR);
                break;
            }
            case 2: {
                this.scales.setScaleOffsetByIndex(0);
                break;
            }
            case 3: {
                this.scales.setChromatic(false);
                break;
            }
            case 4: {
                this.scales.setScaleLayout(ScaleLayout.FOURTH_UP);
                break;
            }
        }
    }
}

