/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.definition;

import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.novation.launchpad.definition.AbstractLaunchpadDefinition;
import de.mossgrabers.controller.novation.launchpad.definition.button.LaunchpadButton;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class LaunchpadMkIIControllerDefinition
extends AbstractLaunchpadDefinition {
    private static final UUID EXTENSION_ID = UUID.fromString("4E01A0B0-67B1-11E5-A837-0800200C9A66");
    private static final String SYSEX_HEADER = "F0 00 20 29 02 18 ";

    public LaunchpadMkIIControllerDefinition() {
        super(EXTENSION_ID, "Launchpad MkII");
        this.buttonSetup.setButton(LaunchpadButton.SHIFT, 111);
        this.buttonSetup.setButton(LaunchpadButton.ARROW_UP, 104);
        this.buttonSetup.setButton(LaunchpadButton.ARROW_DOWN, 105);
        this.buttonSetup.setButton(LaunchpadButton.ARROW_LEFT, 106);
        this.buttonSetup.setButton(LaunchpadButton.ARROW_RIGHT, 107);
        this.buttonSetup.setButton(LaunchpadButton.SESSION, 108);
        this.buttonSetup.setButton(LaunchpadButton.NOTE, 109);
        this.buttonSetup.setButton(LaunchpadButton.DEVICE, 110);
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        List<Pair<String[], String[]>> midiDiscoveryPairs = super.getMidiDiscoveryPairs(os);
        midiDiscoveryPairs.addAll(this.createDeviceDiscoveryPairs("Launchpad MK2"));
        return midiDiscoveryPairs;
    }

    @Override
    public String getSysExHeader() {
        return SYSEX_HEADER;
    }

    @Override
    public String getStandaloneModeCommand() {
        return "21 01";
    }

    @Override
    public String getProgramModeCommand() {
        return "22 00";
    }

    @Override
    public void resetMode(LaunchpadControlSurface surface) {
    }

    @Override
    public void setLogoColor(LaunchpadControlSurface surface, int color) {
    }

    @Override
    public boolean sceneButtonsUseCC() {
        return false;
    }

    @Override
    public List<String> buildLEDUpdate(Map<Integer, LightInfo> padInfos) {
        StringBuilder sbNormal = new StringBuilder();
        StringBuilder sbFlash = new StringBuilder();
        StringBuilder sbPulse = new StringBuilder();
        for (Map.Entry<Integer, LightInfo> e : padInfos.entrySet()) {
            int note = e.getKey();
            LightInfo info = e.getValue();
            sbNormal.append(StringUtils.toHexStr(note)).append(' ').append(StringUtils.toHexStr(info.getColor())).append(' ');
            if (info.getBlinkColor() <= 0) continue;
            if (info.isFast()) {
                sbFlash.append("00 ").append(StringUtils.toHexStr(note)).append(' ').append(StringUtils.toHexStr(info.getBlinkColor())).append(' ');
                continue;
            }
            sbPulse.append("00 ").append(StringUtils.toHexStr(note)).append(' ').append(StringUtils.toHexStr(info.getBlinkColor())).append(' ');
        }
        ArrayList<String> result = new ArrayList<String>(3);
        String sysExHeader = this.getSysExHeader();
        if (sbNormal.length() > 0) {
            result.add(sysExHeader + "0A " + sbNormal + "F7");
        }
        if (sbFlash.length() > 0) {
            result.add(sysExHeader + "23 " + sbFlash + "F7");
        }
        if (sbPulse.length() > 0) {
            result.add(sysExHeader + "28 " + sbPulse + "F7");
        }
        return result;
    }
}

