/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.mode.buttons;

import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLDrumSequencerMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLTemporaryButtonMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.main.XLBaseNoteEditMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class XLSequencerResolutionMode
extends XLTemporaryButtonMode {
    public XLSequencerResolutionMode(LaunchControlXLControlSurface surface, IModel model) {
        super("Step Resolution", surface, model);
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (row != 0 || event != ButtonEvent.DOWN) {
            return;
        }
        this.getClip().setStepLength(Resolution.getValueAt(index));
        this.setResolution(index);
        this.model.getHost().showNotification("Step Resolution: " + Resolution.getNameAt(index));
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = buttonID.ordinal() - ButtonID.ROW2_1.ordinal();
        if (index < 0 || index >= 8) {
            return 12;
        }
        return index == this.getResolution() ? 60 : 28;
    }

    private INoteClip getClip() {
        return ((XLBaseNoteEditMode)((LaunchControlXLControlSurface)this.surface).getModeManager().get(Modes.NOTE_SEQUENCER)).getClip();
    }

    private int getResolution() {
        return ((XLDrumSequencerMode)((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().get(Modes.DRUM_SEQUENCER)).getSelectedResolutionIndex();
    }

    private void setResolution(int resolutionIndex) {
        ((XLDrumSequencerMode)((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().get(Modes.DRUM_SEQUENCER)).setSelectedResolutionIndex(resolutionIndex);
    }
}

