/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol;

import de.mossgrabers.controller.novation.launchcontrol.LaunchControlXLConfiguration;
import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLColorManager;
import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.controller.novation.launchcontrol.mode.IXLMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.XLDummyMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLDrumSequencerMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLLayerMuteMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLLayerSoloMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLLoopLengthMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLNoteSequencerMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLScenesMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLSelectDeviceParamsPageMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLSequencerResolutionMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLTrackMuteMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLTrackRecArmMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLTrackSoloMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLTransportMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.faders.XLEqGainMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.faders.XLLayerVolumeMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.main.XLDrumPadEditMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.main.XLEqMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.main.XLLayerMixMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.main.XLNoteEditMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.main.XLTrackMixMode;
import de.mossgrabers.framework.command.continuous.KnobRowModeCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.command.trigger.mode.ButtonRowModeCommand;
import de.mossgrabers.framework.command.trigger.mode.ModeCursorCommand;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwAbsoluteKnob;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.controller.hardware.IHwFader;
import de.mossgrabers.framework.controller.valuechanger.TwosComplementValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.DummyMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.mode.track.MasterAndFXVolumeMode;
import de.mossgrabers.framework.mode.track.TrackVolumeMode;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;

public class LaunchControlXLControllerSetup
extends AbstractControllerSetup<LaunchControlXLControlSurface, LaunchControlXLConfiguration> {
    private static final List<ContinuousID> FADER_IDS = ContinuousID.createSequentialList(ContinuousID.FADER1, 8);
    private static final List<ContinuousID> KNOB_CONTROLS = new ArrayList<ContinuousID>(24);
    private final IHwAbsoluteKnob[] sendAKnobs = new IHwAbsoluteKnob[8];
    private final IHwAbsoluteKnob[] sendBKnobs = new IHwAbsoluteKnob[8];
    private final IHwAbsoluteKnob[] panKnobs = new IHwAbsoluteKnob[8];
    private final IHwFader[] faders = new IHwFader[8];
    private final Map<ButtonID, Integer> buttonControls = new EnumMap<ButtonID, Integer>(ButtonID.class);

    public LaunchControlXLControllerSetup(IHost host, ISetupFactory factory, ISettingsUI globalSettings, ISettingsUI documentSettings) {
        super(factory, host, globalSettings, documentSettings);
        this.colorManager = new LaunchControlXLColorManager();
        this.valueChanger = new TwosComplementValueChanger(128, 1);
        this.configuration = new LaunchControlXLConfiguration(host, this.valueChanger, factory.getArpeggiatorModes());
    }

    @Override
    protected void createModel() {
        ModelSetup ms = new ModelSetup();
        ms.setHasFlatTrackList(true);
        ms.setHasFullFlatTrackList(((LaunchControlXLConfiguration)this.configuration).areMasterTracksIncluded());
        ms.setNumSends(2);
        ms.setNumDrumPadLayers(8);
        ms.enableDevice(DeviceID.EQ);
        ms.enableDevice(DeviceID.FIRST_INSTRUMENT);
        this.model = this.factory.createModel(this.configuration, this.colorManager, this.valueChanger, this.scales, ms);
        this.model.getTrackBank().setIndication(true);
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput();
        IMidiInput input = midiAccess.createInput("User Templates", "B0????", "B1????", "B2????", "B3????", "B4????", "B5????", "B6????", "B7????", "90????", "91????", "92????", "93????", "94????", "95????", "96????", "97????", "80????", "81????", "82????", "83????", "84????", "85????", "86????", "87????");
        this.surfaces.add(new LaunchControlXLControlSurface(this.host, this.colorManager, (LaunchControlXLConfiguration)this.configuration, output, input));
    }

    @Override
    protected void createObservers() {
        super.createObservers();
        ((LaunchControlXLConfiguration)this.configuration).registerDeactivatedItemsHandler(this.model);
        this.createScaleObservers((LaunchControlXLConfiguration)this.configuration);
        ((LaunchControlXLConfiguration)this.configuration).addSettingObserver(LaunchControlXLConfiguration.ACTIVE_TEMPLATE, this::activateTemplate);
    }

    @Override
    protected void createModes() {
        LaunchControlXLControlSurface surface = (LaunchControlXLControlSurface)this.getSurface();
        this.createButton(ButtonID.REC_ARM, "REC ARM", new ButtonRowModeCommand(2, 3, this.model, surface), 108, () -> this.getModeColor(ButtonID.REC_ARM));
        ModeManager modeManager = surface.getModeManager();
        modeManager.register(Modes.SEND, new XLTrackMixMode(surface, this.model, KNOB_CONTROLS));
        modeManager.register(Modes.EQ_DEVICE_PARAMS, new XLEqMode(surface, this.model, KNOB_CONTROLS));
        modeManager.register(Modes.DEVICE_LAYER, new XLLayerMixMode(surface, this.model, KNOB_CONTROLS));
        XLDrumPadEditMode drumPadEditMode = new XLDrumPadEditMode(surface, this.model, 127, 8, KNOB_CONTROLS);
        modeManager.register(Modes.DRUM_SEQUENCER, drumPadEditMode);
        XLNoteEditMode noteEditMode = new XLNoteEditMode(surface, this.model, 127, 8, KNOB_CONTROLS);
        modeManager.register(Modes.NOTE_SEQUENCER, noteEditMode);
        modeManager.register(Modes.DUMMY, new XLDummyMode(surface, this.model, KNOB_CONTROLS));
        ModeManager trackModeManager = surface.getTrackButtonModeManager();
        trackModeManager.register(Modes.MUTE, new XLTrackMuteMode(surface, this.model));
        trackModeManager.register(Modes.SOLO, new XLTrackSoloMode(surface, this.model));
        trackModeManager.register(Modes.REC_ARM, new XLTrackRecArmMode(surface, this.model));
        trackModeManager.register(Modes.DEVICE_PARAMS, new XLSelectDeviceParamsPageMode(surface, this.model, this.model.getCursorDevice()));
        trackModeManager.register(Modes.INSTRUMENT_DEVICE_PARAMS, new XLSelectDeviceParamsPageMode(surface, this.model, this.model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT)));
        trackModeManager.register(Modes.TRANSPORT, new XLTransportMode(surface, this.model));
        trackModeManager.register(Modes.CLIP, new XLScenesMode(surface, this.model));
        trackModeManager.register(Modes.DEVICE_LAYER_MUTE, new XLLayerMuteMode(surface, this.model));
        trackModeManager.register(Modes.DEVICE_LAYER_SOLO, new XLLayerSoloMode(surface, this.model));
        trackModeManager.register(Modes.DRUM_SEQUENCER, new XLDrumSequencerMode(surface, this.model));
        trackModeManager.register(Modes.NOTE_SEQUENCER, new XLNoteSequencerMode(surface, this.model));
        trackModeManager.register(Modes.LOOP_LENGTH, new XLLoopLengthMode(surface, this.model));
        trackModeManager.register(Modes.CONFIGURATION, new XLSequencerResolutionMode(surface, this.model));
        ModeManager faderManager = surface.getFaderModeManager();
        faderManager.register(Modes.VOLUME, new TrackVolumeMode(surface, this.model, true, FADER_IDS));
        faderManager.register(Modes.MASTER, new MasterAndFXVolumeMode(surface, this.model, true, FADER_IDS));
        faderManager.register(Modes.EQ_DEVICE_PARAMS, new XLEqGainMode(surface, this.model, FADER_IDS));
        faderManager.register(Modes.DEVICE_LAYER, new XLLayerVolumeMode(surface, this.model, FADER_IDS));
        faderManager.register(Modes.DRUM_SEQUENCER, drumPadEditMode);
        faderManager.register(Modes.NOTE_SEQUENCER, noteEditMode);
        faderManager.register(Modes.DUMMY, new DummyMode(surface, this.model, FADER_IDS));
    }

    @Override
    protected void registerTriggerCommands() {
        LaunchControlXLControlSurface surface = (LaunchControlXLControlSurface)this.getSurface();
        ModeManager trackModeManager = surface.getTrackButtonModeManager();
        ModeCursorCommand upCommand = new ModeCursorCommand(Direction.LEFT, this.model, surface, false);
        this.createButton(ButtonID.MOVE_BANK_LEFT, "Send Previous", upCommand, 104, upCommand::canScroll);
        ModeCursorCommand downCommand = new ModeCursorCommand(Direction.RIGHT, this.model, surface, false);
        this.createButton(ButtonID.MOVE_BANK_RIGHT, "Send Next", downCommand, 105, downCommand::canScroll);
        ModeCursorCommand leftCommand = new ModeCursorCommand(Direction.DOWN, this.model, surface, false);
        this.createButton(ButtonID.MOVE_TRACK_LEFT, "Previous", leftCommand, 106, leftCommand::canScroll);
        ModeCursorCommand rightCommand = new ModeCursorCommand(Direction.UP, this.model, surface, false);
        this.createButton(ButtonID.MOVE_TRACK_RIGHT, "Next", rightCommand, 107, rightCommand::canScroll);
        this.createButton(ButtonID.DEVICE, "DEVICE", new ButtonRowModeCommand(2, 0, this.model, surface), 105, () -> this.getModeColor(ButtonID.DEVICE));
        this.createButton(ButtonID.MUTE, "MUTE", new ButtonRowModeCommand(2, 1, this.model, surface), 106, () -> this.getModeColor(ButtonID.MUTE));
        this.createButton(ButtonID.SOLO, "SOLO", new ButtonRowModeCommand(2, 2, this.model, surface), 107, () -> this.getModeColor(ButtonID.SOLO));
        for (int i = 0; i < 4; ++i) {
            int j = 4 + i;
            ButtonID row1ButtonID = ButtonID.get(ButtonID.ROW1_1, i);
            this.createButton(row1ButtonID, "Row 1: " + (i + 1), new ButtonRowModeCommand(0, i, this.model, surface), 41 + i, () -> this.getModeColor(row1ButtonID));
            ButtonID row14ButtonID = ButtonID.get(ButtonID.ROW1_1, j);
            this.createButton(row14ButtonID, "Row 1: " + (j + 1), new ButtonRowModeCommand(0, j, this.model, surface), 57 + i, () -> this.getModeColor(row14ButtonID));
            ButtonID row2ButtonID = ButtonID.get(ButtonID.ROW2_1, i);
            this.createButton(row2ButtonID, "Row 2: " + (i + 1), new ButtonRowModeCommand(trackModeManager, 0, i, this.model, surface), 73 + i, () -> this.getTrackModeColor(row2ButtonID));
            ButtonID row24ButtonID = ButtonID.get(ButtonID.ROW2_1, j);
            this.createButton(row24ButtonID, "Row 2: " + (j + 1), new ButtonRowModeCommand(trackModeManager, 0, j, this.model, surface), 89 + i, () -> this.getTrackModeColor(row24ButtonID));
        }
    }

    @Override
    protected BindType getTriggerBindType(ButtonID buttonID) {
        if (buttonID == ButtonID.MOVE_TRACK_LEFT || buttonID == ButtonID.MOVE_TRACK_RIGHT || buttonID == ButtonID.MOVE_BANK_LEFT || buttonID == ButtonID.MOVE_BANK_RIGHT) {
            return BindType.CC;
        }
        return BindType.NOTE;
    }

    @Override
    protected void registerContinuousCommands() {
        LaunchControlXLControlSurface surface = (LaunchControlXLControlSurface)this.getSurface();
        for (int i = 0; i < 8; ++i) {
            int index = i;
            this.sendAKnobs[i] = surface.createAbsoluteKnob(ContinuousID.get(ContinuousID.SEND1_KNOB1, i), "Send A Knob " + (i + 1));
            this.sendAKnobs[i].bind(new KnobRowModeCommand(i, this.model, surface));
            this.sendAKnobs[i].setIndexInGroup(i);
            this.sendAKnobs[i].addOutput(() -> this.getKnobValue(0, index), value -> this.setKnobRowColor(0, index, value));
            this.sendBKnobs[i] = surface.createAbsoluteKnob(ContinuousID.get(ContinuousID.SEND2_KNOB1, i), "Send B Knob " + (i + 1));
            this.sendBKnobs[i].bind(new KnobRowModeCommand(8 + i, this.model, surface));
            this.sendBKnobs[i].setIndexInGroup(i);
            this.sendBKnobs[i].addOutput(() -> this.getKnobValue(8, index), value -> this.setKnobRowColor(1, index, value));
            this.panKnobs[i] = surface.createAbsoluteKnob(ContinuousID.get(ContinuousID.PAN_KNOB1, i), "Pan Knob " + (i + 1));
            this.panKnobs[i].bind(new KnobRowModeCommand(16 + i, this.model, surface));
            this.panKnobs[i].setIndexInGroup(i);
            this.panKnobs[i].addOutput(() -> this.getKnobValue(16, index), value -> this.setKnobRowColor(2, index, value));
            this.faders[i] = surface.createFader(ContinuousID.get(ContinuousID.FADER1, i), "Fader " + (i + 1), true);
            this.faders[i].bind(new KnobRowModeCommand(24 + i, this.model, surface));
            this.faders[i].setIndexInGroup(i);
        }
    }

    private void bindToTemplate() {
        LaunchControlXLControlSurface surface = (LaunchControlXLControlSurface)this.getSurface();
        int midiChannel = ((LaunchControlXLConfiguration)this.configuration).getTemplate();
        if (midiChannel < 0) {
            return;
        }
        IMidiInput midiInput = surface.getMidiInput();
        for (int i = 0; i < 8; ++i) {
            this.sendAKnobs[i].bind(midiInput, BindType.CC, midiChannel, 13 + i);
            this.sendBKnobs[i].bind(midiInput, BindType.CC, midiChannel, 29 + i);
            this.panKnobs[i].bind(midiInput, BindType.CC, midiChannel, 49 + i);
            this.faders[i].bind(midiInput, BindType.CC, midiChannel, 77 + i);
        }
        for (Map.Entry<ButtonID, IHwButton> buttonEntry : surface.getButtons().entrySet()) {
            ButtonID key = buttonEntry.getKey();
            BindType bindType = this.getTriggerBindType(key);
            Integer midiControl = this.buttonControls.get((Object)key);
            buttonEntry.getValue().bind(midiInput, bindType, midiChannel, midiControl);
        }
        surface.forceFlush();
    }

    @Override
    protected void layoutControls() {
        LaunchControlXLControlSurface surface = (LaunchControlXLControlSurface)this.getSurface();
        surface.getButton(ButtonID.MOVE_BANK_LEFT).setBounds(526.25, 21.75, 35.5, 34.75);
        surface.getButton(ButtonID.MOVE_BANK_RIGHT).setBounds(577.0, 21.0, 35.5, 34.75);
        surface.getButton(ButtonID.MOVE_TRACK_LEFT).setBounds(527.5, 71.0, 35.5, 34.75);
        surface.getButton(ButtonID.MOVE_TRACK_RIGHT).setBounds(578.25, 70.25, 35.5, 34.75);
        surface.getButton(ButtonID.MUTE).setBounds(547.25, 183.5, 46.75, 34.75);
        surface.getButton(ButtonID.SOLO).setBounds(547.25, 233.25, 46.75, 34.75);
        surface.getButton(ButtonID.REC_ARM).setBounds(547.25, 288.0, 46.75, 34.75);
        surface.getButton(ButtonID.ROW1_1).setBounds(18.5, 339.5, 37.75, 34.75);
        surface.getButton(ButtonID.ROW1_5).setBounds(271.5, 339.5, 37.75, 34.75);
        surface.getButton(ButtonID.ROW2_1).setBounds(18.5, 392.75, 37.75, 34.75);
        surface.getButton(ButtonID.ROW2_5).setBounds(271.25, 392.75, 37.75, 34.75);
        surface.getButton(ButtonID.ROW1_2).setBounds(81.75, 339.5, 37.75, 34.75);
        surface.getButton(ButtonID.ROW1_6).setBounds(334.75, 339.5, 37.75, 35.0);
        surface.getButton(ButtonID.ROW2_2).setBounds(81.75, 392.75, 37.75, 34.75);
        surface.getButton(ButtonID.ROW2_6).setBounds(334.25, 392.75, 37.75, 34.75);
        surface.getButton(ButtonID.ROW1_3).setBounds(145.0, 339.5, 37.75, 34.75);
        surface.getButton(ButtonID.ROW1_7).setBounds(398.0, 339.5, 37.75, 34.75);
        surface.getButton(ButtonID.ROW2_3).setBounds(144.75, 392.75, 37.75, 34.75);
        surface.getButton(ButtonID.ROW2_7).setBounds(397.5, 392.75, 37.75, 34.75);
        surface.getButton(ButtonID.ROW1_4).setBounds(208.25, 339.5, 37.75, 34.75);
        surface.getButton(ButtonID.ROW1_8).setBounds(461.25, 339.5, 37.75, 34.75);
        surface.getButton(ButtonID.ROW2_4).setBounds(208.0, 392.75, 37.75, 34.75);
        surface.getButton(ButtonID.ROW2_8).setBounds(460.5, 392.75, 37.75, 34.75);
        surface.getContinuous(ContinuousID.SEND1_KNOB1).setBounds(2.0, 22.0, 70.5, 34.0);
        surface.getContinuous(ContinuousID.SEND1_KNOB2).setBounds(65.5, 22.0, 70.5, 34.0);
        surface.getContinuous(ContinuousID.SEND1_KNOB3).setBounds(128.75, 22.0, 70.5, 34.0);
        surface.getContinuous(ContinuousID.SEND1_KNOB4).setBounds(192.25, 22.0, 70.5, 34.0);
        surface.getContinuous(ContinuousID.SEND1_KNOB5).setBounds(255.75, 22.0, 70.5, 34.0);
        surface.getContinuous(ContinuousID.SEND1_KNOB6).setBounds(319.25, 22.0, 70.5, 34.0);
        surface.getContinuous(ContinuousID.SEND1_KNOB7).setBounds(382.5, 22.0, 70.5, 34.0);
        surface.getContinuous(ContinuousID.SEND1_KNOB8).setBounds(446.0, 22.0, 70.5, 34.0);
        surface.getContinuous(ContinuousID.SEND2_KNOB1).setBounds(2.0, 75.0, 69.75, 34.0);
        surface.getContinuous(ContinuousID.SEND2_KNOB2).setBounds(65.25, 75.0, 69.75, 34.0);
        surface.getContinuous(ContinuousID.SEND2_KNOB3).setBounds(128.75, 75.0, 69.75, 34.0);
        surface.getContinuous(ContinuousID.SEND2_KNOB4).setBounds(192.0, 75.0, 69.75, 34.0);
        surface.getContinuous(ContinuousID.SEND2_KNOB5).setBounds(255.25, 75.0, 69.75, 34.0);
        surface.getContinuous(ContinuousID.SEND2_KNOB6).setBounds(318.75, 75.0, 69.75, 34.0);
        surface.getContinuous(ContinuousID.SEND2_KNOB7).setBounds(382.0, 75.0, 69.75, 34.0);
        surface.getContinuous(ContinuousID.SEND2_KNOB8).setBounds(445.25, 76.5, 69.75, 34.0);
        surface.getContinuous(ContinuousID.PAN_KNOB1).setBounds(2.0, 127.25, 69.75, 34.0);
        surface.getContinuous(ContinuousID.PAN_KNOB2).setBounds(65.25, 127.25, 69.75, 34.0);
        surface.getContinuous(ContinuousID.PAN_KNOB3).setBounds(128.5, 127.25, 69.75, 34.0);
        surface.getContinuous(ContinuousID.PAN_KNOB4).setBounds(191.75, 127.25, 69.75, 34.0);
        surface.getContinuous(ContinuousID.PAN_KNOB5).setBounds(255.0, 127.25, 69.75, 34.0);
        surface.getContinuous(ContinuousID.PAN_KNOB6).setBounds(318.25, 127.25, 69.75, 34.0);
        surface.getContinuous(ContinuousID.PAN_KNOB7).setBounds(381.5, 128.0, 69.75, 34.0);
        surface.getContinuous(ContinuousID.PAN_KNOB8).setBounds(444.5, 127.25, 69.75, 34.0);
        surface.getContinuous(ContinuousID.FADER1).setBounds(19.25, 190.75, 34.75, 130.25);
        surface.getContinuous(ContinuousID.FADER2).setBounds(82.5, 190.75, 34.75, 130.25);
        surface.getContinuous(ContinuousID.FADER3).setBounds(145.75, 190.75, 34.75, 130.25);
        surface.getContinuous(ContinuousID.FADER4).setBounds(209.0, 190.75, 34.75, 130.25);
        surface.getContinuous(ContinuousID.FADER5).setBounds(272.25, 190.75, 34.75, 130.25);
        surface.getContinuous(ContinuousID.FADER6).setBounds(335.5, 190.75, 34.75, 130.25);
        surface.getContinuous(ContinuousID.FADER7).setBounds(398.75, 190.75, 34.75, 130.25);
        surface.getContinuous(ContinuousID.FADER8).setBounds(462.0, 190.75, 34.75, 130.25);
    }

    @Override
    public void startup() {
        LaunchControlXLControlSurface surface = (LaunchControlXLControlSurface)this.getSurface();
        surface.getTrackButtonModeManager().setActive(Modes.MUTE);
        surface.getFaderModeManager().setActive(Modes.VOLUME);
        surface.selectTemplate(8);
    }

    protected int getTrackModeColor(ButtonID buttonID) {
        IMode mode = (IMode)((LaunchControlXLControlSurface)this.getSurface()).getTrackButtonModeManager().getActive();
        return mode == null ? 12 : mode.getButtonColor(buttonID);
    }

    private int getKnobValue(int knobOffset, int index) {
        IMode mode = (IMode)((LaunchControlXLControlSurface)this.getSurface()).getModeManager().getActive();
        return mode == null ? 0 : Math.max(0, mode.getKnobValue(knobOffset + index));
    }

    private void setKnobRowColor(int row, int column, int value) {
        ModeManager modeManager = ((LaunchControlXLControlSurface)this.getSurface()).getModeManager();
        Object f = modeManager.getActive();
        if (f instanceof IXLMode) {
            IXLMode xlMode = (IXLMode)f;
            xlMode.setKnobColor(row, column, value);
        }
    }

    private void activateTemplate() {
        Modes faderMode;
        Modes mode;
        int templateID = ((LaunchControlXLConfiguration)this.configuration).getTemplate();
        this.host.println("Switch to template: " + templateID);
        String message = switch (templateID) {
            case 8 -> {
                mode = Modes.SEND;
                faderMode = Modes.VOLUME;
                yield "Mixer";
            }
            case 9 -> {
                mode = Modes.EQ_DEVICE_PARAMS;
                faderMode = Modes.EQ_DEVICE_PARAMS;
                yield "Equalizer";
            }
            case 10 -> {
                mode = Modes.DEVICE_LAYER;
                faderMode = Modes.DEVICE_LAYER;
                yield "Layer Mixer";
            }
            case 11 -> {
                mode = Modes.DRUM_SEQUENCER;
                faderMode = Modes.DRUM_SEQUENCER;
                yield "Drum Sequencer";
            }
            case 12 -> {
                mode = Modes.NOTE_SEQUENCER;
                faderMode = Modes.NOTE_SEQUENCER;
                yield "Note Sequencer";
            }
            default -> {
                mode = Modes.DUMMY;
                faderMode = Modes.DUMMY;
                yield "";
            }
        };
        LaunchControlXLControlSurface surface = (LaunchControlXLControlSurface)this.getSurface();
        surface.getModeManager().setActive(mode);
        surface.getFaderModeManager().setActive(faderMode);
        if (templateID >= 8) {
            this.bindToTemplate();
            if (message.length() > 0) {
                this.host.showNotification("Selected Mode: " + message);
            }
        }
    }

    private void createButton(ButtonID buttonID, String label, TriggerCommand command, int midiControl, BooleanSupplier supplier) {
        this.createButton(buttonID, label, command, midiControl, () -> supplier.getAsBoolean() ? 127 : 0);
    }

    private void createButton(ButtonID buttonID, String label, TriggerCommand command, int midiControl, IntSupplier supplier) {
        this.buttonControls.put(buttonID, midiControl);
        LaunchControlXLControlSurface surface = (LaunchControlXLControlSurface)this.getSurface();
        IHwButton button = surface.createButton(buttonID, label);
        button.bind(command);
        IntSupplier intSupplier = () -> button.isPressed() ? 1 : 0;
        IntSupplier supp = supplier == null ? intSupplier : supplier;
        BindType bindType = this.getTriggerBindType(buttonID);
        surface.createLight(null, supp, color -> surface.setTrigger(bindType, ((LaunchControlXLConfiguration)this.configuration).getTemplate(), midiControl, color), state -> this.colorManager.getColor(state, buttonID), button);
    }

    static {
        KNOB_CONTROLS.addAll(ContinuousID.createSequentialList(ContinuousID.SEND1_KNOB1, 8));
        KNOB_CONTROLS.addAll(ContinuousID.createSequentialList(ContinuousID.SEND2_KNOB1, 8));
        KNOB_CONTROLS.addAll(ContinuousID.createSequentialList(ContinuousID.PAN_KNOB1, 8));
    }
}

