/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.view;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.view.BaseView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.ISessionAlternative;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.utils.ButtonEvent;

public class SceneView
extends BaseView
implements ISessionAlternative {
    private boolean wasAlternateInteractionUsed = false;

    public SceneView(MaschineControlSurface surface, IModel model) {
        super("Scene", surface, model);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        super.onGridNote(note, velocity);
        if (((MaschineControlSurface)this.surface).isShiftPressed()) {
            this.wasAlternateInteractionUsed = true;
        }
    }

    @Override
    public void executeFunction(int padIndex, ButtonEvent buttonEvent) {
        boolean isDown = buttonEvent == ButtonEvent.DOWN;
        IScene scene = (IScene)this.model.getSceneBank().getItem(padIndex);
        if (isDown) {
            if (this.isButtonCombination(ButtonID.SCENE1)) {
                this.model.getTrackBank().stop(((MaschineControlSurface)this.surface).isShiftPressed());
                return;
            }
            if (this.isButtonCombination(ButtonID.DUPLICATE)) {
                scene.duplicate();
                return;
            }
            if (this.isButtonCombination(ButtonID.DELETE)) {
                scene.remove();
                return;
            }
            if (this.isButtonCombination(ButtonID.SELECT)) {
                scene.select();
                return;
            }
            if (((MaschineConfiguration)((MaschineControlSurface)this.surface).getConfiguration()).isSelectClipOnLaunch()) {
                scene.select();
            }
        }
        scene.launch(isDown, ((MaschineControlSurface)this.surface).isShiftPressed());
    }

    @Override
    public void drawGrid() {
        IPadGrid padGrid = ((MaschineControlSurface)this.surface).getPadGrid();
        ISceneBank sceneBank = this.model.getSceneBank();
        for (int i = 0; i < 16; ++i) {
            IScene item = (IScene)sceneBank.getItem(i);
            int x = i % 4;
            int y = 3 - i / 4;
            if (item.doesExist()) {
                if (item.isSelected()) {
                    padGrid.lightEx(x, y, 78);
                    continue;
                }
                padGrid.lightEx(x, y, DAWColor.getColorID(item.getColor()));
                continue;
            }
            padGrid.lightEx(x, y, "BUTTON_COLOR_OFF");
        }
    }

    @Override
    public boolean wasAlternateInteractionUsed() {
        return this.wasAlternateInteractionUsed;
    }

    @Override
    public void setAlternateInteractionUsed(boolean wasUsed) {
        this.wasAlternateInteractionUsed = wasUsed;
    }
}

