/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.mode;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.daw.midi.INoteInput;
import de.mossgrabers.framework.daw.midi.INoteRepeat;
import de.mossgrabers.framework.utils.StringUtils;

public class NoteRepeatMode
extends BaseMode {
    private final IHost host;
    private final INoteRepeat noteRepeat;

    public NoteRepeatMode(MaschineControlSurface surface, IModel model) {
        super("Note Repeat", surface, model);
        this.host = this.model.getHost();
        INoteInput defaultNoteInput = surface.getMidiInput().getDefaultNoteInput();
        this.noteRepeat = defaultNoteInput == null ? null : defaultNoteInput.getNoteRepeat();
    }

    @Override
    public void onKnobValue(int index, int value) {
        int idx = index < 0 ? this.selectedParam : index;
        MaschineConfiguration configuration = (MaschineConfiguration)((MaschineControlSurface)this.surface).getConfiguration();
        IValueChanger valueChanger = this.model.getValueChanger();
        switch (idx) {
            case 0: 
            case 1: {
                int sel = Resolution.change(Resolution.getMatch(configuration.getNoteRepeatPeriod().getValue()), valueChanger.isIncrease(value));
                configuration.setNoteRepeatPeriod(Resolution.values()[sel]);
                break;
            }
            case 2: 
            case 3: {
                if (!this.host.supports(Capability.NOTE_REPEAT_LENGTH)) break;
                int sel2 = Resolution.change(Resolution.getMatch(configuration.getNoteRepeatLength().getValue()), valueChanger.calcKnobChange(value) > 0.0);
                configuration.setNoteRepeatLength(Resolution.values()[sel2]);
                break;
            }
            case 4: 
            case 5: {
                if (!this.host.supports(Capability.NOTE_REPEAT_MODE)) break;
                configuration.setPrevNextNoteRepeatMode(valueChanger.isIncrease(value));
                break;
            }
            case 6: 
            case 7: {
                if (!this.host.supports(Capability.NOTE_REPEAT_OCTAVES)) break;
                configuration.setNoteRepeatOctave(configuration.getNoteRepeatOctave() + (valueChanger.calcKnobChange(value) > 0.0 ? 1 : -1));
                break;
            }
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        if (isTouched && ((MaschineControlSurface)this.surface).isDeletePressed()) {
            ((MaschineControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            MaschineConfiguration configuration = (MaschineConfiguration)((MaschineControlSurface)this.surface).getConfiguration();
            switch (index) {
                case 0: 
                case 1: {
                    configuration.setNoteRepeatPeriod(Resolution.values()[4]);
                    break;
                }
                case 2: 
                case 3: {
                    if (!this.host.supports(Capability.NOTE_REPEAT_LENGTH)) break;
                    configuration.setNoteRepeatLength(Resolution.values()[4]);
                    break;
                }
                case 4: 
                case 5: {
                    if (!this.host.supports(Capability.NOTE_REPEAT_MODE)) break;
                    this.noteRepeat.setMode(ArpeggiatorMode.UP);
                    break;
                }
                case 6: 
                case 7: {
                    if (!this.host.supports(Capability.NOTE_REPEAT_OCTAVES)) break;
                    this.noteRepeat.setOctaves(1);
                    break;
                }
            }
        }
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((MaschineControlSurface)this.surface).getTextDisplay().clear();
        String[] names = Resolution.getNames();
        int selPeriodIndex = this.getSelectedPeriodIndex();
        d.setBlock(0, 0, this.mark("Period", 0));
        d.setBlock(1, 0, names[selPeriodIndex >= 0 && selPeriodIndex < names.length ? selPeriodIndex : 0]);
        if (this.host.supports(Capability.NOTE_REPEAT_LENGTH)) {
            int selLengthIndex = this.getSelectedNoteLengthIndex();
            d.setBlock(0, 1, this.mark("Length", 2));
            d.setBlock(1, 1, names[selLengthIndex >= 0 && selLengthIndex < names.length ? selLengthIndex : 0]);
        }
        if (this.host.supports(Capability.NOTE_REPEAT_MODE)) {
            ArpeggiatorMode mode = this.noteRepeat.getMode();
            d.setBlock(0, 2, this.mark("Mode", 4));
            d.setBlock(1, 2, StringUtils.optimizeName(mode.getName(), 12));
        }
        if (this.host.supports(Capability.NOTE_REPEAT_OCTAVES)) {
            int octaves = this.noteRepeat.getOctaves();
            d.setBlock(0, 3, this.mark("Octaves", 6));
            d.setBlock(1, 3, Integer.toString(octaves));
        }
        d.allDone();
    }

    private int getSelectedPeriodIndex() {
        return this.noteRepeat == null ? -1 : Resolution.getMatch(this.noteRepeat.getPeriod());
    }

    private int getSelectedNoteLengthIndex() {
        return this.noteRepeat == null ? -1 : Resolution.getMatch(this.noteRepeat.getNoteLength());
    }

    @Override
    public void selectPreviousItem() {
        super.selectPreviousItem();
        if (this.selectedParam % 2 == 1) {
            --this.selectedParam;
        }
    }

    @Override
    public void selectNextItem() {
        super.selectNextItem();
        if (this.selectedParam % 2 == 1) {
            ++this.selectedParam;
        }
        if (this.selectedParam > 6) {
            this.selectedParam = 6;
        }
    }
}

