/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam.view;

import de.mossgrabers.controller.ni.maschine.jam.MaschineJamConfiguration;
import de.mossgrabers.controller.ni.maschine.jam.controller.MaschineJamControlSurface;
import de.mossgrabers.controller.ni.maschine.jam.view.IViewNavigation;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractDrum64View;

public class Drum64View
extends AbstractDrum64View<MaschineJamControlSurface, MaschineJamConfiguration>
implements IViewNavigation {
    public Drum64View(MaschineJamControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    protected void handleButtonCombinations(int playedPad) {
        if (this.isButtonCombination(ButtonID.BROWSE)) {
            IDrumDevice primary = this.model.getDrumDevice(64);
            if (primary.hasDrumPads()) {
                this.model.getBrowser().replace(primary.getDrumPadBank().getItem(playedPad));
            }
            return;
        }
        super.handleButtonCombinations(playedPad);
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        switch (buttonID) {
            case ARROW_LEFT: 
            case ARROW_RIGHT: {
                break;
            }
            case ARROW_UP: {
                this.onOctaveUp(event);
                break;
            }
            case ARROW_DOWN: {
                this.onOctaveDown(event);
                break;
            }
            default: {
                super.onButton(buttonID, event, velocity);
            }
        }
    }

    @Override
    public boolean canScroll(Direction direction) {
        switch (direction) {
            case UP: {
                return this.isOctaveUpButtonOn();
            }
            case DOWN: {
                return this.isOctaveDownButtonOn();
            }
        }
        return false;
    }
}

