/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.mode.device;

import de.mossgrabers.controller.mackie.mcu.MCUConfiguration;
import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mackie.mcu.mode.BaseMode;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.bank.IBank;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.observer.IObserverManagement;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.RangeFilterParameterProvider;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Arrays;
import java.util.Optional;

public class MCUTrackParametersMode
extends BaseMode<IParameter> {
    public MCUTrackParametersMode(MCUControlSurface surface, IModel model) {
        super("Track Parameters", surface, model, model.getCursorTrack().getParameterBank());
        int surfaceID = surface.getSurfaceID();
        this.setParameterProvider(new RangeFilterParameterProvider(new BankParameterProvider(model.getCursorTrack().getParameterBank()), surfaceID * 8, 8));
    }

    @Override
    public void onKnobValue(int index, int value) {
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        ((IParameter)this.bank.getItem(extenderOffset + index)).changeValue(value);
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        IParameter param = (IParameter)this.bank.getItem(index);
        if (param.doesExist()) {
            param.touchValue(isTouched);
        }
    }

    @Override
    public void updateDisplay() {
        IBank iBank;
        IObserverManagement param;
        this.drawDisplay2();
        ITextDisplay d = ((MCUControlSurface)this.surface).getTextDisplay().clear();
        ColorEx[] colors = new ColorEx[8];
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        int textLength = this.getTextLength();
        for (int i = 0; i < 8; ++i) {
            param = (IParameter)this.bank.getItem(extenderOffset + i);
            d.setCell(0, i, param.doesExist() ? StringUtils.shortenAndFixASCII(param.getName(textLength), textLength) : "");
            d.setCell(1, i, StringUtils.shortenAndFixASCII(param.getDisplayedValue(textLength), textLength));
            colors[i] = param.doesExist() ? ColorEx.WHITE : ColorEx.BLACK;
        }
        if (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).getMainDisplayType() == MCUConfiguration.MainDisplay.ASPARION && ((MCUControlSurface)this.surface).getSurfaceID() == 0) {
            IParameterBank parameterBank;
            Optional selectedPage;
            d.clearRow(0);
            d.setCell(0, 0, "Track");
            d.setCell(0, 1, "Parameters");
            param = this.bank;
            if (param instanceof IParameterBank && (selectedPage = (parameterBank = (IParameterBank)param).getPageBank().getSelectedItem()).isPresent()) {
                d.setCell(0, 2, StringUtils.shortenAndFixASCII((String)selectedPage.get(), this.getTextLength()));
            }
        }
        d.allDone();
        ((MCUControlSurface)this.surface).sendDisplayColor(colors);
        int[] indices = new int[8];
        Arrays.fill(indices, 0);
        if (this.getExtenderOffset() == 0 && (iBank = this.bank) instanceof IParameterBank) {
            IParameterBank parameterBank = (IParameterBank)iBank;
            indices[2] = parameterBank.getPageBank().getSelectedItemIndex() + 1;
        }
        ((MCUControlSurface)this.surface).setItemIndices(indices);
    }

    @Override
    public void updateKnobLEDs() {
        int upperBound = this.model.getValueChanger().getUpperBound();
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        for (int i = 0; i < 8; ++i) {
            IParameter param = (IParameter)this.bank.getItem(extenderOffset + i);
            ((MCUControlSurface)this.surface).setKnobLED(i, 0, param.doesExist() ? Math.max(1, param.getValue()) : 0, upperBound);
        }
    }

    @Override
    protected void resetParameter(int index) {
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        this.resetParameter((IParameter)this.bank.getItem(extenderOffset + index));
    }
}

