/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.mode;

import de.mossgrabers.controller.mackie.mcu.MCUConfiguration;
import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IBank;
import de.mossgrabers.framework.daw.data.bank.ILayerBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.data.empty.EmptyTrack;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Optional;

public abstract class BaseMode<B extends IItem>
extends AbstractParameterMode<MCUControlSurface, MCUConfiguration, B> {
    protected static final ColorEx[] COLORS_WHITE = new ColorEx[]{ColorEx.WHITE, ColorEx.WHITE, ColorEx.WHITE, ColorEx.WHITE, ColorEx.WHITE, ColorEx.WHITE, ColorEx.WHITE, ColorEx.WHITE};
    protected static final int[] LED_MODES_WRAP = new int[]{2, 2, 2, 2, 2, 2, 2, 2};
    protected static final int[] LED_MODES_BOOST_CUT = new int[]{1, 1, 1, 1, 1, 1, 1, 1};
    protected final boolean pinFXtoLastDevice;
    protected final MCUConfiguration configuration;
    protected ColorEx defaultColor = ColorEx.SKY_BLUE;

    protected BaseMode(String name, MCUControlSurface surface, IModel model) {
        this(name, surface, model, null);
    }

    protected BaseMode(String name, MCUControlSurface surface, IModel model, IBank<B> bank) {
        super(name, surface, model, true, bank, DEFAULT_KNOB_IDS);
        this.configuration = (MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration();
        this.pinFXtoLastDevice = this.configuration.shouldPinFXTracksToLastController() && ((MCUControlSurface)this.surface).isLastDevice();
    }

    @Override
    protected void bindControls() {
        IParameterProvider parameterProvider;
        if (!this.isActive || this.defaultParameterProvider == null) {
            return;
        }
        super.bindControls();
        if (this.configuration.useFadersAsKnobs()) {
            parameterProvider = this.getParameterProvider();
        } else {
            ModeManager modeManager = ((MCUControlSurface)this.surface).getModeManager();
            boolean isLayerMode = Modes.isLayerMode((Modes)((Object)((MCUControlSurface)this.surface).getModeManager().getActiveID()));
            parameterProvider = ((AbstractParameterMode)modeManager.get(isLayerMode ? Modes.DEVICE_LAYER_VOLUME : Modes.VOLUME)).getParameterProvider();
        }
        if (parameterProvider != null) {
            for (int i = 0; i < this.controls.size(); ++i) {
                ((MCUControlSurface)this.surface).getContinuous(ContinuousID.get(ContinuousID.FADER1, i)).bind(parameterProvider.get(i));
            }
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        IParameter parameter;
        this.setTouchedKnob(index, isTouched);
        IParameterProvider parameterProvider = this.getParameterProvider();
        if (parameterProvider != null && (parameter = parameterProvider.get(index)).doesExist()) {
            parameter.touchValue(isTouched);
        }
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (row == 0) {
            this.resetParameter(index);
            return;
        }
        ITrackBank tb = this.getTrackBank();
        ITrack track = (ITrack)tb.getItem(this.getExtenderOffset() + index);
        if (row == 1) {
            if (((MCUControlSurface)this.surface).isShiftPressed()) {
                tb.toggleRecArm();
            } else {
                track.toggleRecArm();
            }
        } else if (row == 2) {
            if (((MCUControlSurface)this.surface).isShiftPressed()) {
                track.toggleAutoMonitor();
            } else if (((MCUControlSurface)this.surface).isSelectPressed()) {
                this.model.getProject().clearSolo();
            } else {
                track.toggleSolo();
            }
        } else if (row == 3) {
            if (((MCUControlSurface)this.surface).isShiftPressed()) {
                track.toggleMonitor();
            } else if (((MCUControlSurface)this.surface).isSelectPressed()) {
                this.model.getProject().clearMute();
            } else {
                track.toggleMute();
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        ITrackBank tb = this.getTrackBank();
        int extenderOffset = this.getExtenderOffset();
        for (int i = 0; i < 8; ++i) {
            ITrack track = (ITrack)tb.getItem(extenderOffset + i);
            boolean exists = track.doesExist();
            if (buttonID == ButtonID.get(ButtonID.ROW_SELECT_1, i)) {
                return exists && track.isSelected() ? 127 : 0;
            }
            if (buttonID == ButtonID.get(ButtonID.ROW2_1, i)) {
                return exists && track.isRecArm() ? 127 : 0;
            }
            if (buttonID == ButtonID.get(ButtonID.ROW3_1, i)) {
                return exists && track.isSolo() ? 127 : 0;
            }
            if (buttonID != ButtonID.get(ButtonID.ROW4_1, i)) continue;
            return exists && track.isMute() ? 127 : 0;
        }
        return 0;
    }

    protected void resetParameter(int index) {
        IParameterProvider parameterProvider = this.getParameterProvider();
        if (parameterProvider != null) {
            this.resetParameter(parameterProvider.get(index));
        }
    }

    protected void resetParameter(IParameter parameter) {
        if (((MCUControlSurface)this.surface).isPressed(ButtonID.CONTROL)) {
            parameter.setNormalizedValue(0.0);
        } else if (((MCUControlSurface)this.surface).isShiftPressed()) {
            parameter.setNormalizedValue(0.5);
        } else if (((MCUControlSurface)this.surface).isPressed(ButtonID.ALT)) {
            parameter.setNormalizedValue(1.0);
        } else if (((MCUControlSurface)this.surface).isSelectPressed()) {
            if (parameter instanceof ISend) {
                ISend send = (ISend)parameter;
                send.toggleEnabled();
            }
        } else {
            parameter.resetValue();
        }
    }

    public void updateKnobLEDs() {
        this.updateKnobLEDs(LED_MODES_WRAP);
    }

    protected void updateKnobLEDs(int[] knobLedModes) {
        IParameterProvider parameterProvider = this.getParameterProvider();
        if (parameterProvider == null) {
            return;
        }
        int upperBound = this.model.getValueChanger().getUpperBound();
        for (int i = 0; i < 8; ++i) {
            IParameter parameter = parameterProvider.get(i);
            if (parameter.doesExist()) {
                int value = parameter.getValue();
                if (knobLedModes[i] == 1 && value == 0) {
                    value = 1;
                }
                ((MCUControlSurface)this.surface).setKnobLED(i, knobLedModes[i], value, upperBound);
                continue;
            }
            ((MCUControlSurface)this.surface).setKnobLED(i, 2, 0, upperBound);
        }
    }

    protected void drawParameterHeader() {
        this.drawParameterHeader(((MCUControlSurface)this.surface).getTextDisplay(), 0);
    }

    protected void drawParameterHeader(ITextDisplay display, int row) {
        IParameterProvider parameterProvider = this.getParameterProvider();
        if (parameterProvider == null) {
            return;
        }
        display.clear();
        int textLength = Math.min(display.getNumberOfCellCharacters(), this.getTextLength());
        for (int i = 0; i < 8; ++i) {
            IParameter parameter = parameterProvider.get(i);
            if (!parameter.doesExist()) continue;
            display.setCell(row, i, StringUtils.shortenAndFixASCII(parameter.getName(), textLength));
        }
        display.done(row);
    }

    @Override
    public void updateDisplay() {
        MCUConfiguration.MainDisplay mainDisplayType = this.configuration.getMainDisplayType();
        if (mainDisplayType == MCUConfiguration.MainDisplay.NONE) {
            return;
        }
        boolean isAsparion = mainDisplayType == MCUConfiguration.MainDisplay.ASPARION;
        this.drawDisplay2();
        if (isAsparion || this.configuration.isDisplayTrackNames()) {
            this.drawTrackNameHeader();
        } else {
            this.drawParameterHeader();
        }
        ITextDisplay d = ((MCUControlSurface)this.surface).getTextDisplay();
        IParameterProvider parameterProvider = this.getParameterProvider();
        if (parameterProvider == null) {
            return;
        }
        ColorEx[] colors = new ColorEx[8];
        int textLength = this.getTextLength();
        for (int i = 0; i < 8; ++i) {
            IParameter parameter = parameterProvider.get(i);
            d.setCell(1, i, StringUtils.shortenAndFixASCII(parameter.getDisplayedValue(), textLength));
            Optional<ColorEx> optColor = parameterProvider.getColor(i);
            ColorEx color = optColor.isPresent() ? optColor.get() : this.defaultColor;
            boolean exists = parameter.doesExist();
            colors[i] = BaseMode.preventBlack(exists, exists ? color : ColorEx.BLACK);
        }
        d.done(1);
        ((MCUControlSurface)this.surface).sendDisplayColor(colors);
    }

    protected void drawDisplay2() {
        MCUConfiguration.SecondDisplay secondDisplay = this.configuration.getSecondDisplayType();
        switch (secondDisplay) {
            case ASPARION: {
                this.drawParameterHeader(((MCUControlSurface)this.surface).getTextDisplay(1), 0);
                break;
            }
            case QCON: 
            case V1M: {
                boolean isMainDevice = ((MCUControlSurface)this.surface).isMainDevice();
                boolean isShort = isMainDevice && secondDisplay == MCUConfiguration.SecondDisplay.QCON;
                ITrackBank tb = this.getTrackBank();
                ITextDisplay d2 = ((MCUControlSurface)this.surface).getTextDisplay(1);
                int extenderOffset = this.getExtenderOffset();
                boolean isLayerMode = Modes.isLayerMode((Modes)((Object)((MCUControlSurface)this.surface).getModeManager().getActiveID()));
                if (isLayerMode) {
                    ICursorDevice cursorDevice = this.model.getCursorDevice();
                    ILayerBank layerBank = cursorDevice.hasDrumPads() ? cursorDevice.getDrumPadBank() : cursorDevice.getLayerBank();
                    for (int i = 0; i < 8; ++i) {
                        IChannel c = (IChannel)layerBank.getItem(extenderOffset + i);
                        d2.setCell(0, i, StringUtils.shortenAndFixASCII(c.getName(), isShort ? 6 : 7));
                    }
                } else {
                    for (int i = 0; i < 8; ++i) {
                        ITrack t = (ITrack)tb.getItem(extenderOffset + i);
                        d2.setCell(0, i, StringUtils.shortenAndFixASCII(t.getName(), isShort ? 6 : 7));
                    }
                }
                if (isShort) {
                    d2.setCell(0, 8, "Maste");
                }
                d2.done(0);
                d2.clearRow(1);
                if (isMainDevice) {
                    Optional selectedItem;
                    IMasterTrack masterTrack = this.model.getMasterTrack();
                    ICursorDevice cursorDevice = this.model.getCursorDevice();
                    ITrack selectedTrack = masterTrack.isSelected() ? masterTrack : ((selectedItem = tb.getSelectedItem()).isPresent() ? (ITrack)selectedItem.get() : EmptyTrack.getInstance(((ITrack)tb.getItem(0)).getSendBank().getPageSize()));
                    d2.setBlock(1, 0, "  Sel. track:").setBlock(1, 1, selectedTrack == null ? "None" : StringUtils.shortenAndFixASCII(selectedTrack.getName(), 11));
                    d2.setBlock(1, 2, "  Sel. devce:").setBlock(1, 3, cursorDevice.doesExist() ? StringUtils.shortenAndFixASCII(cursorDevice.getName(), 11) : "None");
                }
                d2.done(1);
                break;
            }
        }
    }

    protected ITrackBank getTrackBank() {
        ITrackBank effectTrackBank;
        if (this.pinFXtoLastDevice && (effectTrackBank = this.model.getEffectTrackBank()) != null) {
            return effectTrackBank;
        }
        return this.model.getCurrentTrackBank();
    }

    protected int getExtenderOffset() {
        return this.pinFXtoLastDevice ? 0 : ((MCUControlSurface)this.surface).getExtenderOffset();
    }

    protected int getTextLength() {
        switch (this.configuration.getMainDisplayType()) {
            case ASPARION: {
                return 12;
            }
            case MACKIE_6_CHARACTERS: {
                return 6;
            }
            case MACKIE_7_CHARACTERS: {
                return 7;
            }
        }
        return 0;
    }

    protected static ColorEx preventBlack(boolean doesExist, ColorEx color) {
        return doesExist && ColorEx.BLACK.equals(color) ? ColorEx.GRAY : color;
    }

    protected void drawTrackNameHeader() {
        ITrackBank tb = this.getTrackBank();
        int extenderOffset = this.getExtenderOffset();
        ITextDisplay d = ((MCUControlSurface)this.surface).getTextDisplay().clear();
        int textLength = this.getTextLength();
        for (int i = 0; i < 8; ++i) {
            ITrack t = (ITrack)tb.getItem(extenderOffset + i);
            d.setCell(0, i, StringUtils.shortenAndFixASCII(t.getName(), textLength));
        }
        d.done(0);
    }
}

