/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.intuitiveinstruments.exquis.view;

import de.mossgrabers.controller.intuitiveinstruments.exquis.ExquisConfiguration;
import de.mossgrabers.controller.intuitiveinstruments.exquis.command.trigger.ExquisSessionCommand;
import de.mossgrabers.controller.intuitiveinstruments.exquis.controller.ExquisControlSurface;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.Pair;
import de.mossgrabers.framework.view.AbstractSessionView;

public class ExquisSessionView
extends AbstractSessionView<ExquisControlSurface, ExquisConfiguration> {
    private static final int[][] GRID_MAPPING = new int[][]{{56, 57, 58, 59}, {50, 51, 52, 53}, {45, 46, 47, 48}, {39, 40, 41, 42}, {34, 35, 36, 37}, {28, 29, 30, 31}, {23, 24, 25, 26}};
    private static final int[] GRID_SCENES = new int[]{27, 32, 38, 43, 49, 54, 60};
    private static final int[] GRID_STOP = new int[]{17, 18, 19, 20, 21};
    private static final int[] GRID_MUTE = new int[]{12, 13, 14, 15, 16};
    private static final int[] GRID_SOLO = new int[]{6, 7, 8, 9, 10};
    private static final int[] GRID_SELECT = new int[]{1, 2, 3, 4, 5};
    private static final int FUNCTION_DELETE = 55;
    private static final int FUNCTION_DUPLICATE = 44;
    private static final int FUNCTION_NEW_CLIP = 33;
    private static final int FUNCTION_ADD_SCENE = 22;
    private static final int FUNCTION_ALTERNATIVE = 11;
    private static final int FUNCTION_SELECT = 0;
    private boolean isRecArmActive = false;
    private final NewCommand<ExquisControlSurface, ExquisConfiguration> newCommand;

    public ExquisSessionView(ExquisControlSurface surface, IModel model) {
        super("Session", surface, model, 7, 4, true);
        this.newCommand = new NewCommand(model, surface);
        int redLo = 104;
        int redHi = 105;
        int black = 101;
        int white = 103;
        int green = 111;
        int orange = 114;
        int grey = 102;
        LightInfo isRecording = new LightInfo(105, 105, false);
        LightInfo isRecordingQueued = new LightInfo(105, 101, true);
        LightInfo isPlaying = new LightInfo(111, 111, false);
        LightInfo isPlayingQueued = new LightInfo(111, 111, true);
        LightInfo isStopQueued = new LightInfo(111, 111, true);
        LightInfo hasContent = new LightInfo(114, 103, false);
        LightInfo noContent = new LightInfo(101, -1, false);
        LightInfo recArmed = new LightInfo(104, -1, false);
        LightInfo isMuted = new LightInfo(102, -1, false);
        this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, isStopQueued, hasContent, noContent, recArmed, isMuted);
        this.birdColorHasContent = new LightInfo(114, -1, false);
        this.birdColorSelected = isPlaying;
    }

    @Override
    public void onActivate() {
        ((ExquisControlSurface)this.surface).configureDeveloperMode(63);
        super.onActivate();
        ((ExquisControlSurface)this.surface).forceFlush();
    }

    @Override
    public void onGridNote(int note, int velocity) {
        int noteIndex;
        if (velocity == 0) {
            ((ExquisSessionCommand)((ExquisControlSurface)this.surface).getButton(ButtonID.SESSION).getCommand()).setTemporary();
        }
        if ((noteIndex = note - 36) == 33) {
            this.newCommand.execute(velocity == 0 ? ButtonEvent.UP : ButtonEvent.DOWN, velocity);
            return;
        }
        if (noteIndex == 22) {
            if (velocity != 0) {
                this.model.getProject().createSceneFromPlayingLauncherClips();
            }
            return;
        }
        int sceneIndex = ExquisSessionView.isFeatureButton(noteIndex, GRID_SCENES);
        if (sceneIndex >= 0) {
            this.onSceneButton(ButtonID.get(ButtonID.SCENE1, this.rows - 1 - sceneIndex), velocity == 0 ? ButtonEvent.UP : ButtonEvent.DOWN);
            return;
        }
        int stopIndex = ExquisSessionView.isFeatureButton(noteIndex, GRID_STOP);
        if (stopIndex >= 0) {
            if (velocity == 0) {
                return;
            }
            ITrackBank trackBank = this.model.getTrackBank();
            boolean alternative = this.isAlternateFunction();
            if (stopIndex < 4) {
                ((ITrack)trackBank.getItem(stopIndex)).stop(alternative);
            } else {
                trackBank.stop(alternative);
            }
            return;
        }
        int muteIndex = ExquisSessionView.isFeatureButton(noteIndex, GRID_MUTE);
        if (muteIndex >= 0) {
            if (velocity == 0) {
                return;
            }
            ITrackBank trackBank = this.model.getTrackBank();
            if (muteIndex < 4) {
                ((ITrack)trackBank.getItem(muteIndex)).toggleMute();
            } else {
                this.model.getProject().clearMute();
            }
            return;
        }
        int soloIndex = ExquisSessionView.isFeatureButton(noteIndex, GRID_SOLO);
        if (soloIndex >= 0) {
            if (velocity == 0) {
                return;
            }
            ITrackBank trackBank = this.model.getTrackBank();
            if (soloIndex < 4) {
                ((ITrack)trackBank.getItem(soloIndex)).toggleSolo();
            } else {
                this.model.getProject().clearSolo();
            }
            return;
        }
        int selectIndex = ExquisSessionView.isFeatureButton(noteIndex, GRID_SELECT);
        if (selectIndex >= 0) {
            if (velocity == 0) {
                return;
            }
            ITrackBank trackBank = this.model.getTrackBank();
            if (selectIndex < 4) {
                if (this.isRecArmActive) {
                    ((ITrack)trackBank.getItem(selectIndex)).toggleRecArm();
                } else {
                    ((ITrack)trackBank.getItem(selectIndex)).select();
                }
            } else {
                this.isRecArmActive = !this.isRecArmActive;
            }
            return;
        }
        super.onGridNote(note, velocity);
    }

    @Override
    protected boolean handleButtonCombinations(ITrack track, ISlot slot) {
        if (super.handleButtonCombinations(track, slot)) {
            return true;
        }
        if (((ExquisControlSurface)this.surface).isPressed(ButtonID.get(ButtonID.PAD1, 0))) {
            if (slot.doesExist()) {
                slot.select();
            }
            return true;
        }
        return super.handleButtonCombinations(track, slot);
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int scene = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        if (scene < 0 || scene >= 8) {
            return "BUTTON_COLOR_OFF";
        }
        ISceneBank sceneBank = this.model.getSceneBank();
        IScene s = (IScene)sceneBank.getItem(scene);
        if (s.doesExist()) {
            return s.isSelected() ? "COLOR_SELECTED_SCENE" : "COLOR_SCENE";
        }
        return "COLOR_SELECTED_OFF";
    }

    @Override
    protected Pair<Integer, Integer> getPad(int note) {
        int offsetNote = note - ((ExquisControlSurface)this.surface).getPadGrid().getStartNote();
        for (int row = 0; row < GRID_MAPPING.length; ++row) {
            for (int column = 0; column < GRID_MAPPING[row].length; ++column) {
                if (GRID_MAPPING[row][column] != offsetNote) continue;
                return new Pair<Integer, Integer>(column, row);
            }
        }
        return null;
    }

    @Override
    protected void drawSessionGrid() {
        super.drawSessionGrid();
        IPadGrid padGrid = ((ExquisControlSurface)this.surface).getPadGrid();
        for (int i = 0; i < GRID_SCENES.length; ++i) {
            String buttonColorID = this.getButtonColorID(ButtonID.get(ButtonID.SCENE1, this.rows - i - 1));
            padGrid.light(36 + GRID_SCENES[i], buttonColorID);
        }
        ITrackBank trackBank = this.model.getTrackBank();
        for (int i = 0; i < 4; ++i) {
            ITrack track = (ITrack)trackBank.getItem(i);
            padGrid.light(36 + GRID_STOP[i], 102);
            padGrid.light(36 + GRID_MUTE[i], track.isMute() ? 112 : 101);
            padGrid.light(36 + GRID_SOLO[i], track.isSolo() ? 106 : 101);
            if (this.isRecArmActive) {
                padGrid.light(36 + GRID_SELECT[i], track.doesExist() && track.isRecArm() ? 105 : 101);
                continue;
            }
            padGrid.light(36 + GRID_SELECT[i], track.doesExist() ? DAWColor.getColorID(track.getColor()) : "BUTTON_STATE_OFF");
        }
        padGrid.light(36 + GRID_STOP[4], 103);
        padGrid.light(36 + GRID_MUTE[4], 113);
        padGrid.light(36 + GRID_SOLO[4], 107);
        padGrid.light(36 + GRID_SELECT[4], this.isRecArmActive ? 105 : 104);
        padGrid.light(91, 104);
        padGrid.light(80, 110);
        padGrid.light(69, 108);
        padGrid.light(58, 110);
        padGrid.light(47, 102);
        padGrid.light(36, 102);
    }

    @Override
    protected void drawPad(ISlot slot, int x, int y, boolean isArmed) {
        int note = GRID_MAPPING[y][x];
        LightInfo color = this.getPadColor(slot, isArmed);
        ((ExquisControlSurface)this.surface).getPadGrid().light(36 + note, color.getColor(), color.getBlinkColor(), color.isFast());
    }

    private static int isFeatureButton(int note, int[] buttonIndices) {
        for (int i = 0; i < buttonIndices.length; ++i) {
            if (buttonIndices[i] != note) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected boolean isDeletePressed() {
        return ((ExquisControlSurface)this.surface).isPressed(ButtonID.get(ButtonID.PAD1, 55));
    }

    @Override
    protected boolean isDuplicatePressed() {
        return ((ExquisControlSurface)this.surface).isPressed(ButtonID.get(ButtonID.PAD1, 44));
    }

    @Override
    protected boolean isAlternateFunction() {
        return ((ExquisControlSurface)this.surface).isPressed(ButtonID.get(ButtonID.PAD1, 11));
    }
}

