/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.arturia.beatstep.view;

import de.mossgrabers.controller.arturia.beatstep.BeatstepConfiguration;
import de.mossgrabers.controller.arturia.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.arturia.beatstep.view.BeatstepView;
import de.mossgrabers.controller.arturia.beatstep.view.TrackEditing;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.AbstractView;
import java.util.Optional;

public class TrackView
extends AbstractView<BeatstepControlSurface, BeatstepConfiguration>
implements BeatstepView {
    private final TrackEditing extensions;

    public TrackView(BeatstepControlSurface surface, IModel model) {
        super("Track", surface, model);
        this.extensions = new TrackEditing(surface, model);
    }

    @Override
    public void onKnob(int index, int value) {
        if (index < 12) {
            this.extensions.onTrackKnob(index, value);
            return;
        }
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional selectedTrack = tb.getSelectedItem();
        if (selectedTrack.isEmpty()) {
            return;
        }
        switch (index) {
            case 12: 
            case 13: {
                ((ISend)((ITrack)selectedTrack.get()).getSendBank().getItem(index - 8)).changeValue(value);
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                this.model.getTransport().changeCrossfade(value);
                break;
            }
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional selectedTrack = tb.getSelectedItem();
        int index = note - 36;
        switch (index) {
            case 0: {
                if (!selectedTrack.isPresent()) break;
                ((ITrack)selectedTrack.get()).toggleIsActivated();
                break;
            }
            case 1: {
                if (!selectedTrack.isPresent()) break;
                ((ITrack)selectedTrack.get()).toggleRecArm();
                break;
            }
            case 2: {
                if (!selectedTrack.isPresent()) break;
                ((ITrack)selectedTrack.get()).toggleGroupExpanded();
                break;
            }
            case 3: {
                this.model.getApplication().addInstrumentTrack();
                break;
            }
            case 4: {
                this.model.getApplication().addAudioTrack();
                break;
            }
            case 5: {
                this.model.getApplication().addEffectTrack();
                break;
            }
            case 6: {
                tb.selectPreviousPage();
                break;
            }
            case 7: {
                tb.selectNextPage();
                break;
            }
            default: {
                this.selectTrack(index - 8);
            }
        }
    }

    @Override
    public void drawGrid() {
        ITrackBank tb = this.model.getCurrentTrackBank();
        IPadGrid padGrid = ((BeatstepControlSurface)this.surface).getPadGrid();
        for (int i = 0; i < 8; ++i) {
            padGrid.light(44 + i, ((ITrack)tb.getItem(i)).isSelected() ? 16 : 0);
        }
        Optional sel = tb.getSelectedItem();
        boolean isPresent = sel.isPresent();
        padGrid.light(36, isPresent && ((ITrack)sel.get()).isActivated() ? 16 : 0);
        padGrid.light(37, isPresent && ((ITrack)sel.get()).isRecArm() ? 1 : 0);
        int groupColor = 0;
        if (isPresent && ((ITrack)sel.get()).isGroup()) {
            groupColor = ((ITrack)sel.get()).isGroupExpanded() ? 17 : 16;
        }
        padGrid.light(38, groupColor);
        padGrid.light(39, 17);
        padGrid.light(40, 17);
        padGrid.light(41, 17);
        padGrid.light(42, 16);
        padGrid.light(43, 16);
    }
}

