/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.acvs;

import de.mossgrabers.controller.akai.acvs.ACVSDevice;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import java.util.List;

public class ACVSConfiguration
extends AbstractConfiguration {
    public static final Integer LAUNCH_CLIPS_OR_SCENES = 100;
    private static final String[] SCENE_CLIPS_OPTIONS = new String[]{"Clips", "Scenes"};
    private static final String[] ACVS_DEVICE;
    private IEnumSetting launchClipsOrScenesSetting;
    private boolean launchClips;
    private IEnumSetting acvsDeviceSetting;
    private ACVSDevice acvsDevice = ACVSDevice.MPC_LIVE_ONE;

    public ACVSConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes) {
        super(host, valueChanger, arpeggiatorModes);
        this.selectClipOnLaunch = true;
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        ACVSDevice[] values;
        this.acvsDeviceSetting = globalSettings.getEnumSetting("Device", "Hardware Setup", ACVS_DEVICE, ACVSDevice.MPC_LIVE_ONE.getName());
        String acvsDeviceName = (String)this.acvsDeviceSetting.get();
        for (ACVSDevice value2 : values = ACVSDevice.values()) {
            if (!value2.getName().equals(acvsDeviceName)) continue;
            this.acvsDevice = value2;
            break;
        }
        this.acvsDeviceSetting.setEnabled(false);
        this.launchClipsOrScenesSetting = globalSettings.getEnumSetting("Launch", "Session", SCENE_CLIPS_OPTIONS, SCENE_CLIPS_OPTIONS[0]);
        this.launchClipsOrScenesSetting.addValueObserver(value -> {
            this.launchClips = SCENE_CLIPS_OPTIONS[0].equals(value);
            this.notifyObservers(LAUNCH_CLIPS_OR_SCENES);
        });
        this.activateBehaviourOnStopSetting(globalSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateQuantizeAmountSetting(globalSettings);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
    }

    public void setLaunchClipsOrScenes(boolean launchClips) {
        this.launchClipsOrScenesSetting.set(SCENE_CLIPS_OPTIONS[launchClips ? 0 : 1]);
    }

    public boolean isLaunchClips() {
        return this.launchClips;
    }

    public void setACVSActiveDevice(ACVSDevice acvsDevice) {
        this.acvsDeviceSetting.set(acvsDevice.getName());
    }

    public ACVSDevice getACVSActiveDevice() {
        return this.acvsDevice;
    }

    public boolean isActiveACVSDevice(ACVSDevice acvsDevice) {
        return this.acvsDevice == acvsDevice;
    }

    static {
        ACVSDevice[] values = ACVSDevice.values();
        ACVS_DEVICE = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            ACVSConfiguration.ACVS_DEVICE[i] = values[i].getName();
        }
    }
}

