/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.trigger;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class MastertrackCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    private boolean quitMasterMode = false;
    private int selectedTrackBeforeMasterMode = -1;

    public MastertrackCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        if (modeManager.isActive(new Modes[]{Modes.BROWSER})) {
            return;
        }
        switch (event) {
            case DOWN: {
                this.quitMasterMode = false;
                break;
            }
            case UP: {
                this.handleButtonUp(modeManager);
                break;
            }
            case LONG: {
                this.quitMasterMode = true;
                modeManager.setTemporary(Modes.FRAME);
            }
        }
    }

    private void handleButtonUp(ModeManager modeManager) {
        if (this.quitMasterMode) {
            modeManager.restore();
            return;
        }
        if (Modes.MASTER.equals(modeManager.getActiveID())) {
            if (this.selectedTrackBeforeMasterMode >= 0) {
                ((ITrack)this.model.getCurrentTrackBank().getItem(this.selectedTrackBeforeMasterMode)).select();
            }
            return;
        }
        modeManager.setActive(Modes.MASTER);
        this.model.getMasterTrack().select();
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        this.selectedTrackBeforeMasterMode = cursorTrack.doesExist() ? cursorTrack.getIndex() : -1;
    }
}

