/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.trigger;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.utils.ButtonEvent;

public class ClipStopCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    public ClipStopCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        ((IView)((PushControlSurface)this.surface).getViewManager().getActive()).updateNoteMapping();
        if (((PushControlSurface)this.surface).isSelectPressed()) {
            if (event == ButtonEvent.UP) {
                ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
                this.model.getCurrentTrackBank().stop(((PushControlSurface)this.surface).isShiftPressed());
            }
            return;
        }
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        if (!config.isPushModern()) {
            if (event == ButtonEvent.DOWN) {
                config.setLockState(PushConfiguration.LockState.CLIP_STOP);
            }
            return;
        }
        if (event != ButtonEvent.UP) {
            return;
        }
        if (((PushControlSurface)this.surface).isShiftPressed() || ((PushControlSurface)this.surface).isPressed(ButtonID.LOCK_MODE)) {
            config.setLockState(config.getLockState() == PushConfiguration.LockState.CLIP_STOP ? PushConfiguration.LockState.OFF : PushConfiguration.LockState.CLIP_STOP);
            return;
        }
        if (config.getLockState() == PushConfiguration.LockState.CLIP_STOP) {
            return;
        }
        this.model.getCursorTrack().stop(((PushControlSurface)this.surface).isShiftPressed());
    }
}

