/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view.sequencer;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.DefaultStepInfo;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.TransposeView;
import de.mossgrabers.framework.view.sequencer.AbstractSequencerView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractPolySequencerView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractSequencerView<S, C>
implements TransposeView {
    protected static final int GRID_COLUMNS = 8;
    protected static final int GRID_ROWS = 8;
    protected static final int NUM_SEQUENCER_LINES = 4;
    protected final int sequencerSteps;
    protected final Map<Integer, Integer> noteMemory = new HashMap<Integer, Integer>();
    protected int copyStep = -1;
    protected int numColumns;
    protected int numRows;
    protected long lastPressedNoteTime = 0L;

    protected AbstractPolySequencerView(S surface, IModel model, boolean useDawColors) {
        this(surface, model, useDawColors, 8, 8, 4);
    }

    protected AbstractPolySequencerView(S surface, IModel model, boolean useDawColors, int numColumns, int numRows, int numSequencerRows) {
        super("Poly Seq.", surface, model, 128, numSequencerRows * numColumns, useDawColors);
        this.sequencerSteps = numSequencerRows * numColumns;
        this.numColumns = numColumns;
        this.numRows = numRows;
        this.numSequencerRows = numSequencerRows;
        ITrackBank tb = model.getTrackBank();
        tb.addSelectionObserver((index, isSelected) -> this.keyManager.clearPressedKeys());
        tb.addNoteObserver(this.keyManager::call);
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        this.changeOctave(false, event);
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        this.changeOctave(true, event);
    }

    private void changeOctave(boolean increase, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.surface.isShiftPressed()) {
            this.getClip().transpose(increase ? 1 : -1);
            return;
        }
        if (this.surface.isSelectPressed()) {
            this.getClip().transpose(increase ? 12 : -12);
            return;
        }
        this.setOctave(this.scales.getOctave() + (increase ? 1 : -1));
    }

    @Override
    public void resetOctave() {
        this.setOctave(this.scales.getDefaultOctave());
    }

    private void setOctave(int octave) {
        this.keyManager.clearPressedKeys();
        this.scales.setOctave(octave);
        this.updateNoteMapping();
        this.clearEditNotes();
        this.surface.getDisplay().notify(this.scales.getRangeText());
    }

    @Override
    public boolean isOctaveUpButtonOn() {
        return true;
    }

    @Override
    public boolean isOctaveDownButtonOn() {
        return true;
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.isActive()) {
            return;
        }
        int index = note - this.surface.getPadGrid().getStartNote();
        this.surface.getButton(ButtonID.get(ButtonID.PAD1, index)).setConsumed();
        int x = index % this.numColumns;
        int y = index / this.numColumns;
        if (y < this.numRows - this.numSequencerRows) {
            return;
        }
        this.clearEditNotes();
        this.editNotesOfStep(this.configuration.getMidiEditChannel(), this.numColumns * (this.numRows - 1 - y) + x);
    }

    protected void editNotesOfStep(int channel, int step) {
        NotePosition notePosition = new NotePosition(channel, step, 0);
        INoteClip clip = this.getClip();
        for (int row = 0; row < 128; ++row) {
            notePosition.setNote(row);
            if (clip.getStep(notePosition).getState() != StepState.START) continue;
            this.editNote(clip, notePosition, true);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        boolean isKeyboardEnabled = this.model.canSelectedTrackHoldNotes();
        if (!isKeyboardEnabled) {
            return;
        }
        int index = note - this.surface.getPadGrid().getStartNote();
        int x = index % this.numColumns;
        int y = index / this.numColumns;
        if (y < this.numRows - this.numSequencerRows) {
            this.handleNoteArea(note, velocity);
            return;
        }
        if (this.isActive()) {
            this.handleSequencerArea(x, y, velocity);
        }
    }

    protected void handleNoteArea(int note, int velocity) {
        int mappedNote;
        long now = System.currentTimeMillis();
        if (now - this.lastPressedNoteTime > 500L) {
            this.lastPressedNoteTime = now;
            this.noteMemory.clear();
        }
        if ((mappedNote = this.keyManager.map(note)) == -1) {
            return;
        }
        this.keyManager.setAllKeysPressed(mappedNote, velocity);
        if (velocity > 0) {
            this.noteMemory.put(mappedNote, velocity);
        }
    }

    protected void handleSequencerArea(int x, int y, int velocity) {
        if (velocity != 0) {
            return;
        }
        INoteClip clip = this.getClip();
        int step = this.numColumns * (this.numRows - 1 - y) + x;
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), step, 0);
        int channel = notePosition.getChannel();
        if (this.handleSequencerAreaButtonCombinations(clip, channel, step) || this.handleNoteEditor(clip, notePosition, 127)) {
            return;
        }
        if (clip.hasColumnData(channel, step)) {
            clip.clearColumn(channel, step);
            return;
        }
        boolean isAccentActive = this.configuration.isAccentActive();
        boolean notesPresent = false;
        for (int row = 0; row < 128; ++row) {
            notePosition.setNote(row);
            Integer k = row;
            if (!this.noteMemory.containsKey(k)) continue;
            int v = isAccentActive ? this.configuration.getFixedAccentValue() : this.noteMemory.get(k).intValue();
            clip.toggleStep(notePosition, v);
            notesPresent = true;
        }
        if (!notesPresent) {
            this.surface.getDisplay().notify("Play some notes in the lower part first.");
        }
    }

    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, int channel, int step) {
        NotePosition notePosition = new NotePosition(channel, step, 0);
        if (this.isButtonCombination(ButtonID.DUPLICATE)) {
            if (this.getStep(clip, step).getState() == StepState.START) {
                this.copyStep = step;
            } else if (this.copyStep >= 0) {
                NotePosition copyPosition = new NotePosition(channel, this.copyStep, 0);
                for (int row = 0; row < 128; ++row) {
                    copyPosition.setNote(row);
                    IStepInfo stepInfo = clip.getStep(copyPosition);
                    if (stepInfo == null || !(stepInfo.getVelocity() > 0.0)) continue;
                    notePosition.setNote(row);
                    clip.setStep(notePosition, stepInfo);
                }
            }
            return true;
        }
        if (this.isButtonCombination(ButtonID.MUTE)) {
            for (int note = 0; note < 128; ++note) {
                notePosition.setNote(note);
                IStepInfo stepInfo = clip.getStep(notePosition);
                StepState isSet = stepInfo.getState();
                if (isSet != StepState.START) continue;
                clip.updateStepMuteState(notePosition, !stepInfo.isMuted());
            }
            return true;
        }
        return this.changeLengthOfNotes(clip, notePosition);
    }

    @Override
    protected StepState getStepState(INoteClip clip, NotePosition notePosition) {
        NotePosition rowNotePosition = new NotePosition(notePosition);
        for (int row = 0; row < 128; ++row) {
            rowNotePosition.setNote(row);
            StepState state = clip.getStep(rowNotePosition).getState();
            if (state == StepState.OFF) continue;
            return state;
        }
        return StepState.OFF;
    }

    @Override
    protected void updateEditMode(INoteClip clip, NotePosition notePosition) {
        StepState state = this.getStepState(clip, notePosition);
        if (state == StepState.OFF) {
            this.exitEditMode();
        } else {
            this.editNotesOfStep(notePosition.getChannel(), notePosition.getStep());
        }
    }

    protected boolean changeLengthOfNotes(INoteClip clip, NotePosition notePosition) {
        int step = notePosition.getStep();
        for (int s = step - 1; s >= 0; --s) {
            notePosition.setStep(s);
            int x = s % this.numColumns;
            int y = this.numRows - 1 - s / this.numColumns;
            int pad = y * this.numColumns + x;
            IHwButton button = this.surface.getButton(ButtonID.get(ButtonID.PAD1, pad));
            if (!button.isLongPressed()) continue;
            button.setConsumed();
            int length = step - s + 1;
            double duration = (double)length * Resolution.getValueAt(this.getResolutionIndex());
            if (this.getStep(clip, s).getState() != StepState.START) {
                boolean isAccentActive = this.configuration.isAccentActive();
                for (int row = 0; row < 128; ++row) {
                    notePosition.setNote(row);
                    Integer k = row;
                    if (!this.noteMemory.containsKey(k)) continue;
                    int velocity = isAccentActive ? this.configuration.getFixedAccentValue() : this.noteMemory.get(k).intValue();
                    clip.setStep(notePosition, velocity, duration);
                }
                return true;
            }
            for (int row = 0; row < 128; ++row) {
                notePosition.setNote(row);
                IStepInfo stepInfo = clip.getStep(notePosition);
                if (stepInfo == null || stepInfo.getState() != StepState.START) continue;
                clip.updateStepDuration(notePosition, duration);
            }
            return true;
        }
        return false;
    }

    @Override
    public void drawGrid() {
        int startNote;
        IPadGrid padGrid = this.surface.getPadGrid();
        boolean isKeyboardEnabled = this.model.canSelectedTrackHoldNotes();
        if (!isKeyboardEnabled) {
            padGrid.turnOff();
            return;
        }
        INoteClip clip = this.getClip();
        boolean isActive = this.isActive();
        int step = clip.getCurrentStep();
        int hiStep = this.isInXRange(step) ? step % this.sequencerSteps : -1;
        List<NotePosition> editNotes = this.getEditNotes();
        for (int col = 0; col < this.sequencerSteps; ++col) {
            IStepInfo stepInfo = this.getStep(clip, col);
            boolean hilite = col == hiStep;
            int x = col % this.numColumns;
            int y = col / this.numColumns;
            padGrid.lightEx(x, y, isActive ? this.getStepColor(stepInfo, hilite, col, editNotes) : "COLOR_NO_CONTENT");
        }
        boolean isRecording = this.model.hasRecordingState();
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        for (int i = startNote = this.scales.getStartNote(); i < startNote + this.sequencerSteps; ++i) {
            padGrid.light(i, this.getGridColor(isKeyboardEnabled, isRecording, cursorTrack, i));
        }
    }

    @Override
    public void updateNoteMapping() {
        int[] matrix = this.scales.getNoteMatrix();
        for (int i = this.scales.getStartNote() + this.sequencerSteps; i < this.scales.getEndNote(); ++i) {
            matrix[i] = -1;
        }
        this.delayedUpdateNoteMapping(matrix);
    }

    protected IStepInfo getStep(INoteClip clip, int col) {
        DefaultStepInfo result = new DefaultStepInfo();
        boolean isMuted = true;
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), col, 0);
        for (int row = 0; row < 128; ++row) {
            notePosition.setNote(row);
            IStepInfo stepInfo = clip.getStep(notePosition);
            StepState r = stepInfo.getState();
            if (r == StepState.START) {
                result.setState(StepState.START);
            } else if (r == StepState.CONTINUE && result.getState() != StepState.START) {
                result.setState(StepState.CONTINUE);
            }
            if (r != StepState.START && r != StepState.CONTINUE || stepInfo.isMuted()) continue;
            isMuted = false;
        }
        result.setMuted(isMuted);
        return result;
    }

    protected List<NotePosition> getStepNotePositions(INoteClip clip) {
        ArrayList<NotePosition> positions = new ArrayList<NotePosition>();
        NotePosition notePosition = new NotePosition();
        for (int row = 0; row < 128; ++row) {
            notePosition.setNote(row);
            if (clip.getStep(notePosition).getState() != StepState.START) continue;
            positions.add(new NotePosition(notePosition));
        }
        return positions;
    }

    protected String getStepColor(IStepInfo stepInfo, boolean hilite, int step, List<NotePosition> editNotes) {
        int channel = this.configuration.getMidiEditChannel();
        switch (stepInfo.getState()) {
            case START: {
                if (hilite) {
                    return "COLOR_STEP_HILITE_CONTENT";
                }
                if (AbstractPolySequencerView.isChordEdit(channel, step, editNotes)) {
                    return "COLOR_STEP_SELECTED";
                }
                if (stepInfo.isMuted()) {
                    return "COLOR_STEP_MUTED";
                }
                return "COLOR_CONTENT";
            }
            case CONTINUE: {
                if (hilite) {
                    return "COLOR_STEP_HILITE_CONTENT";
                }
                if (AbstractPolySequencerView.isChordEdit(channel, step, editNotes)) {
                    return "COLOR_STEP_SELECTED";
                }
                if (stepInfo.isMuted()) {
                    return "COLOR_STEP_MUTED_CONT";
                }
                return "COLOR_CONTENT_CONT";
            }
        }
        return hilite ? "COLOR_STEP_HILITE_NO_CONTENT" : "COLOR_NO_CONTENT";
    }

    protected String getGridColor(boolean isKeyboardEnabled, boolean isRecording, ITrack track, int note) {
        if (isKeyboardEnabled) {
            if (this.keyManager.isKeyPressed(note)) {
                return isRecording ? "PLAY_VIEW_COLOR_RECORD" : "PLAY_VIEW_COLOR_PLAY";
            }
            String padColor = this.getPadColor(note, this.useDawColors ? track : null);
            if (this.configuration.isTurnOffScalePads() && "SCALE_COLOR_NOTE".equals(padColor)) {
                return "SCALE_COLOR_OFF";
            }
            return padColor;
        }
        return "PLAY_VIEW_COLOR_OFF";
    }

    protected static boolean isChordEdit(int channel, int step, List<NotePosition> editNotes) {
        for (NotePosition editNote : editNotes) {
            if (editNote.getChannel() != channel || editNote.getStep() != step) continue;
            return true;
        }
        return false;
    }
}

