/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view.sequencer;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.data.empty.EmptyStepInfo;
import de.mossgrabers.framework.view.sequencer.AbstractSequencerView;
import java.util.List;
import java.util.Optional;

public abstract class AbstractMonophonicSequencerView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractSequencerView<S, C> {
    protected final int sequencerSteps;
    protected final int numSequencerColumns;

    protected AbstractMonophonicSequencerView(String name, S surface, IModel model, int numSequencerRows, int numSequencerColumns, boolean useDawColors) {
        super(name, surface, model, 128, numSequencerRows * numSequencerColumns, useDawColors);
        this.sequencerSteps = this.clipCols;
        this.numSequencerRows = numSequencerRows;
        this.numSequencerColumns = numSequencerColumns;
    }

    @Override
    public void drawGrid() {
        boolean isActive = this.isActive();
        INoteClip clip = this.getClip();
        Optional<ColorEx> rowColor = clip.doesExist() ? Optional.of(clip.getColor()) : Optional.empty();
        int step = clip.getCurrentStep();
        int hiStep = this.isInXRange(step) ? step % this.sequencerSteps : -1;
        int channel = this.configuration.getMidiEditChannel();
        IPadGrid padGrid = this.surface.getPadGrid();
        List<NotePosition> editNotes = this.getEditNotes();
        NotePosition notePosition = new NotePosition(channel, 0, 0);
        for (int col = 0; col < this.sequencerSteps; ++col) {
            notePosition.setStep(col);
            int x = col % this.numSequencerColumns;
            int y = col / this.numSequencerColumns;
            if (!isActive) {
                padGrid.lightEx(x, y, "COLOR_NO_CONTENT");
                continue;
            }
            int noteRow = clip.getHighestRow(channel, col);
            notePosition.setNote(noteRow);
            IStepInfo stepInfo = noteRow == -1 ? EmptyStepInfo.INSTANCE : clip.getStep(notePosition);
            boolean hilite = col == hiStep;
            padGrid.lightEx(x, y, this.getStepColor(stepInfo, hilite, rowColor, channel, col, noteRow, editNotes));
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.isActive() || velocity == 0) {
            return;
        }
        int index = note - 36;
        int x = index % this.numSequencerColumns;
        int y = this.numSequencerRows - 1 - index / this.numSequencerColumns;
        int step = y * this.numSequencerColumns + x;
        int channel = this.configuration.getMidiEditChannel();
        INoteClip clip = this.getClip();
        int noteRow = clip.getHighestRow(channel, step);
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), step, noteRow);
        if (noteRow == -1) {
            notePosition.setNote(60 + this.scales.getScaleOffset());
            clip.toggleStep(notePosition, 127);
        } else {
            clip.clearStep(notePosition);
        }
    }
}

