/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.scale;

import de.mossgrabers.framework.scale.Scale;
import de.mossgrabers.framework.scale.ScaleLayout;

class ScaleGrid {
    private final Scale scale;
    private final int[] matrix;
    private final int[] chromatic;

    public ScaleGrid(Scale scale, ScaleLayout layout, Orientation orientation, int rows, int cols, int shift, int semitoneShift) {
        int size = cols * rows;
        this.matrix = new int[size];
        this.chromatic = new int[size];
        this.scale = scale;
        int[] intervals = this.scale.getIntervals();
        int len = intervals.length;
        boolean isUp = orientation == Orientation.ORIENT_UP;
        int centerOffset = layout == ScaleLayout.EIGHT_UP_CENTER || layout == ScaleLayout.EIGHT_RIGHT_CENTER ? -3 : 0;
        int dx = 1;
        int dy = shift;
        if (shift == 7) {
            dy = len;
        }
        if (layout == ScaleLayout.STAGGERED_UP || layout == ScaleLayout.STAGGERED_RIGHT) {
            dx = 2;
            for (dy = len - 2; dy > 1 && (dy & 1) == 0; dy /= 2) {
            }
        }
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < cols; ++column) {
                int y = isUp ? row : column;
                int x = isUp ? column : row;
                int index = row * cols + column;
                int offset = y * dy + x * dx + centerOffset;
                int oct = offset / len;
                if (offset < 0) {
                    offset = len + offset;
                    oct = offset / len - 1;
                }
                this.matrix[index] = oct * 12 + intervals[offset % len];
                this.chromatic[index] = y * semitoneShift + x;
            }
        }
    }

    public String getName() {
        return this.scale.getName();
    }

    public int[] getMatrix() {
        return this.matrix;
    }

    public int[] getChromatic() {
        return this.chromatic;
    }

    public static enum Orientation {
        ORIENT_UP,
        ORIENT_RIGHT;

    }
}

