/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.mode.device;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;

public class ParameterMode<S extends IControlSurface<C>, C extends Configuration>
extends AbstractParameterMode<S, C, IParameter> {
    protected final ICursorDevice cursorDevice;

    public ParameterMode(S surface, IModel model, boolean isAbsolute) {
        this(surface, model, isAbsolute, null, () -> surface.isShiftPressed());
    }

    public ParameterMode(S surface, IModel model, boolean isAbsolute, BooleanSupplier isAlternativeFunction) {
        this(surface, model, isAbsolute, null, isAlternativeFunction);
    }

    public ParameterMode(S surface, IModel model, boolean isAbsolute, List<ContinuousID> controls) {
        this(surface, model, isAbsolute, controls, () -> surface.isShiftPressed());
    }

    public ParameterMode(S surface, IModel model, boolean isAbsolute, List<ContinuousID> controls, BooleanSupplier isAlternativeFunction) {
        this("Parameters", surface, model, isAbsolute, controls, isAlternativeFunction);
    }

    public ParameterMode(String name, S surface, IModel model, boolean isAbsolute, List<ContinuousID> controls, BooleanSupplier isAlternativeFunction) {
        super(name, surface, model, isAbsolute, model.getCursorDevice().getParameterBank(), controls, isAlternativeFunction);
        this.cursorDevice = this.model.getCursorDevice();
        if (controls != null) {
            this.setParameterProvider(new BankParameterProvider(this.cursorDevice.getParameterBank()));
        }
    }

    @Override
    public void onKnobValue(int index, int value) {
        if (!this.cursorDevice.doesExist()) {
            return;
        }
        IParameter item = (IParameter)this.cursorDevice.getParameterBank().getItem(index);
        if (item == null || !item.doesExist()) {
            return;
        }
        if (this.isAbsolute) {
            item.setValue(value);
        } else {
            item.changeValue(value);
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        if (!this.cursorDevice.doesExist()) {
            return;
        }
        IParameter item = (IParameter)this.cursorDevice.getParameterBank().getItem(index);
        if (!item.doesExist()) {
            return;
        }
        if (isTouched && this.surface.isDeletePressed()) {
            this.surface.setTriggerConsumed(ButtonID.DELETE);
            item.resetValue();
        }
        item.touchValue(isTouched);
    }

    @Override
    public int getKnobValue(int index) {
        if (!this.cursorDevice.doesExist()) {
            return -1;
        }
        IParameter item = (IParameter)this.cursorDevice.getParameterBank().getItem(index);
        return item != null && item.doesExist() ? item.getValue() : -1;
    }

    @Override
    public Optional<String> getSelectedItemName() {
        if (!this.cursorDevice.doesExist()) {
            return Optional.empty();
        }
        IParameterPageBank parameterPageBank = this.cursorDevice.getParameterBank().getPageBank();
        Optional selectedItem = parameterPageBank.getSelectedItem();
        Object value = this.cursorDevice.getName();
        if (selectedItem.isPresent()) {
            value = (String)value + " - " + (String)selectedItem.get();
        }
        return Optional.of(value);
    }

    @Override
    public void selectPreviousItem() {
        if (this.isAlternativeFunction.getAsBoolean()) {
            this.cursorDevice.getDeviceBank().selectPreviousPage();
        } else {
            this.cursorDevice.selectPrevious();
        }
    }

    @Override
    public void selectNextItem() {
        if (this.isAlternativeFunction.getAsBoolean()) {
            this.cursorDevice.getDeviceBank().selectNextPage();
        } else {
            this.cursorDevice.selectNext();
        }
    }

    @Override
    public void selectPreviousItemPage() {
        this.cursorDevice.getParameterBank().scrollBackwards();
    }

    @Override
    public void selectNextItemPage() {
        this.cursorDevice.getParameterBank().scrollForwards();
    }

    @Override
    public void selectItem(int index) {
        this.cursorDevice.getParameterBank().getPageBank().selectPage(index);
    }

    @Override
    public boolean hasPreviousItem() {
        if (this.isAlternativeFunction.getAsBoolean()) {
            return this.cursorDevice.getDeviceBank().canScrollPageBackwards();
        }
        return this.cursorDevice.canSelectPrevious();
    }

    @Override
    public boolean hasNextItem() {
        if (this.isAlternativeFunction.getAsBoolean()) {
            return this.cursorDevice.getDeviceBank().canScrollPageForwards();
        }
        return this.cursorDevice.canSelectNext();
    }
}

