/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.track;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.utils.ButtonEvent;

public class SelectPrevNextTrackCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    protected boolean isLeft;

    public SelectPrevNextTrackCommand(IModel model, S surface, boolean isLeft) {
        super(model, surface);
        this.isLeft = isLeft;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ITrackBank tb = this.model.getCurrentTrackBank();
        if (this.isLeft) {
            tb.selectPreviousItem();
        } else {
            tb.selectNextItem();
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ITrackBank tb = this.model.getCurrentTrackBank();
        if (this.isLeft) {
            tb.selectPreviousPage();
        } else {
            tb.selectNextPage();
        }
    }
}

