/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.device;

import de.mossgrabers.framework.command.core.AbstractContinuousCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.parameter.IParameter;
import java.util.Date;

public class DeviceParamsKnobRowCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractContinuousCommand<S, C> {
    private final int index;
    private long moveStartTime;
    private boolean isKnobMoving;

    public DeviceParamsKnobRowCommand(int index, IModel model, S surface) {
        super(model, surface);
        this.index = index;
    }

    @Override
    public void execute(int value) {
        ICursorDevice cd = this.model.getCursorDevice();
        if (!cd.doesExist()) {
            return;
        }
        ((IParameter)cd.getParameterBank().getItem(this.index)).setValue(value);
        this.moveStartTime = new Date().getTime();
        if (this.isKnobMoving) {
            return;
        }
        this.isKnobMoving = true;
        this.startCheckKnobMovement();
    }

    public boolean isKnobMoving() {
        return this.isKnobMoving;
    }

    private void checkKnobMovement() {
        if (!this.isKnobMoving) {
            return;
        }
        if (new Date().getTime() - this.moveStartTime > 200L) {
            this.isKnobMoving = false;
        } else {
            this.startCheckKnobMovement();
        }
    }

    private void startCheckKnobMovement() {
        this.surface.scheduleTask(this::checkKnobMovement, 100L);
    }
}

