/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.command.trigger.application.UndoCommand;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.command.trigger.transport.RecordCommand;
import de.mossgrabers.framework.command.trigger.transport.TapTempoCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class FootswitchCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private final NewCommand<S, C> newCommand;
    private final RecordCommand<S, C> recordCommand;
    private final UndoCommand<S, C> undoCommand;
    private final TapTempoCommand<S, C> tapTempoCommand;
    private final PlayCommand<S, C> playCommand;
    protected final int index;

    public FootswitchCommand(IModel model, S surface, int index) {
        super(model, surface);
        this.index = index;
        this.newCommand = new NewCommand(model, surface);
        this.recordCommand = new RecordCommand(model, surface);
        this.undoCommand = new UndoCommand(this.model, surface);
        this.tapTempoCommand = new TapTempoCommand(this.model, surface);
        this.playCommand = new PlayCommand(this.model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (this.handleViewCommand(event) || event == ButtonEvent.LONG) {
            return;
        }
        boolean isDown = event == ButtonEvent.DOWN;
        switch (this.getSetting()) {
            case 2: {
                if (!isDown) break;
                this.model.getCurrentTrackBank().stop(false);
                break;
            }
            case 3: {
                if (!isDown) break;
                this.model.getTransport().toggleLauncherOverdub();
                break;
            }
            case 8: {
                if (!isDown) break;
                this.model.getApplication().setPanelLayout("ARRANGE");
                break;
            }
            case 9: {
                if (!isDown) break;
                this.model.getApplication().setPanelLayout("MIX");
                break;
            }
            case 10: {
                if (!isDown) break;
                this.model.getApplication().setPanelLayout("EDIT");
                break;
            }
            case 11: {
                if (!isDown) break;
                this.model.getTrackBank().addChannel(ChannelType.INSTRUMENT);
                break;
            }
            case 12: {
                if (!isDown) break;
                this.model.getTrackBank().addChannel(ChannelType.AUDIO);
                break;
            }
            case 13: {
                if (!isDown) break;
                this.model.getApplication().addEffectTrack();
                break;
            }
            case 14: {
                INoteClip clip;
                if (!isDown || !(clip = this.model.getCursorClip()).doesExist()) break;
                clip.quantize((double)this.surface.getConfiguration().getQuantizeAmount() / 100.0);
                break;
            }
            case 15: {
                this.surface.getMidiInput().sendRawMidiEvent(176, 64, isDown ? 127 : 0);
                break;
            }
            default: {
                this.model.getHost().error("Unknown footswitch command called: " + this.getSetting());
            }
        }
    }

    protected int getSetting() {
        return this.surface.getConfiguration().getFootswitch(this.index);
    }

    private boolean handleViewCommand(ButtonEvent event) {
        switch (this.getSetting()) {
            case 0: {
                this.playCommand.execute(event, 127);
                break;
            }
            case 1: {
                this.recordCommand.execute(event, 127);
                break;
            }
            case 4: {
                this.undoCommand.execute(event, 127);
                break;
            }
            case 5: {
                this.tapTempoCommand.execute(event, 127);
                break;
            }
            case 6: {
                this.newCommand.execute(event, 127);
                break;
            }
            case 7: {
                this.handleLooper(event);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void handleLooper(ButtonEvent event) {
        boolean isDown;
        if (event == ButtonEvent.LONG) {
            return;
        }
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        if (!cursorTrack.doesExist()) {
            this.surface.getDisplay().notify("Please select an Instrument track first.");
            return;
        }
        ISlotBank slotBank = cursorTrack.getSlotBank();
        Optional selectedSlot = slotBank.getSelectedItem();
        ISlot slot = selectedSlot.isEmpty() ? (ISlot)slotBank.getItem(0) : (ISlot)selectedSlot.get();
        boolean bl = isDown = event == ButtonEvent.DOWN;
        if (isDown && !slot.hasContent()) {
            this.newCommand.execute();
            slot.select();
        }
        this.model.getTransport().setLauncherOverdub(isDown);
        slot.launch(true, false);
    }
}

