/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.continuous;

import de.mossgrabers.framework.command.core.AbstractContinuousCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;

public class FaderAbsoluteCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractContinuousCommand<S, C> {
    private final int index;

    public FaderAbsoluteCommand(int index, IModel model, S surface) {
        super(model, surface);
        this.index = index;
    }

    @Override
    public void execute(int value) {
        ITrackBank currentTrackBank = this.model.getCurrentTrackBank();
        ITrack track = (ITrack)currentTrackBank.getItem(this.index);
        if (!track.doesExist()) {
            return;
        }
        if (this.surface.isShiftPressed()) {
            int volume = track.getVolume();
            this.surface.getDisplay().notify(FaderAbsoluteCommand.getNotificationText(value, volume));
        } else {
            track.setVolume(value);
        }
    }

    private static String getNotificationText(int value, int volume) {
        if (volume < value) {
            return "Move down";
        }
        return volume > value ? "Move up" : "Perfect!";
    }
}

