/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.utilities.midimonitor;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;

public class MidiMonitorConfiguration
extends AbstractConfiguration {
    public static final Integer FILTER_SYSTEM_REALTIME = 100;
    private boolean isFilterSystemRealtimeOn = false;

    public MidiMonitorConfiguration(IHost host, IValueChanger valueChanger) {
        super(host, valueChanger, null);
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        IEnumSetting filterSystemRealtimeSetting = globalSettings.getEnumSetting("System Realtime", "Filter", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        filterSystemRealtimeSetting.addValueObserver(value -> {
            this.isFilterSystemRealtimeOn = "On".equals(value);
            this.notifyObservers(FILTER_SYSTEM_REALTIME);
        });
        this.isSettingActive.add(FILTER_SYSTEM_REALTIME);
    }

    public boolean isFilterSystemRealtimeEnabled() {
        return this.isFilterSystemRealtimeOn;
    }
}

