/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.mode;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOneControlSurface;
import de.mossgrabers.controller.oxi.one.mode.IOxiModeDisplay;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.bank.ILayerBank;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.graphics.canvas.component.IComponent;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleChannelsComponent;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleValueMenuComponent;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameterprovider.device.SelectedLayerOrDrumPadParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FourKnobProvider;
import java.util.Optional;

public class OxiOneLayerMode
extends AbstractParameterMode<OxiOneControlSurface, OxiOneConfiguration, ILayer>
implements IOxiModeDisplay {
    private static final String[] MENU = new String[]{"Vol", "Pan", "S1", "S2"};
    private static final String[] SHIFTED_MENU = new String[]{"S3", "S4", "S5", "S6"};
    private static final Modes[] MODES = new Modes[]{Modes.VOLUME, Modes.PAN, Modes.SEND1, Modes.SEND2};
    private static final Modes[] ALT_MODES = new Modes[]{Modes.SEND3, Modes.SEND4, Modes.SEND5, Modes.SEND6};
    private Modes selectedParameter = Modes.VOLUME;
    private boolean isMixerMode = false;
    protected final ICursorDevice cursorDevice;

    public OxiOneLayerMode(OxiOneControlSurface surface, IModel model) {
        super("Layer", surface, model, true, model.getCursorDevice().getLayerBank());
        this.isAlternativeFunction = () -> false;
        this.cursorDevice = this.model.getCursorDevice();
        this.setControls(ContinuousID.createSequentialList(ContinuousID.KNOB1, 4));
        this.setParameterProvider(new FourKnobProvider(surface, new SelectedLayerOrDrumPadParameterProvider(this.getDrumDevice()), ButtonID.SHIFT));
        this.cursorDevice.addHasDrumPadsObserver(hasDrumPads -> this.switchBanks(this.cursorDevice.hasDrumPads() ? this.cursorDevice.getDrumPadBank() : this.cursorDevice.getLayerBank()));
    }

    @Override
    public void toggleDisplay() {
        this.isMixerMode = !this.isMixerMode;
    }

    @Override
    public void updateDisplay() {
        this.updateMode();
        IGraphicDisplay display = ((OxiOneControlSurface)this.surface).getGraphicsDisplay();
        display.addElement(this.isMixerMode ? this.drawMixerMode() : this.drawLayerMode());
        display.send();
    }

    private IComponent drawLayerMode() {
        Object desc = "Select";
        Object label = "a drum pad";
        int value = -1;
        int vuLeft = -1;
        int vuRight = -1;
        boolean isPan = false;
        Optional channelOptional = this.getDrumDevice().getLayerBank().getSelectedItem();
        if (channelOptional.isPresent()) {
            IChannel channel = (IChannel)channelOptional.get();
            vuLeft = channel.getVuLeft();
            vuRight = channel.getVuRight();
            desc = channel.getPosition() + 1 + ": " + channel.getName(9);
            ISendBank sendBank = channel.getSendBank();
            switch (this.selectedParameter) {
                case VOLUME: {
                    label = "Vol: " + channel.getVolumeStr();
                    value = channel.getVolume();
                    break;
                }
                case PAN: {
                    label = "Pan: " + channel.getPanStr();
                    value = channel.getPan();
                    isPan = true;
                    break;
                }
                case SEND1: 
                case SEND2: 
                case SEND3: 
                case SEND4: 
                case SEND5: 
                case SEND6: {
                    int sendIndex = this.selectedParameter.ordinal() - Modes.SEND1.ordinal();
                    label = OxiOneLayerMode.getSendLabel(sendBank, sendIndex);
                    value = OxiOneLayerMode.getSendValue(sendBank, sendIndex);
                    break;
                }
                default: {
                    label = "Select a track";
                }
            }
        }
        return new TitleValueMenuComponent((String)desc, (String)label, ((OxiOneControlSurface)this.surface).isShiftPressed() ? SHIFTED_MENU : MENU, value, vuLeft, vuRight, isPan);
    }

    private IComponent drawMixerMode() {
        boolean isMode;
        int[] values;
        boolean[] selected;
        Object label;
        block11: {
            int size;
            ILayerBank layerBank;
            block10: {
                IDrumDevice cd = this.model.getDrumDevice();
                layerBank = cd.getLayerBank();
                Optional channelOptional = layerBank.getSelectedItem();
                label = "None";
                if (channelOptional.isPresent()) {
                    IChannel channel = (IChannel)channelOptional.get();
                    label = channel.getPosition() + 1 + ": " + channel.getName(9);
                }
                size = layerBank.getPageSize();
                selected = new boolean[size];
                values = new int[size];
                boolean bl = isMode = this.isAnyKnobTouched() || !this.model.getTransport().isPlaying();
                if (!isMode) break block10;
                switch (this.selectedParameter) {
                    case VOLUME: {
                        for (int i = 0; i < size; ++i) {
                            IChannel channel = (IChannel)layerBank.getItem(i);
                            selected[i] = channel.isSelected();
                            values[i] = channel.getVolume();
                        }
                        break block11;
                    }
                    case PAN: {
                        for (int i = 0; i < size; ++i) {
                            IChannel channel = (IChannel)layerBank.getItem(i);
                            selected[i] = channel.isSelected();
                            values[i] = channel.getPan();
                        }
                        break block11;
                    }
                    case SEND1: 
                    case SEND2: 
                    case SEND3: 
                    case SEND4: 
                    case SEND5: 
                    case SEND6: {
                        int sendIndex = this.selectedParameter.ordinal() - Modes.SEND1.ordinal();
                        for (int i = 0; i < size; ++i) {
                            ISend send;
                            IChannel channel = (IChannel)layerBank.getItem(i);
                            selected[i] = channel.isSelected();
                            ISendBank sendBank = channel.getSendBank();
                            if (sendBank == null || !(send = (ISend)sendBank.getItem(sendIndex)).doesExist()) continue;
                            values[i] = send.getValue();
                        }
                        break block11;
                    }
                }
                break block11;
            }
            for (int i = 0; i < size; ++i) {
                IChannel channel = (IChannel)layerBank.getItem(i);
                selected[i] = channel.isSelected();
                values[i] = channel.getVu();
            }
        }
        return new TitleChannelsComponent((String)label, selected, values, this.selectedParameter == Modes.PAN && isMode);
    }

    protected void updateMode() {
        int index = -1;
        Modes[] ms = ((OxiOneControlSurface)this.surface).isPressed(ButtonID.SHIFT) ? MODES : ALT_MODES;
        for (int i = 0; i < ms.length; ++i) {
            if (ms[i] != this.selectedParameter) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            this.selectedParameter = ((OxiOneControlSurface)this.surface).isPressed(ButtonID.SHIFT) ? ALT_MODES[index] : MODES[index];
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.selectedParameter = ((OxiOneControlSurface)this.surface).isPressed(ButtonID.SHIFT) ? ALT_MODES[index] : MODES[index];
        this.setTouchedKnob(index, isTouched);
        Optional channelOptional = this.getDrumDevice().getLayerBank().getSelectedItem();
        if (!channelOptional.isPresent()) {
            return;
        }
        IChannel channel = (IChannel)channelOptional.get();
        switch (this.selectedParameter) {
            case VOLUME: {
                if (isTouched && ((OxiOneControlSurface)this.surface).isDeletePressed()) {
                    channel.resetVolume();
                }
                channel.touchVolume(isTouched);
                break;
            }
            case PAN: {
                if (isTouched && ((OxiOneControlSurface)this.surface).isDeletePressed()) {
                    channel.resetPan();
                }
                channel.touchPan(isTouched);
                break;
            }
            case SEND1: 
            case SEND2: 
            case SEND3: 
            case SEND4: 
            case SEND5: 
            case SEND6: {
                int sendIndex = this.selectedParameter.ordinal() - Modes.SEND1.ordinal();
                ISend item = (ISend)channel.getSendBank().getItem(sendIndex);
                if (isTouched && ((OxiOneControlSurface)this.surface).isDeletePressed()) {
                    item.resetValue();
                }
                item.touchValue(isTouched);
                break;
            }
        }
    }

    private static String getSendLabel(ISendBank sendBank, int index) {
        int pos = index + 1;
        if (sendBank == null) {
            return "No FX " + pos;
        }
        ISend send = (ISend)sendBank.getItem(index);
        if (!send.doesExist()) {
            return "No FX " + pos;
        }
        return send.getName(4) + ": " + send.getDisplayedValue();
    }

    private static int getSendValue(ISendBank sendBank, int index) {
        if (sendBank == null) {
            return 0;
        }
        ISend send = (ISend)sendBank.getItem(index);
        return send.doesExist() ? send.getValue() : 0;
    }

    private IDrumDevice getDrumDevice() {
        return this.model.getDrumDevice(16);
    }
}

