/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.controller;

import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.BlinkingPadGrid;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class OxiOnePadGrid
extends BlinkingPadGrid {
    private static final int[] COLOR_INDICES = new int[]{1, 9, 15, 255};
    private final byte[] header = new byte[7];
    private final ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();

    public OxiOnePadGrid(ColorManager colorManager, IMidiOutput output) {
        super(colorManager, output, 8, 16, 0);
        this.header[0] = -16;
        this.header[1] = 0;
        this.header[2] = 33;
        this.header[3] = 91;
        this.header[4] = 0;
        this.header[5] = 1;
        this.header[6] = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateController() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = this.byteBuffer;
            synchronized (byteArrayOutputStream) {
                this.byteBuffer.reset();
                this.byteBuffer.write(this.header);
                super.updateController();
                this.byteBuffer.write(-9);
                this.output.sendSysex(this.byteBuffer.toByteArray());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not create sysex message.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendPadUpdate(int note, int colorIndex) {
        ByteArrayOutputStream byteArrayOutputStream = this.byteBuffer;
        synchronized (byteArrayOutputStream) {
            this.byteBuffer.write((byte)(note / 16));
            this.byteBuffer.write((byte)(note % 16));
            ColorEx color = this.colorManager.getColor(colorIndex, ButtonID.PAD1);
            int red = OxiOnePadGrid.crushBits(color.getRed());
            this.byteBuffer.write((byte)((red & 0xF0) >> 4));
            this.byteBuffer.write((byte)(red & 0xF));
            int green = OxiOnePadGrid.crushBits(color.getGreen());
            this.byteBuffer.write((byte)((green & 0xF0) >> 4));
            this.byteBuffer.write((byte)(green & 0xF));
            int blue = OxiOnePadGrid.crushBits(color.getBlue());
            this.byteBuffer.write((byte)((blue & 0xF0) >> 4));
            this.byteBuffer.write((byte)(blue & 0xF));
        }
    }

    private static int crushBits(double colorPart) {
        if (colorPart == 0.0) {
            return 0;
        }
        return COLOR_INDICES[(int)Math.round(colorPart * 3.0)];
    }
}

