/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadColorManager;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.novation.launchpad.view.AbstractFaderView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.hardware.IHwContinuousControl;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.ScrollStates;

public class UserView
extends AbstractFaderView {
    protected IParameterBank projectParameterBank;
    protected IParameterBank trackParameterBank;
    protected boolean isProjectMode = true;

    public UserView(LaunchpadControlSurface surface, IModel model) {
        super("Project/Track Parameters", surface, model);
        this.projectParameterBank = model.getProject().getParameterBank();
        this.trackParameterBank = model.getCursorTrack().getParameterBank();
    }

    @Override
    public void setupFader(int index) {
        ((LaunchpadControlSurface)this.surface).setupFader(index, LaunchpadColorManager.DAW_INDICATOR_COLORS.get(index), false);
    }

    @Override
    public void onValueKnob(int index, int value) {
        ((IParameter)this.getBank().getItem(index)).setValueImmediatly(value);
    }

    @Override
    protected int getFaderValue(int index) {
        return ((IParameter)this.getBank().getItem(index)).getValue();
    }

    @Override
    public void drawGrid() {
        for (int i = 0; i < 8; ++i) {
            ((LaunchpadControlSurface)this.surface).setFaderValue(i, ((IParameter)this.getBank().getItem(i)).getValue());
        }
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID)) {
            return;
        }
        int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        IParameterPageBank pageBank = this.getBank().getPageBank();
        pageBank.selectPage(index);
        this.bindCurrentPage();
        this.notifyPage();
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        if (!ButtonID.isSceneButton(buttonID)) {
            return 0;
        }
        int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        IParameterPageBank pageBank = this.getBank().getPageBank();
        if (pageBank.getSelectedItemIndex() == index) {
            return 49;
        }
        return index < pageBank.getItemCount() ? 51 : 0;
    }

    @Override
    public void onDeactivate() {
        for (int i = 0; i < 8; ++i) {
            ContinuousID faderID = ContinuousID.get(ContinuousID.FADER1, i);
            IHwContinuousControl continuous = ((LaunchpadControlSurface)this.surface).getContinuous(faderID);
            if (continuous == null) continue;
            continuous.bind((IParameter)null);
        }
        ((LaunchpadControlSurface)this.surface).rebindGrid();
        super.onDeactivate();
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        IParameterBank parameterBank = this.getBank();
        scrollStates.setCanScrollLeft(parameterBank.canScrollPageBackwards());
        scrollStates.setCanScrollRight(parameterBank.canScrollPageForwards());
        scrollStates.setCanScrollUp(!this.isProjectMode);
        scrollStates.setCanScrollDown(this.isProjectMode);
    }

    private void bindCurrentPage() {
        for (int i = 0; i < 8; ++i) {
            ContinuousID faderID = ContinuousID.get(ContinuousID.FADER1, i);
            IHwContinuousControl continuous = ((LaunchpadControlSurface)this.surface).getContinuous(faderID);
            if (continuous == null) continue;
            continuous.bind((IParameter)this.getBank().getItem(i));
        }
    }

    public void setMode(boolean isProjectMode) {
        this.isProjectMode = isProjectMode;
        this.bindCurrentPage();
        this.notifyPage();
    }

    public void selectPreviousPage() {
        this.getBank().scrollBackwards();
        this.notifyPage();
    }

    public void selectNextPage() {
        this.getBank().scrollForwards();
        this.notifyPage();
    }

    private void notifyPage() {
        if (this.isProjectMode) {
            this.mvHelper.notifySelectedProjectParameterPage();
        } else {
            this.mvHelper.notifySelectedTrackParameterPage();
        }
    }

    private IParameterBank getBank() {
        return this.isProjectMode ? this.projectParameterBank : this.trackParameterBank;
    }
}

