/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.command.trigger;

import de.mossgrabers.controller.ni.maschine.Maschine;
import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.command.trigger.mode.ModeCursorCommand;
import de.mossgrabers.framework.command.trigger.mode.ModeMultiSelectCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class MaschineCursorCommand
extends ModeCursorCommand<MaschineControlSurface, MaschineConfiguration> {
    private final ModeMultiSelectCommand<MaschineControlSurface, MaschineConfiguration> modeSelector;
    private final boolean isStudio;
    private final boolean isUpDownEmulated;

    public MaschineCursorCommand(Direction direction, IModel model, MaschineControlSurface surface) {
        super(direction, model, surface, false);
        this.modeSelector = new ModeMultiSelectCommand(model, surface, Modes.POSITION, Modes.TEMPO, Modes.VOLUME);
        Maschine maschine = ((MaschineControlSurface)this.surface).getMaschine();
        this.isStudio = maschine == Maschine.STUDIO;
        this.isUpDownEmulated = maschine == Maschine.STUDIO || maschine == Maschine.MK2;
    }

    @Override
    protected void scrollLeft() {
        if (this.isStudio && ((MaschineControlSurface)this.surface).isPressed(ButtonID.OVERDUB)) {
            ((MaschineControlSurface)this.surface).setTriggerConsumed(ButtonID.OVERDUB);
            this.modeSelector.executeShifted(ButtonEvent.UP);
            return;
        }
        if (this.isUpDownEmulated && ((MaschineControlSurface)this.surface).isShiftPressed()) {
            super.scrollDown();
            return;
        }
        super.scrollLeft();
    }

    @Override
    protected void scrollRight() {
        if (this.isStudio && ((MaschineControlSurface)this.surface).isPressed(ButtonID.OVERDUB)) {
            ((MaschineControlSurface)this.surface).setTriggerConsumed(ButtonID.OVERDUB);
            this.modeSelector.executeNormal(ButtonEvent.UP);
            return;
        }
        if (this.isUpDownEmulated && ((MaschineControlSurface)this.surface).isShiftPressed()) {
            super.scrollUp();
            return;
        }
        super.scrollRight();
    }
}

