/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam.view;

import de.mossgrabers.controller.ni.maschine.jam.MaschineJamConfiguration;
import de.mossgrabers.controller.ni.maschine.jam.controller.MaschineJamControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractShiftView;

public class ShiftView
extends AbstractShiftView<MaschineJamControlSurface, MaschineJamConfiguration> {
    public ShiftView(MaschineJamControlSurface surface, IModel model) {
        super("Shift", surface, model);
    }

    @Override
    public void drawGrid() {
        IPadGrid padGrid = ((MaschineJamControlSurface)this.surface).getPadGrid();
        for (int i = 36; i < 92; ++i) {
            padGrid.light(i, 0);
        }
        padGrid.light(92, 5);
        padGrid.light(93, 29);
        padGrid.light(94, 33);
        padGrid.light(95, 33);
        padGrid.light(96, 57);
        padGrid.light(97, 57);
        padGrid.light(98, 7);
        padGrid.light(99, 7);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        this.setWasUsed();
        INoteClip cursorClip = this.model.getCursorClip();
        switch (note) {
            case 92: {
                this.model.getApplication().undo();
                return;
            }
            case 93: {
                this.model.getApplication().redo();
                return;
            }
            case 94: {
                if (cursorClip.doesExist()) {
                    cursorClip.quantize(1.0);
                }
                return;
            }
            case 95: {
                if (cursorClip.doesExist()) {
                    cursorClip.quantize(0.5);
                }
                return;
            }
            case 96: {
                if (cursorClip.doesExist()) {
                    cursorClip.transpose(-1);
                }
                return;
            }
            case 97: {
                if (cursorClip.doesExist()) {
                    cursorClip.transpose(1);
                }
                return;
            }
            case 98: {
                if (cursorClip.doesExist()) {
                    cursorClip.transpose(-12);
                }
                return;
            }
            case 99: {
                if (cursorClip.doesExist()) {
                    cursorClip.transpose(12);
                }
                return;
            }
        }
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        boolean flipSession = ((MaschineJamConfiguration)((MaschineJamControlSurface)this.surface).getConfiguration()).isFlipSession();
        boolean isDown = event == ButtonEvent.DOWN;
        switch (buttonID) {
            case ARROW_LEFT: 
            case ARROW_RIGHT: {
                if (!isDown) break;
                if (flipSession) {
                    this.scrollSceneBank(buttonID == ButtonID.ARROW_RIGHT);
                    break;
                }
                this.scrollTrackBank(buttonID == ButtonID.ARROW_RIGHT);
                break;
            }
            case ARROW_UP: 
            case ARROW_DOWN: {
                if (!isDown) break;
                if (flipSession) {
                    this.scrollTrackBank(buttonID == ButtonID.ARROW_DOWN);
                    break;
                }
                this.scrollSceneBank(buttonID == ButtonID.ARROW_DOWN);
                break;
            }
            default: {
                super.onButton(buttonID, event, velocity);
            }
        }
    }

    private void scrollTrackBank(boolean isForwards) {
        ITrackBank trackBank = this.model.getCurrentTrackBank();
        if (isForwards) {
            trackBank.selectNextPage();
        } else {
            trackBank.selectPreviousPage();
        }
    }

    private void scrollSceneBank(boolean isForwards) {
        ISceneBank sceneBank = this.model.getCurrentTrackBank().getSceneBank();
        if (isForwards) {
            sceneBank.selectNextPage();
        } else {
            sceneBank.selectPreviousPage();
        }
    }
}

