/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.core;

import java.util.HashMap;
import java.util.Map;

public enum RibbonMode {
    PITCH_DOWN("Pitch Down"),
    PITCH_UP("Pitch Up"),
    PITCH_DOWN_UP("Pitch Down/Up"),
    CC_1("Modulation (CC 1)"),
    CC_11("Expression (CC 11)"),
    MASTER_VOLUME("Master Volume"),
    NOTE_REPEAT_PERIOD("Note Repeat: Period"),
    NOTE_REPEAT_LENGTH("Note Repeat: Length");

    private static final String[] NAMES;
    private static final Map<String, RibbonMode> NAME_MODE_MAP;
    private final String name;

    private RibbonMode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static String[] getNames() {
        return NAMES;
    }

    public static RibbonMode lookupByName(String name) {
        return NAME_MODE_MAP.getOrDefault(name, PITCH_DOWN);
    }

    static {
        RibbonMode[] values = RibbonMode.values();
        NAMES = new String[values.length];
        NAME_MODE_MAP = new HashMap<String, RibbonMode>(values.length);
        for (int i = 0; i < values.length; ++i) {
            RibbonMode.NAMES[i] = values[i].getName();
            NAME_MODE_MAP.put(NAMES[i], values[i]);
        }
    }
}

