/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.intuitiveinstruments.exquis.view;

import de.mossgrabers.controller.intuitiveinstruments.exquis.ExquisConfiguration;
import de.mossgrabers.controller.intuitiveinstruments.exquis.controller.ExquisControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IDevice;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IDeviceBank;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.scale.Scales;

public class ExquisSelectionView
extends AbstractView<ExquisControlSurface, ExquisConfiguration> {
    public ExquisSelectionView(ExquisControlSurface surface, IModel model) {
        super("Selection", surface, model);
    }

    @Override
    public void onActivate() {
        ((ExquisControlSurface)this.surface).configureDeveloperMode(63);
        super.onActivate();
        ((ExquisControlSurface)this.surface).forceFlush();
    }

    @Override
    public void drawGrid() {
        int i;
        IPadGrid padGrid = ((ExquisControlSurface)this.surface).getPadGrid();
        ITrackBank trackBank = this.model.getTrackBank();
        IParameterBank parameterBank = this.getParameterBank();
        IParameterPageBank pageBank = parameterBank.getPageBank();
        int selectedItemIndex = pageBank.getSelectedItemIndex();
        for (int i2 = 0; i2 < pageBank.getPageSize(); ++i2) {
            String pageName = (String)pageBank.getItem(i2);
            String colorID = "GRID_COLOR_OFF";
            if (pageName != null && !pageName.isBlank()) {
                colorID = DAWColor.getColorID(selectedItemIndex == i2 ? ColorEx.WHITE : ColorEx.GREEN);
            }
            padGrid.light(36 + i2, colorID);
        }
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        IDeviceBank deviceBank = cursorDevice.getDeviceBank();
        boolean showCursorDevice = !((ExquisControlSurface)this.surface).getModeManager().isActive(new Modes[]{Modes.PROJECT});
        for (i = 0; i < deviceBank.getPageSize(); ++i) {
            IDevice device = (IDevice)deviceBank.getItem(i);
            String colorID = "GRID_COLOR_OFF";
            if (showCursorDevice && device.doesExist()) {
                colorID = DAWColor.getColorID(i == cursorDevice.getIndex() ? ColorEx.WHITE : ColorEx.PINK);
            }
            padGrid.light(58 + i, colorID);
        }
        for (i = 44; i < 55; ++i) {
            padGrid.light(36 + i, "GRID_COLOR_OFF");
        }
        padGrid.light(91, trackBank.canScrollPageBackwards() ? 102 : 101);
        padGrid.light(96, trackBank.canScrollPageForwards() ? 102 : 101);
        for (i = 0; i < 4; ++i) {
            ITrack track = (ITrack)trackBank.getItem(i);
            padGrid.light(92 + i, track.doesExist() ? DAWColor.getColorID(track.getColor()) : "BUTTON_STATE_OFF", track.isSelected() ? "BUTTON_STATE_ON" : null, true);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        ITrackBank trackBank = this.model.getTrackBank();
        switch (note) {
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                IParameterBank parameterBank = this.getParameterBank();
                IParameterPageBank pageBank = parameterBank.getPageBank();
                String pageName = (String)pageBank.getItem(note - 36);
                if (pageName == null) break;
                pageBank.selectPage(note - 36);
                this.mvHelper.notifySelectedParameterPage(parameterBank, "");
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                boolean showCursorDevice;
                IDeviceBank deviceBank = this.model.getCursorDevice().getDeviceBank();
                boolean bl = showCursorDevice = !((ExquisControlSurface)this.surface).getModeManager().isActive(new Modes[]{Modes.PROJECT});
                if (!showCursorDevice) break;
                ((IDevice)deviceBank.getItem(note - 58)).select();
                this.mvHelper.notifySelectedDevice();
                break;
            }
            case 91: {
                trackBank.selectPreviousPage();
                this.mvHelper.notifySelectedTrack();
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                ((ITrack)trackBank.getItem(note - 92)).select();
                this.mvHelper.notifySelectedTrack();
                break;
            }
            case 96: {
                trackBank.selectNextPage();
                this.mvHelper.notifySelectedTrack();
            }
        }
    }

    private IParameterBank getParameterBank() {
        switch ((Modes)((Object)((ExquisControlSurface)this.surface).getModeManager().getActiveID())) {
            case PROJECT: {
                return this.model.getProject().getParameterBank();
            }
            case TRACK_DETAILS: {
                return this.model.getCursorTrack().getParameterBank();
            }
        }
        return this.model.getCursorDevice().getParameterBank();
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        return this.colorManager.getColorIndex("GRID_COLOR_OFF");
    }

    @Override
    public void updateNoteMapping() {
        ((ExquisControlSurface)this.surface).scheduleTask(() -> this.delayedUpdateNoteMapping(Scales.getEmptyMatrix()), 100L);
    }
}

