/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.electra.one.controller;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.mossgrabers.controller.electra.one.ElectraOneConfiguration;
import de.mossgrabers.controller.electra.one.command.trigger.TouchCombinationCommand;
import de.mossgrabers.controller.electra.one.mode.AbstractElectraOneMode;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.FrameworkException;
import de.mossgrabers.framework.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ElectraOneControlSurface
extends AbstractControlSurface<ElectraOneConfiguration> {
    public static final int ELECTRA_CTRL_1 = 10;
    public static final int ELECTRA_ROW_1 = 70;
    private static final int SUBSCRIBED_EVENTS = 41;
    public static final List<ContinuousID> KNOB_IDS = new ArrayList<ContinuousID>();
    private static final ButtonID[] BUTTON_ROW_IDS;
    private static final ContinuousID[] CTRL_ROW_IDS;
    private static final byte[] SYSEX_HDR_BYTE;
    private static final int[] SYSEX_HDR_INT;
    private static final byte[] SYSEX_INFO_DEVICE;
    private static final byte[] SYSEX_INFO_PRESET_LIST;
    private static final byte[] SYSEX_RUNTIME_EXECUTE_LUA;
    private static final byte[] SYSEX_RUNTIME_SWITCH_PRESET;
    private static final byte[] SYSEX_RUNTIME_SWITCH_PAGE;
    private static final byte[] SYSEX_RUNTIME_CONTROL_UPDATE;
    private static final byte[] SYSEX_RUNTIME_VALUE_LABEL_UPDATE;
    private static final byte[] SYSEX_RUNTIME_SUBSCRIBE_EVENTS;
    private static final byte[] SYSEX_RUNTIME_SET_REPAINT_ENABLED;
    private static final byte[] SYSEX_RUNTIME_ENABLE_LOGGER;
    private static final int[] TOUCH_PATTERN_LINEAR_1__3;
    private static final int[] TOUCH_PATTERN_LINEAR_2__4;
    private static final int[] TOUCH_PATTERN_LINEAR_3__5;
    private static final int[] TOUCH_PATTERN_LINEAR_4__6;
    private static final int[] TOUCH_PATTERN_LINEAR_7__9;
    private static final int[] TOUCH_PATTERN_LINEAR_8__10;
    private static final int[] TOUCH_PATTERN_LINEAR_9__11;
    private static final int[] TOUCH_PATTERN_LINEAR_10__12;
    private static final int[] TOUCH_PATTERN_LINEAR_LEFT_1_2_4;
    private static final int[] TOUCH_PATTERN_LINEAR_LEFT_2_3_5;
    private static final int[] TOUCH_PATTERN_LINEAR_LEFT_3_4_6;
    private static final int[] TOUCH_PATTERN_LINEAR_LEFT_7_8_10;
    private static final int[] TOUCH_PATTERN_LINEAR_LEFT_8_9_11;
    private static final int[] TOUCH_PATTERN_LINEAR_LEFT_9_10_12;
    private static final int[] TOUCH_PATTERN_LINEAR_RIGHT_1_3_4;
    private static final int[] TOUCH_PATTERN_LINEAR_RIGHT_2_4_5;
    private static final int[] TOUCH_PATTERN_LINEAR_RIGHT_3_5_6;
    private static final int[] TOUCH_PATTERN_LINEAR_RIGHT_7_9_10;
    private static final int[] TOUCH_PATTERN_LINEAR_RIGHT_8_10_11;
    private static final int[] TOUCH_PATTERN_LINEAR_RIGHT_9_11_12;
    private static final int[] TOUCH_PATTERN_LINEAR_BROAD_1_3_5;
    private static final int[] TOUCH_PATTERN_LINEAR_BROAD_2_4_6;
    private static final int[] TOUCH_PATTERN_LINEAR_BROAD_7_9_11;
    private static final int[] TOUCH_PATTERN_LINEAR_BROAD_8_10_12;
    private static final int[] TOUCH_PATTERN_CORNER_LEFT_1_2_7;
    private static final int[] TOUCH_PATTERN_CORNER_LEFT_2_3_8;
    private static final int[] TOUCH_PATTERN_CORNER_LEFT_3_4_9;
    private static final int[] TOUCH_PATTERN_CORNER_LEFT_4_5_10;
    private static final int[] TOUCH_PATTERN_CORNER_LEFT_5_6_11;
    private static final int[] TOUCH_PATTERN_CORNER_RIGHT_1_2_8;
    private static final int[] TOUCH_PATTERN_CORNER_RIGHT_2_3_9;
    private static final int[] TOUCH_PATTERN_CORNER_RIGHT_3_4_10;
    private static final int[] TOUCH_PATTERN_CORNER_RIGHT_4_5_11;
    private static final int[] TOUCH_PATTERN_CORNER_RIGHT_5_6_12;
    private static final int[] TOUCH_PATTERN_TRIANGLE_2_7_9;
    private static final int[] TOUCH_PATTERN_TRIANGLE_3_8_10;
    private static final int[] TOUCH_PATTERN_TRIANGLE_4_9_11;
    private static final int[] TOUCH_PATTERN_TRIANGLE_5_10_12;
    private static final int[][] TOUCH_PATTERNS;
    private static final int CMD_START_POS;
    private static final int SUB_CMD_START_POS;
    private static final int CMD_INFO = 1;
    private static final int CMD_CONTROLLER = 126;
    private static final int CMD_SYSTEM_CALL = 127;
    private static final int EVENT_PRESET_SWITCH = 2;
    private static final int EVENT_PAGE_SWITCH = 6;
    private static final int EVENT_POT_TOUCH = 10;
    private static final int SYSTEM_CALL_LOGGING = 0;
    private static final int INFO_PRESET_LIST = 4;
    private static final int INFO_DEVICE = 127;
    private static final List<Modes> MODES;
    private static final String SET_GROUP_TITLE = "sgt(%s,\"%s\")";
    private final List<int[]> sysexChunks = new ArrayList<int[]>();
    private final IMidiInput ctrlInput;
    private final IMidiOutput ctrlOutput;
    private final ObjectMapper mapper = new ObjectMapper();
    private final Map<String, Integer> presetBanks = new HashMap<String, Integer>();
    private final Map<String, Integer> presetIndices = new HashMap<String, Integer>();
    private int bankIndex = -1;
    private int presetIndex = -1;
    private boolean isOnline = false;
    private final int[] knobStates = new int[12];
    private boolean isShiftPressed;
    private Modes activeMode = null;
    private TouchCombinationCommand[] touchCombinationCommands = null;
    private final Object touchCombinationCommandsLock = new Object();
    private final List<int[]> shiftPatterns = new ArrayList<int[]>();
    private final Map<int[], TouchCombinationCommand> commandPatterns = new HashMap<int[], TouchCombinationCommand>();

    public ElectraOneControlSurface(IHost host, ColorManager colorManager, ElectraOneConfiguration configuration, IMidiOutput output, IMidiInput input, IMidiInput ctrlInput, IMidiOutput ctrlOutput) {
        super(host, configuration, colorManager, output, input, null, 100.0, 200.0);
        this.ctrlInput = ctrlInput;
        this.ctrlOutput = ctrlOutput;
        this.ctrlInput.setSysexCallback(this::handleSysEx);
    }

    public static int getTouchPatternSize() {
        return TOUCH_PATTERNS.length;
    }

    public void setTouchCombinationCommands(TouchCombinationCommand[] touchCombinationCommands) {
        if (touchCombinationCommands.length != TOUCH_PATTERNS.length) {
            throw new FrameworkException("The number of touch commands must match the number of available touch patterns.");
        }
        this.touchCombinationCommands = touchCombinationCommands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTouchCombinationCommandsCache() {
        Object object = this.touchCombinationCommandsLock;
        synchronized (object) {
            if (this.touchCombinationCommands == null) {
                return;
            }
            this.shiftPatterns.clear();
            this.commandPatterns.clear();
            for (int i = 0; i < this.touchCombinationCommands.length; ++i) {
                TouchCombinationCommand command = this.touchCombinationCommands[i];
                int setting = ((ElectraOneConfiguration)this.configuration).getAssignable(i);
                if (setting == 0) continue;
                if (setting == 1) {
                    int[] shiftPattern = new int[TOUCH_PATTERNS[i].length];
                    for (int pos = 0; pos < shiftPattern.length; ++pos) {
                        shiftPattern[pos] = TOUCH_PATTERNS[i][pos] == 1 ? 1 : 2;
                    }
                    this.shiftPatterns.add(shiftPattern);
                    continue;
                }
                this.commandPatterns.put(TOUCH_PATTERNS[i], command);
            }
        }
    }

    public void updateGroupLabel(int groupID, String label) {
        this.sendLua(String.format(SET_GROUP_TITLE, Integer.toString(groupID), label));
    }

    public void updateValue(int midiCC, int value) {
        this.output.sendCCEx(15, midiCC, value);
    }

    public void updateLabel(int controlID, String name, ColorEx color, Boolean visibility) {
        StringWriter writer = new StringWriter();
        try (JsonGenerator generator = this.mapper.createGenerator((Writer)writer);){
            generator.writeStartObject();
            if (name != null) {
                generator.writeStringField("name", name);
            }
            if (color != null) {
                generator.writeStringField("color", StringUtils.formatColor(color));
            }
            if (visibility != null) {
                generator.writeBooleanField("visible", visibility.booleanValue());
            }
            generator.writeEndObject();
        }
        catch (IOException ex) {
            this.host.error(name, ex);
            return;
        }
        this.sendText(ElectraOneControlSurface.createCommand(controlID, SYSEX_RUNTIME_CONTROL_UPDATE), writer.toString());
    }

    public void updateValueLabel(int controlID, String label) {
        byte[] cmd = ElectraOneControlSurface.createCommand(controlID, SYSEX_RUNTIME_VALUE_LABEL_UPDATE);
        byte[] command = new byte[cmd.length + 1];
        System.arraycopy(cmd, 0, command, 0, cmd.length);
        command[cmd.length] = 0;
        this.sendText(command, label);
    }

    public void setLoggingEnabled() {
        byte[] content = new byte[]{(byte)(((ElectraOneConfiguration)this.configuration).isLogToConsoleEnabled() ? 1 : 0), 0};
        this.sendSysex(SYSEX_RUNTIME_ENABLE_LOGGER, content);
    }

    public void setRepaintEnabled(boolean enable) {
        byte[] content = new byte[]{(byte)(enable ? 1 : 0), 0};
        this.sendSysex(SYSEX_RUNTIME_SET_REPAINT_ENABLED, content);
    }

    public void requestDeviceInfo() {
        this.sendSysex(SYSEX_INFO_DEVICE, new byte[0]);
    }

    private void requestPresetList() {
        this.sendSysex(SYSEX_INFO_PRESET_LIST, new byte[0]);
    }

    public void selectDrivenByMossPreset() {
        this.selectPreset(this.bankIndex, this.presetIndex);
    }

    @Override
    public boolean isShiftPressed() {
        return this.isShiftPressed;
    }

    private void selectPreset(int bank, int preset) {
        this.host.println(String.format("Selecting preset: %d-%d", bank, preset));
        this.sendSysex(SYSEX_RUNTIME_SWITCH_PRESET, new byte[]{(byte)bank, (byte)preset});
    }

    public void selectPage(int page) {
        this.host.println(String.format("Selecting page: %d", page));
        this.sendSysex(SYSEX_RUNTIME_SWITCH_PAGE, new byte[]{(byte)page});
    }

    private void sendLua(String code) {
        this.sendText(SYSEX_RUNTIME_EXECUTE_LUA, code);
    }

    private void sendText(byte[] command, String text) {
        this.sendSysex(command, StringUtils.fixASCII(text).getBytes());
    }

    private void sendSysex(byte[] command, byte[] content) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            out.write(SYSEX_HDR_BYTE);
            out.write(command);
            out.write(content);
            out.write(-9);
            this.ctrlOutput.sendSysex(out.toByteArray());
        }
        catch (IOException ex) {
            this.host.error("Could not schedule JSON command.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSysEx(String dataStr) {
        int[] data = StringUtils.fromHexStr(dataStr);
        int[] fullData = null;
        List<int[]> list = this.sysexChunks;
        synchronized (list) {
            if (data[0] == 240 && !this.sysexChunks.isEmpty()) {
                this.host.error("Unsound sysex message without ending F7 received.");
                this.sysexChunks.clear();
            }
            this.sysexChunks.add(data);
            if (data[data.length - 1] == 247) {
                fullData = this.concatChunks();
                this.sysexChunks.clear();
            }
        }
        if (fullData != null) {
            this.processSysEx(fullData);
        }
    }

    private int[] concatChunks() {
        if (this.sysexChunks.size() == 1) {
            return this.sysexChunks.get(0);
        }
        int totalLength = 0;
        for (int[] array : this.sysexChunks) {
            totalLength += array.length;
        }
        int[] result = new int[totalLength];
        int offset = 0;
        for (int[] array : this.sysexChunks) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    private void processSysEx(int[] data) {
        if (Arrays.compareUnsigned(SYSEX_HDR_INT, 0, SYSEX_HDR_INT.length, data, 0, SYSEX_HDR_INT.length) != 0) {
            return;
        }
        int subCmdID = data[SUB_CMD_START_POS];
        switch (data[CMD_START_POS]) {
            case 1: {
                this.handleSysexCommandsInfo(subCmdID, data);
                break;
            }
            case 126: {
                this.handleSysexCommandsController(subCmdID, data);
                break;
            }
            case 127: {
                if (subCmdID != 0) break;
                this.logMessage(data, 6);
                break;
            }
        }
    }

    private void handleSysexCommandsController(int commandID, int[] data) {
        switch (commandID) {
            case 2: {
                this.handleOnlineStatus(data[SUB_CMD_START_POS + 1], data[SUB_CMD_START_POS + 2]);
                break;
            }
            case 6: {
                int page;
                if (!this.isOnline || (page = data[SUB_CMD_START_POS + 1]) < 0 || page >= MODES.size()) break;
                Modes mode = MODES.get(page);
                this.host.println("Switching to mode: " + mode.name());
                this.modeManager.setActive(mode);
                break;
            }
            case 10: {
                int potID = data[SUB_CMD_START_POS + 1];
                int controlID = (data[SUB_CMD_START_POS + 3] << 7) + data[SUB_CMD_START_POS + 2];
                if (potID < 0 || potID >= 12) {
                    this.host.error("Touch event with knob ID outside of range: " + potID);
                    return;
                }
                this.knobStates[potID] = data[SUB_CMD_START_POS + 4];
                IMode active = (IMode)this.modeManager.getActive();
                if (active instanceof AbstractElectraOneMode) {
                    AbstractElectraOneMode electraMode = (AbstractElectraOneMode)active;
                    electraMode.setEditing(controlID, this.knobStates[potID] > 0);
                }
                this.matchStates();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void matchStates() {
        boolean handled = false;
        Object object = this.touchCombinationCommandsLock;
        synchronized (object) {
            for (int[] nArray : this.shiftPatterns) {
                if (!ElectraOneControlSurface.compareWithIgnore(this.knobStates, nArray)) continue;
                this.updateShift(true);
                return;
            }
            for (Map.Entry entry : this.commandPatterns.entrySet()) {
                if (!Arrays.equals(this.knobStates, (int[])entry.getKey())) continue;
                TouchCombinationCommand cmd = (TouchCombinationCommand)entry.getValue();
                cmd.execute(ButtonEvent.DOWN, 127);
                cmd.execute(ButtonEvent.UP, 0);
                handled = true;
                break;
            }
        }
        if (!handled) {
            this.updateShift(false);
            return;
        }
        Arrays.fill(this.knobStates, 0);
    }

    public void switchToSpecificDevicePreset() {
        AbstractElectraOneMode electraMode;
        Optional<String> deviceNameOpt;
        if (!this.isOnline) {
            this.selectDrivenByMossPreset();
            return;
        }
        Object f = this.modeManager.getActive();
        if (f instanceof AbstractElectraOneMode && (deviceNameOpt = (electraMode = (AbstractElectraOneMode)f).getActiveDeviceName()).isPresent()) {
            String deviceName = deviceNameOpt.get();
            Integer bank = this.presetBanks.get(deviceName);
            if (bank == null) {
                this.host.println(String.format("No specific preset found for '%s', switching to device mode.", deviceName));
                this.selectPage(2);
            } else {
                Integer slot = this.presetIndices.get(deviceName);
                this.host.println(String.format("Found preset found for '%s' at %d-%d.", deviceName, bank, slot));
                this.selectPreset(bank, slot);
            }
            Arrays.fill(this.knobStates, 0);
        }
    }

    public void updateShift(boolean isShift) {
        this.isShiftPressed = isShift;
        this.setKnobSensitivityIsSlow(this.isShiftPressed);
    }

    private static boolean compareWithIgnore(int[] knobStates, int[] touchPattern) {
        for (int i = 0; i < touchPattern.length; ++i) {
            if (touchPattern[i] == 2 || touchPattern[i] == knobStates[i]) continue;
            return false;
        }
        return true;
    }

    private void handleSysexCommandsInfo(int commandID, int[] data) {
        JsonNode content = this.getContent(data);
        switch (commandID) {
            case 127: {
                this.checkFirmwareResult(content);
                this.sendSysex(SYSEX_RUNTIME_SUBSCRIBE_EVENTS, new byte[]{41});
                this.requestPresetList();
                break;
            }
            case 4: {
                this.findAndSelectDrivenByMossPreset(content);
                this.selectDrivenByMossPreset();
                break;
            }
        }
    }

    private void checkFirmwareResult(JsonNode root) {
        int version = root.get("versionSeq").asInt();
        String versionText = root.get("versionText").asText();
        if (version < 300400300) {
            this.host.error("Firmware must be at least 3.4.2 but is " + versionText);
        } else {
            this.host.println("Firmware: " + versionText);
        }
    }

    private void handleOnlineStatus(int bank, int preset) {
        if (this.bankIndex == bank && this.presetIndex == preset) {
            this.setOnline();
        } else {
            this.setOffline();
        }
    }

    private void setOffline() {
        this.host.println("Going offline...");
        this.isOnline = false;
        this.activeMode = (Modes)((Object)this.modeManager.getActiveID());
        this.modeManager.setActive(Modes.DUMMY);
    }

    private void setOnline() {
        this.host.println("Going online...");
        this.isOnline = true;
        this.modeManager.setActive(Modes.VOLUME);
        this.selectPage(MODES.indexOf((Object)(this.activeMode == null ? Modes.VOLUME : this.activeMode)));
    }

    private void findAndSelectDrivenByMossPreset(JsonNode root) {
        for (JsonNode preset : root.get("presets")) {
            JsonNode nameNode = preset.get("name");
            JsonNode bankNumberNode = preset.get("bankNumber");
            JsonNode slotNode = preset.get("slot");
            if (nameNode == null || bankNumberNode == null || slotNode == null) continue;
            String presetName = nameNode.asText();
            int bankNumber = bankNumberNode.asInt();
            int slot = slotNode.asInt();
            if ("DrivenByMoss".equals(presetName)) {
                this.bankIndex = bankNumber;
                this.presetIndex = slot;
                this.host.println(String.format("DrivenByMoss template at: %d-%d", this.bankIndex, this.presetIndex));
                continue;
            }
            this.presetBanks.put(presetName, bankNumber);
            this.presetIndices.put(presetName, slot);
        }
        if (this.bankIndex == -1) {
            throw new FrameworkException("The DrivenByMoss template is not installed on the Electra.One.");
        }
    }

    private void logMessage(int[] data, int contentStart) {
        if (((ElectraOneConfiguration)this.configuration).isLogToConsoleEnabled()) {
            this.host.println(new String(data, contentStart, data.length - contentStart - 1));
        }
    }

    private JsonNode getContent(int[] data) {
        String content = StringUtils.integerArrayToString(SUB_CMD_START_POS + 1, data.length - SUB_CMD_START_POS - 2, data);
        try {
            return (JsonNode)this.mapper.readValue(content, JsonNode.class);
        }
        catch (JsonProcessingException ex) {
            throw new FrameworkException("Could not parse JSON information.", ex);
        }
    }

    @Override
    public void setTrigger(BindType bindType, int channel, int cc, int value) {
        if (this.isOnline) {
            super.setTrigger(bindType, channel, cc, value);
        }
    }

    @Override
    protected void handleMidi(int status, int data1, int data2) {
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    public static ButtonID getButtonID(int row, int column) {
        return ButtonID.get(BUTTON_ROW_IDS[row], column);
    }

    public static ContinuousID getContinuousID(int row, int column) {
        return ContinuousID.get(CTRL_ROW_IDS[row], column);
    }

    private static final byte[] createCommand(int controlID, byte[] commandID) {
        byte[] command = new byte[]{commandID[0], commandID[1], (byte)(controlID & 0x7F), (byte)(controlID >> 7)};
        return command;
    }

    static {
        KNOB_IDS.addAll(ContinuousID.createSequentialList(ContinuousID.VOLUME_KNOB1, 6));
        KNOB_IDS.addAll(ContinuousID.createSequentialList(ContinuousID.PAN_KNOB1, 6));
        KNOB_IDS.addAll(ContinuousID.createSequentialList(ContinuousID.FADER1, 6));
        KNOB_IDS.addAll(ContinuousID.createSequentialList(ContinuousID.KNOB1, 6));
        KNOB_IDS.addAll(ContinuousID.createSequentialList(ContinuousID.PARAM_KNOB1, 6));
        KNOB_IDS.addAll(ContinuousID.createSequentialList(ContinuousID.DEVICE_KNOB1, 6));
        BUTTON_ROW_IDS = new ButtonID[]{ButtonID.ROW1_1, ButtonID.ROW2_1, ButtonID.ROW3_1, ButtonID.ROW4_1, ButtonID.ROW5_1, ButtonID.ROW6_1};
        CTRL_ROW_IDS = new ContinuousID[]{ContinuousID.VOLUME_KNOB1, ContinuousID.PAN_KNOB1, ContinuousID.FADER1, ContinuousID.KNOB1, ContinuousID.PARAM_KNOB1, ContinuousID.DEVICE_KNOB1};
        SYSEX_HDR_BYTE = new byte[]{-16, 0, 33, 69};
        SYSEX_HDR_INT = new int[]{240, 0, 33, 69};
        SYSEX_INFO_DEVICE = new byte[]{2, 127};
        SYSEX_INFO_PRESET_LIST = new byte[]{2, 4};
        SYSEX_RUNTIME_EXECUTE_LUA = new byte[]{8, 13};
        SYSEX_RUNTIME_SWITCH_PRESET = new byte[]{9, 8};
        SYSEX_RUNTIME_SWITCH_PAGE = new byte[]{9, 10};
        SYSEX_RUNTIME_CONTROL_UPDATE = new byte[]{20, 7};
        SYSEX_RUNTIME_VALUE_LABEL_UPDATE = new byte[]{20, 14};
        SYSEX_RUNTIME_SUBSCRIBE_EVENTS = new byte[]{20, 121};
        SYSEX_RUNTIME_SET_REPAINT_ENABLED = new byte[]{127, 122};
        SYSEX_RUNTIME_ENABLE_LOGGER = new byte[]{127, 125};
        TOUCH_PATTERN_LINEAR_1__3 = new int[]{1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        TOUCH_PATTERN_LINEAR_2__4 = new int[]{0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0};
        TOUCH_PATTERN_LINEAR_3__5 = new int[]{0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0};
        TOUCH_PATTERN_LINEAR_4__6 = new int[]{0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0};
        TOUCH_PATTERN_LINEAR_7__9 = new int[]{0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0};
        TOUCH_PATTERN_LINEAR_8__10 = new int[]{0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0};
        TOUCH_PATTERN_LINEAR_9__11 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0};
        TOUCH_PATTERN_LINEAR_10__12 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1};
        TOUCH_PATTERN_LINEAR_LEFT_1_2_4 = new int[]{1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0};
        TOUCH_PATTERN_LINEAR_LEFT_2_3_5 = new int[]{0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0};
        TOUCH_PATTERN_LINEAR_LEFT_3_4_6 = new int[]{0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0};
        TOUCH_PATTERN_LINEAR_LEFT_7_8_10 = new int[]{0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0};
        TOUCH_PATTERN_LINEAR_LEFT_8_9_11 = new int[]{0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0};
        TOUCH_PATTERN_LINEAR_LEFT_9_10_12 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1};
        TOUCH_PATTERN_LINEAR_RIGHT_1_3_4 = new int[]{1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0};
        TOUCH_PATTERN_LINEAR_RIGHT_2_4_5 = new int[]{0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0};
        TOUCH_PATTERN_LINEAR_RIGHT_3_5_6 = new int[]{0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0};
        TOUCH_PATTERN_LINEAR_RIGHT_7_9_10 = new int[]{0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0};
        TOUCH_PATTERN_LINEAR_RIGHT_8_10_11 = new int[]{0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0};
        TOUCH_PATTERN_LINEAR_RIGHT_9_11_12 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1};
        TOUCH_PATTERN_LINEAR_BROAD_1_3_5 = new int[]{1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0};
        TOUCH_PATTERN_LINEAR_BROAD_2_4_6 = new int[]{0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0};
        TOUCH_PATTERN_LINEAR_BROAD_7_9_11 = new int[]{0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0};
        TOUCH_PATTERN_LINEAR_BROAD_8_10_12 = new int[]{0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1};
        TOUCH_PATTERN_CORNER_LEFT_1_2_7 = new int[]{1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0};
        TOUCH_PATTERN_CORNER_LEFT_2_3_8 = new int[]{0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0};
        TOUCH_PATTERN_CORNER_LEFT_3_4_9 = new int[]{0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0};
        TOUCH_PATTERN_CORNER_LEFT_4_5_10 = new int[]{0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0};
        TOUCH_PATTERN_CORNER_LEFT_5_6_11 = new int[]{0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0};
        TOUCH_PATTERN_CORNER_RIGHT_1_2_8 = new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0};
        TOUCH_PATTERN_CORNER_RIGHT_2_3_9 = new int[]{0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0};
        TOUCH_PATTERN_CORNER_RIGHT_3_4_10 = new int[]{0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0};
        TOUCH_PATTERN_CORNER_RIGHT_4_5_11 = new int[]{0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0};
        TOUCH_PATTERN_CORNER_RIGHT_5_6_12 = new int[]{0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1};
        TOUCH_PATTERN_TRIANGLE_2_7_9 = new int[]{0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0};
        TOUCH_PATTERN_TRIANGLE_3_8_10 = new int[]{0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0};
        TOUCH_PATTERN_TRIANGLE_4_9_11 = new int[]{0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0};
        TOUCH_PATTERN_TRIANGLE_5_10_12 = new int[]{0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1};
        TOUCH_PATTERNS = new int[][]{TOUCH_PATTERN_LINEAR_1__3, TOUCH_PATTERN_LINEAR_2__4, TOUCH_PATTERN_LINEAR_3__5, TOUCH_PATTERN_LINEAR_4__6, TOUCH_PATTERN_LINEAR_7__9, TOUCH_PATTERN_LINEAR_8__10, TOUCH_PATTERN_LINEAR_9__11, TOUCH_PATTERN_LINEAR_10__12, TOUCH_PATTERN_LINEAR_LEFT_1_2_4, TOUCH_PATTERN_LINEAR_LEFT_2_3_5, TOUCH_PATTERN_LINEAR_LEFT_3_4_6, TOUCH_PATTERN_LINEAR_LEFT_7_8_10, TOUCH_PATTERN_LINEAR_LEFT_8_9_11, TOUCH_PATTERN_LINEAR_LEFT_9_10_12, TOUCH_PATTERN_LINEAR_RIGHT_1_3_4, TOUCH_PATTERN_LINEAR_RIGHT_2_4_5, TOUCH_PATTERN_LINEAR_RIGHT_3_5_6, TOUCH_PATTERN_LINEAR_RIGHT_7_9_10, TOUCH_PATTERN_LINEAR_RIGHT_8_10_11, TOUCH_PATTERN_LINEAR_RIGHT_9_11_12, TOUCH_PATTERN_LINEAR_BROAD_1_3_5, TOUCH_PATTERN_LINEAR_BROAD_2_4_6, TOUCH_PATTERN_LINEAR_BROAD_7_9_11, TOUCH_PATTERN_LINEAR_BROAD_8_10_12, TOUCH_PATTERN_CORNER_LEFT_1_2_7, TOUCH_PATTERN_CORNER_LEFT_2_3_8, TOUCH_PATTERN_CORNER_LEFT_3_4_9, TOUCH_PATTERN_CORNER_LEFT_4_5_10, TOUCH_PATTERN_CORNER_LEFT_5_6_11, TOUCH_PATTERN_CORNER_RIGHT_1_2_8, TOUCH_PATTERN_CORNER_RIGHT_2_3_9, TOUCH_PATTERN_CORNER_RIGHT_3_4_10, TOUCH_PATTERN_CORNER_RIGHT_4_5_11, TOUCH_PATTERN_CORNER_RIGHT_5_6_12, TOUCH_PATTERN_TRIANGLE_2_7_9, TOUCH_PATTERN_TRIANGLE_3_8_10, TOUCH_PATTERN_TRIANGLE_4_9_11, TOUCH_PATTERN_TRIANGLE_5_10_12};
        CMD_START_POS = SYSEX_HDR_INT.length;
        SUB_CMD_START_POS = SYSEX_HDR_INT.length + 1;
        MODES = new ArrayList<Modes>();
        Collections.addAll(MODES, Modes.VOLUME, Modes.SEND, Modes.DEVICE_PARAMS, Modes.EQ_DEVICE_PARAMS, Modes.TRANSPORT, Modes.SESSION, Modes.PROJECT);
    }
}

