/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.arturia.beatstep.view;

import de.mossgrabers.controller.arturia.beatstep.BeatstepConfiguration;
import de.mossgrabers.controller.arturia.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.arturia.beatstep.view.BeatstepView;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.AbstractView;

public class BrowserView
extends AbstractView<BeatstepControlSurface, BeatstepConfiguration>
implements BeatstepView {
    public BrowserView(BeatstepControlSurface surface, IModel model) {
        super("Browser", surface, model);
    }

    @Override
    public void onKnob(int index, int value) {
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            return;
        }
        IValueChanger valueChanger = this.model.getValueChanger();
        int steps = Math.abs(valueChanger.calcSteppedKnobChange(value));
        boolean isIncrease = valueChanger.isIncrease(value);
        switch (index) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                int column = index - 8;
                if (isIncrease) {
                    for (int i = 0; i < steps; ++i) {
                        browser.selectNextFilterItem(column);
                    }
                } else {
                    for (int i = 0; i < steps; ++i) {
                        browser.selectPreviousFilterItem(column);
                    }
                }
                break;
            }
            case 15: {
                if (isIncrease) {
                    for (int i = 0; i < steps; ++i) {
                        browser.selectNextResult();
                    }
                } else {
                    for (int i = 0; i < steps; ++i) {
                        browser.selectPreviousResult();
                    }
                }
                break;
            }
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            return;
        }
        switch (note - 36) {
            case 0: {
                if (velocity == 0) {
                    return;
                }
                browser.stopBrowsing(false);
                ((BeatstepControlSurface)this.surface).getViewManager().restore();
                break;
            }
            case 7: {
                if (velocity == 0) {
                    return;
                }
                browser.stopBrowsing(true);
                ((BeatstepControlSurface)this.surface).getViewManager().restore();
                break;
            }
            case 2: {
                ((BeatstepControlSurface)this.surface).sendMidiEvent(144, 12, velocity);
                break;
            }
            case 3: {
                ((BeatstepControlSurface)this.surface).sendMidiEvent(144, 24, velocity);
                break;
            }
            case 4: {
                ((BeatstepControlSurface)this.surface).sendMidiEvent(144, 36, velocity);
                break;
            }
            case 5: {
                ((BeatstepControlSurface)this.surface).sendMidiEvent(144, 48, velocity);
                break;
            }
            case 10: {
                ((BeatstepControlSurface)this.surface).sendMidiEvent(144, 60, velocity);
                break;
            }
            case 11: {
                ((BeatstepControlSurface)this.surface).sendMidiEvent(144, 72, velocity);
                break;
            }
            case 12: {
                ((BeatstepControlSurface)this.surface).sendMidiEvent(144, 84, velocity);
                break;
            }
            case 13: {
                ((BeatstepControlSurface)this.surface).sendMidiEvent(144, 96, velocity);
                break;
            }
        }
    }

    @Override
    public void drawGrid() {
        int i;
        IPadGrid padGrid = ((BeatstepControlSurface)this.surface).getPadGrid();
        padGrid.light(36, 1);
        padGrid.light(37, 0);
        for (i = 2; i < 6; ++i) {
            padGrid.light(36 + i, 17);
        }
        padGrid.light(42, 0);
        padGrid.light(43, 16);
        padGrid.light(44, 0);
        padGrid.light(45, 0);
        for (i = 10; i < 14; ++i) {
            padGrid.light(36 + i, 17);
        }
        padGrid.light(50, 0);
        padGrid.light(51, 0);
    }
}

