/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.view;

import de.mossgrabers.controller.akai.apc.APCConfiguration;
import de.mossgrabers.controller.akai.apc.command.trigger.APCBrowserCommand;
import de.mossgrabers.controller.akai.apc.controller.APCControlSurface;
import de.mossgrabers.controller.akai.apc.view.SessionView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractShiftView;
import de.mossgrabers.framework.view.Views;

public class ShiftView
extends AbstractShiftView<APCControlSurface, APCConfiguration> {
    private static final Views[] VIEW_IDS = new Views[]{Views.SESSION, Views.PLAY, Views.DRUM, Views.SEQUENCER, Views.RAINDROPS};
    private static final int[] TRANSLATE = new int[]{0, 2, 4, 6, 1, 3, 5, -1, -1, 10, 8, -1, 11, 9, 7, -1};
    private final APCBrowserCommand browserCommand;

    public ShiftView(APCControlSurface surface, IModel model) {
        super("Shift", surface, model);
        this.browserCommand = new APCBrowserCommand(model, surface);
    }

    @Override
    public void drawGrid() {
        int i;
        IPadGrid padGrid = ((APCControlSurface)this.surface).getPadGrid();
        for (i = 7; i < 64; ++i) {
            padGrid.light(36 + i, 0);
        }
        for (i = 0; i < 3; ++i) {
            padGrid.light(68 + i, "COLOR_KEY_WHITE");
        }
        padGrid.light(71, "COLOR_KEY_SELECTED");
        padGrid.light(72, "COLOR_KEY_SELECTED");
        padGrid.light(74, "COLOR_KEY_BLACK");
        padGrid.light(75, "COLOR_KEY_BLACK");
        int scaleOffset = this.model.getScales().getScaleOffsetIndex();
        padGrid.light(36, scaleOffset == 0 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_WHITE");
        padGrid.light(37, scaleOffset == 2 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_WHITE");
        padGrid.light(38, scaleOffset == 4 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_WHITE");
        padGrid.light(39, scaleOffset == 6 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_WHITE");
        padGrid.light(40, scaleOffset == 1 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_WHITE");
        padGrid.light(41, scaleOffset == 3 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_WHITE");
        padGrid.light(42, scaleOffset == 5 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_WHITE");
        padGrid.light(45, scaleOffset == 10 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_BLACK");
        padGrid.light(46, scaleOffset == 8 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_BLACK");
        padGrid.light(48, scaleOffset == 11 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_BLACK");
        padGrid.light(49, scaleOffset == 9 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_BLACK");
        padGrid.light(50, scaleOffset == 7 ? "COLOR_KEY_SELECTED" : "COLOR_KEY_BLACK");
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        this.setWasUsed();
        int index = note - 36;
        if (index > 15) {
            switch (index) {
                case 32: {
                    this.model.getTrackBank().addChannel(ChannelType.INSTRUMENT);
                    break;
                }
                case 33: {
                    this.model.getTrackBank().addChannel(ChannelType.AUDIO);
                    break;
                }
                case 34: {
                    this.model.getApplication().addEffectTrack();
                    break;
                }
                case 35: 
                case 36: {
                    this.browserCommand.startBrowser(true, index == 35);
                    break;
                }
                case 38: {
                    this.model.getApplication().undo();
                    break;
                }
                case 39: {
                    this.model.getApplication().redo();
                    break;
                }
            }
            return;
        }
        int pos = TRANSLATE[index];
        if (pos == -1) {
            return;
        }
        this.model.getScales().setScaleOffsetByIndex(pos);
        ((APCConfiguration)((APCControlSurface)this.surface).getConfiguration()).setScaleBase(Scales.BASES.get(pos));
        ((APCControlSurface)this.surface).getDisplay().notify(Scales.BASES.get(pos));
        ((IView)((APCControlSurface)this.surface).getViewManager().getActive()).updateNoteMapping();
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN) {
            return;
        }
        int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        ViewManager viewManager = ((APCControlSurface)this.surface).getViewManager();
        if (viewManager.getActiveIDIgnoreTemporary() == Views.SESSION && VIEW_IDS[index] == Views.SESSION) {
            ((SessionView)viewManager.get(Views.SESSION)).toggleBirdsEyeView();
        } else {
            viewManager.setActive(VIEW_IDS[index]);
        }
        ((APCControlSurface)this.surface).getDisplay().notify(((IView)viewManager.get(VIEW_IDS[index])).getName());
        if (Views.SESSION.equals((Object)VIEW_IDS[index])) {
            return;
        }
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        if (cursorTrack.doesExist()) {
            viewManager.setPreferredView(cursorTrack.getPosition(), VIEW_IDS[index]);
        }
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        Views previousViewId = (Views)((Object)((APCControlSurface)this.surface).getViewManager().getActiveIDIgnoreTemporary());
        if (buttonID == ButtonID.SCENE1) {
            return Views.SESSION.equals((Object)previousViewId) ? "COLOR_VIEW_SELECTED" : "COLOR_VIEW_UNSELECTED";
        }
        if (buttonID == ButtonID.SCENE2) {
            return Views.PLAY.equals((Object)previousViewId) ? "COLOR_VIEW_SELECTED" : "COLOR_VIEW_UNSELECTED";
        }
        if (buttonID == ButtonID.SCENE3) {
            return Views.DRUM.equals((Object)previousViewId) ? "COLOR_VIEW_SELECTED" : "COLOR_VIEW_UNSELECTED";
        }
        if (buttonID == ButtonID.SCENE4) {
            return Views.SEQUENCER.equals((Object)previousViewId) ? "COLOR_VIEW_SELECTED" : "COLOR_VIEW_UNSELECTED";
        }
        if (buttonID == ButtonID.SCENE5) {
            return Views.RAINDROPS.equals((Object)previousViewId) ? "COLOR_VIEW_SELECTED" : "COLOR_VIEW_UNSELECTED";
        }
        return "BUTTON_STATE_OFF";
    }
}

