/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.command.trigger;

import de.mossgrabers.controller.akai.apc.APCConfiguration;
import de.mossgrabers.controller.akai.apc.controller.APCControlSurface;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.command.trigger.mode.CursorCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class APCCursorCommand
extends CursorCommand<APCControlSurface, APCConfiguration> {
    public APCCursorCommand(Direction direction, IModel model, APCControlSurface surface) {
        super(direction, model, surface, false);
        this.triggerEvent = ButtonEvent.UP;
    }

    @Override
    protected void scrollUp() {
        if (((APCControlSurface)this.surface).getModeManager().isActive(new Modes[]{Modes.BROWSER})) {
            this.model.getBrowser().selectPreviousResult();
            return;
        }
        super.scrollUp();
    }

    @Override
    protected void scrollDown() {
        if (((APCControlSurface)this.surface).getModeManager().isActive(new Modes[]{Modes.BROWSER})) {
            this.model.getBrowser().selectNextResult();
            return;
        }
        super.scrollDown();
    }

    @Override
    protected void scrollLeft() {
        if (((APCControlSurface)this.surface).isShiftPressed()) {
            this.model.getMarkerBank().selectPreviousItem();
            return;
        }
        IMode activeMode = (IMode)((APCControlSurface)this.surface).getModeManager().getActive();
        if (activeMode != null) {
            activeMode.selectPreviousItemPage();
        }
    }

    @Override
    protected void scrollRight() {
        if (((APCControlSurface)this.surface).isShiftPressed()) {
            this.model.getMarkerBank().selectNextItem();
            return;
        }
        IMode activeMode = (IMode)((APCControlSurface)this.surface).getModeManager().getActive();
        if (activeMode != null) {
            activeMode.selectNextItemPage();
        }
    }
}

