/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc;

import de.mossgrabers.controller.akai.apc.APCConfiguration;
import de.mossgrabers.controller.akai.apc.command.continuous.APCPlayPositionCommand;
import de.mossgrabers.controller.akai.apc.command.continuous.APCTempoCommand;
import de.mossgrabers.controller.akai.apc.command.trigger.APCBrowserCommand;
import de.mossgrabers.controller.akai.apc.command.trigger.APCCursorCommand;
import de.mossgrabers.controller.akai.apc.command.trigger.APCDeviceOnOffCommand;
import de.mossgrabers.controller.akai.apc.command.trigger.APCQuantizeCommand;
import de.mossgrabers.controller.akai.apc.command.trigger.APCRecordCommand;
import de.mossgrabers.controller.akai.apc.command.trigger.APCStopClipCommand;
import de.mossgrabers.controller.akai.apc.command.trigger.APCTapTempoCommand;
import de.mossgrabers.controller.akai.apc.command.trigger.APCUserModeCommand;
import de.mossgrabers.controller.akai.apc.command.trigger.SelectTrackSendOrClipLengthCommand;
import de.mossgrabers.controller.akai.apc.command.trigger.SendModeCommand;
import de.mossgrabers.controller.akai.apc.command.trigger.SessionRecordCommand;
import de.mossgrabers.controller.akai.apc.controller.APCColorManager;
import de.mossgrabers.controller.akai.apc.controller.APCControlSurface;
import de.mossgrabers.controller.akai.apc.controller.APCScales;
import de.mossgrabers.controller.akai.apc.mode.BrowserMode;
import de.mossgrabers.controller.akai.apc.mode.NoteMode;
import de.mossgrabers.controller.akai.apc.mode.PanMode;
import de.mossgrabers.controller.akai.apc.mode.SendMode;
import de.mossgrabers.controller.akai.apc.mode.UserMode;
import de.mossgrabers.controller.akai.apc.view.DrumView;
import de.mossgrabers.controller.akai.apc.view.PlayView;
import de.mossgrabers.controller.akai.apc.view.RaindropsView;
import de.mossgrabers.controller.akai.apc.view.SequencerView;
import de.mossgrabers.controller.akai.apc.view.SessionView;
import de.mossgrabers.controller.akai.apc.view.ShiftView;
import de.mossgrabers.framework.command.continuous.KnobRowModeCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.command.trigger.FootswitchCommand;
import de.mossgrabers.framework.command.trigger.application.PaneCommand;
import de.mossgrabers.framework.command.trigger.application.PanelLayoutCommand;
import de.mossgrabers.framework.command.trigger.application.RedoCommand;
import de.mossgrabers.framework.command.trigger.application.UndoCommand;
import de.mossgrabers.framework.command.trigger.clip.StopAllClipsCommand;
import de.mossgrabers.framework.command.trigger.device.DeviceLayerLeftCommand;
import de.mossgrabers.framework.command.trigger.device.DeviceLayerRightCommand;
import de.mossgrabers.framework.command.trigger.device.SelectNextDeviceOrParamPageCommand;
import de.mossgrabers.framework.command.trigger.device.SelectPreviousDeviceOrParamPageCommand;
import de.mossgrabers.framework.command.trigger.mode.ModeMultiSelectCommand;
import de.mossgrabers.framework.command.trigger.mode.ModeSelectCommand;
import de.mossgrabers.framework.command.trigger.track.CrossfadeModeCommand;
import de.mossgrabers.framework.command.trigger.track.MasterCommand;
import de.mossgrabers.framework.command.trigger.track.MuteCommand;
import de.mossgrabers.framework.command.trigger.track.RecArmCommand;
import de.mossgrabers.framework.command.trigger.track.SoloCommand;
import de.mossgrabers.framework.command.trigger.transport.MetronomeCommand;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.command.trigger.transport.StopCommand;
import de.mossgrabers.framework.command.trigger.view.FeatureGroupButtonColorSupplier;
import de.mossgrabers.framework.command.trigger.view.ToggleShiftViewCommand;
import de.mossgrabers.framework.command.trigger.view.ViewButtonCommand;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwAbsoluteKnob;
import de.mossgrabers.framework.controller.valuechanger.TwosComplementValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.mode.device.ParameterMode;
import de.mossgrabers.framework.mode.track.TrackVolumeMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.Timeout;
import de.mossgrabers.framework.view.TempoView;
import de.mossgrabers.framework.view.Views;
import java.util.Optional;
import java.util.function.IntSupplier;

public class APCControllerSetup
extends AbstractControllerSetup<APCControlSurface, APCConfiguration> {
    private final boolean isMkII;
    private APCTapTempoCommand tapTempoCommand;

    public APCControllerSetup(IHost host, ISetupFactory factory, ISettingsUI globalSettings, ISettingsUI documentSettings, boolean isMkII) {
        super(factory, host, globalSettings, documentSettings);
        this.isMkII = isMkII;
        this.colorManager = new APCColorManager(isMkII);
        this.valueChanger = new TwosComplementValueChanger(128, 1);
        this.configuration = new APCConfiguration(host, this.valueChanger, factory.getArpeggiatorModes(), isMkII);
    }

    @Override
    protected void createScales() {
        this.scales = new APCScales(this.valueChanger);
        this.scales.setDrumDefaultOffset(12);
    }

    @Override
    protected void createModel() {
        ModelSetup ms = new ModelSetup();
        ms.setNumScenes(5);
        ms.setNumDrumPadLayers(12);
        ms.setNumMarkers(8);
        this.model = this.factory.createModel(this.configuration, this.colorManager, this.valueChanger, this.scales, ms);
        ITrackBank trackBank = this.model.getTrackBank();
        trackBank.setIndication(true);
        trackBank.addSelectionObserver((index, isSelected) -> this.handleTrackChange(isSelected));
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput();
        IMidiInput input = midiAccess.createInput("Pads", "80????", "90????");
        APCControlSurface surface = new APCControlSurface(this.host, this.colorManager, (APCConfiguration)this.configuration, output, input, this.isMkII);
        this.surfaces.add(surface);
    }

    @Override
    protected void createObservers() {
        super.createObservers();
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        this.createScaleObservers((APCConfiguration)this.configuration);
        this.createNoteRepeatObservers((APCConfiguration)this.configuration, surface);
        ((APCConfiguration)this.configuration).registerDeactivatedItemsHandler(this.model);
        this.activateBrowserObserver(Modes.BROWSER);
    }

    @Override
    protected void createModes() {
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        modeManager.register(Modes.PAN, new PanMode(surface, this.model));
        for (int i = 0; i < 8; ++i) {
            modeManager.register(Modes.get(Modes.SEND1, i), new SendMode(surface, this.model, i));
        }
        modeManager.register(Modes.NOTE, new NoteMode(surface, this.model));
        modeManager.register(Modes.USER, new UserMode(surface, this.model));
        modeManager.register(Modes.BROWSER, new BrowserMode(surface, this.model));
    }

    @Override
    protected void createViews() {
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.register(Views.PLAY, new PlayView(surface, this.model));
        viewManager.register(Views.SESSION, new SessionView(surface, this.model));
        viewManager.register(Views.SEQUENCER, new SequencerView(surface, this.model));
        viewManager.register(Views.DRUM, new DrumView(surface, this.model));
        viewManager.register(Views.RAINDROPS, new RaindropsView(surface, this.model));
        viewManager.register(Views.SHIFT, new ShiftView(surface, this.model));
        viewManager.register(Views.TEMPO, new TempoView(surface, this.model, this.isMkII ? 46 : 1, this.isMkII ? 3 : 5, 0));
    }

    @Override
    protected void registerTriggerCommands() {
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        ModeManager modeManager = surface.getModeManager();
        ITransport t = this.model.getTransport();
        this.addButton(ButtonID.SHIFT, "SHIFT", new ToggleShiftViewCommand(this.model, surface), 98);
        this.addButton(ButtonID.PLAY, "PLAY", new PlayCommand(this.model, surface), 91, t::isPlaying, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
        this.addButton(ButtonID.RECORD, "RECORD", (TriggerCommand)new APCRecordCommand(this.model, surface), 93, t::isRecording, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
        this.tapTempoCommand = new APCTapTempoCommand(this.model, surface);
        this.addButton(ButtonID.TAP_TEMPO, "TEMPO", this.tapTempoCommand, 99);
        this.addButton(ButtonID.QUANTIZE, this.isMkII ? "DEV.LOCK" : "REC QUANTIZATION", (TriggerCommand)new APCQuantizeCommand(this.model, surface), 63, () -> surface.isPressed(ButtonID.QUANTIZE) ? 1 : 0, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
        this.addButton(ButtonID.MASTERTRACK, "MASTER", new MasterCommand(this.model, surface), 80, this.model.getMasterTrack()::isSelected, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
        this.addButton(ButtonID.STOP_ALL_CLIPS, "STOP CLIPS", new StopAllClipsCommand(this.model, surface), 81, () -> surface.isPressed(ButtonID.STOP_ALL_CLIPS) ? 1 : 0, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
        this.addButton(ButtonID.PAN_SEND, "PAN", new ModeSelectCommand(this.model, surface, Modes.PAN), 87, () -> modeManager.isActive(new Modes[]{Modes.PAN}), "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
        if (this.isMkII) {
            this.addButton(ButtonID.SEND1, "SENDS", new ModeMultiSelectCommand(this.model, surface, Modes.SEND1, Modes.SEND2, Modes.SEND3, Modes.SEND4, Modes.SEND5, Modes.SEND6, Modes.SEND7, Modes.SEND8), 88, () -> Modes.isSendMode((Modes)((Object)((Object)modeManager.getActiveID()))), "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
            this.addButton(ButtonID.SEND2, "USER", (TriggerCommand)new APCUserModeCommand(this.model, surface), 89, () -> modeManager.isActive(new Modes[]{Modes.USER}), "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
        } else {
            this.addButton(ButtonID.SEND1, "SEND A", (TriggerCommand)new SendModeCommand(0, this.model, surface), 88, () -> modeManager.isActive(new Modes[]{Modes.SEND1, Modes.SEND4, Modes.SEND7}), "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
            this.addButton(ButtonID.SEND2, "SEND B", (TriggerCommand)new SendModeCommand(1, this.model, surface), 89, () -> modeManager.isActive(new Modes[]{Modes.SEND2, Modes.SEND5, Modes.SEND8}), "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
            this.addButton(ButtonID.SEND3, "SEND C", (TriggerCommand)new SendModeCommand(2, this.model, surface), 90, () -> modeManager.isActive(new Modes[]{Modes.SEND3, Modes.SEND6}), "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
        }
        for (int i = 0; i < 8; ++i) {
            int index = i;
            final CrossfadeModeCommand crossfadeModeCommand = new CrossfadeModeCommand(i, this.model, surface);
            this.addButton(ButtonID.get(ButtonID.ROW1_1, i), "Select " + (i + 1), (TriggerCommand)new SelectTrackSendOrClipLengthCommand(i, this.model, surface), i, 51, () -> this.getButtonState(index, 51) ? 1 : 0, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
            this.addButton(ButtonID.get(ButtonID.ROW2_1, i), "Solo " + (i + 1), new SoloCommand(i, this.model, surface), i, 49, () -> this.getButtonState(index, 49) ? 1 : 0, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
            this.addButton(ButtonID.get(ButtonID.ROW3_1, i), (this.isMkII ? "Mute " : "Activator ") + (i + 1), new MuteCommand(i, this.model, surface), i, 50, () -> this.getButtonState(index, 50) ? 1 : 0, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
            this.addButton(ButtonID.get(ButtonID.ROW4_1, i), "Arm " + (i + 1), (TriggerCommand)new RecArmCommand<APCControlSurface, APCConfiguration>(this, i, this.model, surface){
                final /* synthetic */ APCControllerSetup this$0;
                {
                    this.this$0 = this$0;
                    super(index, model, surface);
                }

                @Override
                public void executeShifted(ButtonEvent event) {
                    if (!this.this$0.isMkII) {
                        crossfadeModeCommand.executeNormal(event);
                    }
                }
            }, i, 48, () -> this.getButtonState(index, 48) ? 1 : 0, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
            if (this.isMkII) {
                this.addButton(ButtonID.get(ButtonID.ROW5_1, i), "X-fade " + (i + 1), crossfadeModeCommand, i, 66, () -> this.getCrossfadeButtonColor(index), "BUTTON_STATE_OFF", "BUTTON_STATE_ON", "BUTTON_STATE_BLINK");
            }
            ButtonID stopButtonID = ButtonID.get(ButtonID.ROW6_1, i);
            APCStopClipCommand apcStopClipCommand = new APCStopClipCommand(i, this.model, surface);
            this.addButton(stopButtonID, "Stop " + (i + 1), (TriggerCommand)apcStopClipCommand, i, 52, () -> apcStopClipCommand.getButtonColor(stopButtonID), "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
        }
        if (this.isMkII) {
            DeviceLayerLeftCommand deviceLayerLeftCommand = new DeviceLayerLeftCommand(this.model, surface);
            this.addButton(ButtonID.DEVICE_LEFT, "<- DEVICE", deviceLayerLeftCommand, 58, () -> deviceLayerLeftCommand.canExecute() ? 1 : 0, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
            DeviceLayerRightCommand deviceLayerRightCommand = new DeviceLayerRightCommand(this.model, surface);
            this.addButton(ButtonID.DEVICE_RIGHT, "DEVICE ->", deviceLayerRightCommand, 59, () -> deviceLayerRightCommand.canExecute() ? 1 : 0, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
            this.addButton(ButtonID.BROWSE, "BANK", (TriggerCommand)new APCBrowserCommand(this.model, surface), 103, this.model.getBrowser()::isActive, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
        } else {
            this.addButton(ButtonID.STOP, "STOP", new StopCommand(this.model, surface), 92, () -> !t.isPlaying(), "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
        }
        this.addButton(ButtonID.CLIP, this.isMkII ? "SESSION" : "MIDI OVERDUB", (TriggerCommand)new SessionRecordCommand(this.model, surface), this.isMkII ? 102 : 64, t::isLauncherOverdub, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
        this.addButton(ButtonID.METRONOME, "METRONOME", new MetronomeCommand(this.model, surface, false), this.isMkII ? 90 : 65, t::isMetronomeOn, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
        this.addButton(ButtonID.NUDGE_PLUS, "NUDGE+", new RedoCommand(this.model, surface), this.isMkII ? 101 : 100);
        this.addButton(ButtonID.NUDGE_MINUS, "NUDGE-", new UndoCommand(this.model, surface), this.isMkII ? 100 : 101);
        this.addButton(ButtonID.DEVICE_ON_OFF, "DEV. ON/OFF", (TriggerCommand)new APCDeviceOnOffCommand(this.model, surface), this.isMkII ? 62 : 59, this.model.getCursorDevice()::isEnabled, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
        this.addButton(ButtonID.TOGGLE_DEVICES_PANE, this.isMkII ? "CLIP/DEV.VIEW" : "CLIP/TRACK", new PaneCommand(PaneCommand.Panels.DEVICE, this.model, surface), this.isMkII ? 64 : 58, () -> surface.isPressed(ButtonID.TOGGLE_DEVICES_PANE) ? 1 : 0, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
        this.addButton(ButtonID.LAYOUT, "DETAIL VIEW", new PanelLayoutCommand(this.model, surface), this.isMkII ? 65 : 62, () -> !surface.isShiftPressed() && this.model.getCursorDevice().isWindowOpen() ? 1 : 0, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
        SelectPreviousDeviceOrParamPageCommand selectPreviousDeviceOrParamPageCommand = new SelectPreviousDeviceOrParamPageCommand(this.model, surface);
        this.addButton(ButtonID.BANK_LEFT, "<- BANK", selectPreviousDeviceOrParamPageCommand, 60, () -> selectPreviousDeviceOrParamPageCommand.canExecute() ? 1 : 0, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
        SelectNextDeviceOrParamPageCommand selectNextDeviceOrParamPageCommand = new SelectNextDeviceOrParamPageCommand(this.model, surface);
        this.addButton(ButtonID.BANK_RIGHT, "BANK ->", selectNextDeviceOrParamPageCommand, 61, () -> selectNextDeviceOrParamPageCommand.canExecute() ? 1 : 0, "BUTTON_STATE_OFF", "BUTTON_STATE_ON");
        this.addButton(ButtonID.ARROW_DOWN, "Arrow Down", new APCCursorCommand(Direction.DOWN, this.model, surface), 95);
        this.addButton(ButtonID.ARROW_UP, "Arrow Up", new APCCursorCommand(Direction.UP, this.model, surface), 94);
        this.addButton(ButtonID.ARROW_LEFT, "Arrow Left", new APCCursorCommand(Direction.LEFT, this.model, surface), 97);
        this.addButton(ButtonID.ARROW_RIGHT, "Arrow Right", new APCCursorCommand(Direction.RIGHT, this.model, surface), 96);
        for (int i = 0; i < 5; ++i) {
            ButtonID sceneButtonID = ButtonID.get(ButtonID.SCENE1, i);
            this.addButton(sceneButtonID, "Scene " + (i + 1), new ViewButtonCommand(sceneButtonID, surface), 82 + i, new FeatureGroupButtonColorSupplier(viewManager, sceneButtonID));
        }
        this.addButton(ButtonID.FOOTSWITCH1, "Foot Controller 1", new FootswitchCommand(this.model, surface, 0), 64);
        if (!this.isMkII) {
            this.addButton(ButtonID.FOOTSWITCH2, "Foot Controller 2", new FootswitchCommand(this.model, surface, 1), 67);
        }
    }

    @Override
    protected void registerContinuousCommands() {
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        this.addFader(ContinuousID.FADER_MASTER, "Master", null, BindType.CC, 14).bind(this.model.getMasterTrack().getVolumeParameter());
        this.addFader(ContinuousID.CROSSFADER, "Crossfader", null, BindType.CC, 15, false).bind(this.model.getTransport().getCrossfadeParameter());
        Timeout timeout = this.tapTempoCommand.getTimeout();
        this.addRelativeKnob(ContinuousID.PLAY_POSITION, "Play Position", new APCPlayPositionCommand(this.model, surface, timeout), 47);
        for (int i = 0; i < 8; ++i) {
            this.addFader(ContinuousID.get(ContinuousID.FADER1, i), "Fader" + (i + 1), null, BindType.CC, i, 7).setIndexInGroup(i);
            IHwAbsoluteKnob channelKnob = this.addAbsoluteKnob(ContinuousID.get(ContinuousID.KNOB1, i), "Knob " + (i + 1), new KnobRowModeCommand(i, this.model, surface), 48 + i);
            IHwAbsoluteKnob deviceKnob = this.addAbsoluteKnob(ContinuousID.get(ContinuousID.DEVICE_KNOB1, i), "Device Knob " + (i + 1), null, 16 + i);
            channelKnob.setIndexInGroup(i);
            deviceKnob.setIndexInGroup(i);
            channelKnob.disableTakeOver();
            deviceKnob.disableTakeOver();
        }
        new TrackVolumeMode(surface, this.model, true, ContinuousID.createSequentialList(ContinuousID.FADER1, 8)).onActivate();
        new ParameterMode(surface, this.model, true, ContinuousID.createSequentialList(ContinuousID.DEVICE_KNOB1, 8)).onActivate();
        if (this.isMkII) {
            this.addRelativeKnob(ContinuousID.TEMPO, "Tempo", new APCTempoCommand(this.model, surface, timeout), 13);
        }
    }

    @Override
    protected void layoutControls() {
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        if (this.isMkII) {
            surface.getButton(ButtonID.NUDGE_MINUS).setBounds(624.0, 132.0, 33.25, 15.25);
            surface.getButton(ButtonID.NUDGE_PLUS).setBounds(686.0, 132.0, 33.25, 15.25);
            surface.getButton(ButtonID.METRONOME).setBounds(624.0, 96.0, 33.25, 15.25);
            surface.getButton(ButtonID.CLIP).setBounds(747.75, 59.25, 32.5, 20.0);
            surface.getButton(ButtonID.LAYOUT).setBounds(747.75, 319.75, 33.25, 15.25);
            surface.getButton(ButtonID.TOGGLE_DEVICES_PANE).setBounds(686.0, 319.75, 33.25, 15.25);
            surface.getButton(ButtonID.DEVICE_ON_OFF).setBounds(562.25, 319.75, 33.25, 15.25);
            surface.getButton(ButtonID.PAD1).setBounds(13.0, 194.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD2).setBounds(74.25, 194.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD3).setBounds(135.25, 194.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD4).setBounds(196.5, 194.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD5).setBounds(257.75, 194.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD6).setBounds(318.75, 194.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD7).setBounds(380.0, 194.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD8).setBounds(441.0, 194.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD9).setBounds(12.0, 165.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD10).setBounds(73.25, 165.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD11).setBounds(134.5, 165.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD12).setBounds(196.0, 165.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD13).setBounds(257.25, 165.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD14).setBounds(318.5, 165.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD15).setBounds(379.75, 165.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD16).setBounds(441.0, 165.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD17).setBounds(11.75, 135.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD18).setBounds(73.25, 135.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD19).setBounds(135.0, 135.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD20).setBounds(196.5, 135.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD21).setBounds(258.0, 135.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD22).setBounds(319.5, 135.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD23).setBounds(381.25, 135.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD24).setBounds(441.0, 137.5, 52.25, 18.5);
            surface.getButton(ButtonID.PAD25).setBounds(12.5, 108.75, 52.25, 18.5);
            surface.getButton(ButtonID.PAD26).setBounds(73.75, 108.75, 52.25, 18.5);
            surface.getButton(ButtonID.PAD27).setBounds(135.25, 108.75, 52.25, 18.5);
            surface.getButton(ButtonID.PAD28).setBounds(196.5, 108.75, 52.25, 18.5);
            surface.getButton(ButtonID.PAD29).setBounds(257.75, 108.75, 52.25, 18.5);
            surface.getButton(ButtonID.PAD30).setBounds(319.25, 108.75, 52.25, 18.5);
            surface.getButton(ButtonID.PAD31).setBounds(380.5, 108.75, 52.25, 18.5);
            surface.getButton(ButtonID.PAD32).setBounds(441.0, 108.75, 52.25, 18.5);
            surface.getButton(ButtonID.PAD33).setBounds(12.75, 78.0, 52.25, 18.5);
            surface.getButton(ButtonID.PAD34).setBounds(74.25, 78.0, 52.25, 18.5);
            surface.getButton(ButtonID.PAD35).setBounds(135.5, 78.0, 52.25, 18.5);
            surface.getButton(ButtonID.PAD36).setBounds(196.75, 78.0, 52.25, 18.5);
            surface.getButton(ButtonID.PAD37).setBounds(256.5, 78.0, 52.25, 18.5);
            surface.getButton(ButtonID.PAD38).setBounds(318.0, 78.0, 52.25, 18.5);
            surface.getButton(ButtonID.PAD39).setBounds(379.5, 78.0, 52.25, 18.5);
            surface.getButton(ButtonID.PAD40).setBounds(441.0, 78.0, 52.25, 18.5);
            surface.getButton(ButtonID.SHIFT).setBounds(686.0, 360.5, 33.25, 15.25);
            surface.getButton(ButtonID.PLAY).setBounds(624.0, 59.25, 32.5, 20.0);
            surface.getButton(ButtonID.RECORD).setBounds(686.0, 59.25, 32.5, 20.0);
            surface.getButton(ButtonID.TAP_TEMPO).setBounds(686.0, 96.0, 33.25, 15.25);
            surface.getButton(ButtonID.QUANTIZE).setBounds(624.0, 319.75, 33.25, 15.25);
            surface.getButton(ButtonID.PAN_SEND).setBounds(562.25, 64.0, 33.25, 15.25);
            surface.getButton(ButtonID.SEND1).setBounds(562.25, 96.0, 33.25, 15.25);
            surface.getButton(ButtonID.SEND2).setBounds(562.25, 132.0, 33.25, 15.25);
            surface.getButton(ButtonID.ARROW_UP).setBounds(581.25, 361.75, 33.25, 25.0);
            surface.getButton(ButtonID.ARROW_DOWN).setBounds(581.5, 386.25, 33.25, 25.0);
            surface.getButton(ButtonID.ARROW_LEFT).setBounds(562.5, 361.75, 17.0, 49.25);
            surface.getButton(ButtonID.ARROW_RIGHT).setBounds(616.0, 361.75, 17.0, 49.25);
            surface.getButton(ButtonID.SCENE1).setBounds(500.75, 78.0, 36.0, 18.5);
            surface.getButton(ButtonID.SCENE2).setBounds(500.75, 108.75, 36.0, 18.5);
            surface.getButton(ButtonID.SCENE3).setBounds(500.75, 137.5, 36.0, 18.5);
            surface.getButton(ButtonID.SCENE4).setBounds(500.75, 165.5, 36.0, 18.5);
            surface.getButton(ButtonID.SCENE5).setBounds(500.75, 194.5, 36.0, 18.5);
            surface.getButton(ButtonID.FOOTSWITCH1).setBounds(670.0, 1.25, 37.5, 21.0);
            surface.getButton(ButtonID.STOP_ALL_CLIPS).setBounds(502.25, 227.25, 33.25, 18.75);
            surface.getButton(ButtonID.MASTERTRACK).setBounds(500.75, 263.0, 36.0, 15.75);
            surface.getButton(ButtonID.ROW1_1).setBounds(12.5, 262.5, 50.5, 15.75);
            surface.getButton(ButtonID.ROW1_2).setBounds(74.0, 262.5, 50.5, 15.75);
            surface.getButton(ButtonID.ROW1_3).setBounds(135.25, 262.5, 50.5, 15.75);
            surface.getButton(ButtonID.ROW1_4).setBounds(196.75, 262.5, 50.5, 15.75);
            surface.getButton(ButtonID.ROW1_5).setBounds(258.25, 262.5, 50.5, 15.75);
            surface.getButton(ButtonID.ROW1_6).setBounds(319.5, 262.5, 50.5, 15.75);
            surface.getButton(ButtonID.ROW1_7).setBounds(381.0, 262.5, 50.5, 15.75);
            surface.getButton(ButtonID.ROW1_8).setBounds(442.5, 262.5, 50.5, 15.75);
            surface.getButton(ButtonID.ROW2_1).setBounds(14.0, 317.75, 19.5, 18.0);
            surface.getButton(ButtonID.ROW2_2).setBounds(75.25, 317.75, 19.5, 18.0);
            surface.getButton(ButtonID.ROW2_3).setBounds(136.5, 317.75, 19.5, 18.0);
            surface.getButton(ButtonID.ROW2_4).setBounds(197.5, 317.75, 19.5, 18.0);
            surface.getButton(ButtonID.ROW2_5).setBounds(258.75, 317.75, 19.5, 18.0);
            surface.getButton(ButtonID.ROW2_6).setBounds(320.0, 317.75, 19.5, 18.0);
            surface.getButton(ButtonID.ROW2_7).setBounds(381.25, 317.75, 19.5, 18.0);
            surface.getButton(ButtonID.ROW2_8).setBounds(442.5, 317.75, 19.5, 18.0);
            surface.getButton(ButtonID.ROW3_1).setBounds(14.25, 291.5, 19.5, 18.0);
            surface.getButton(ButtonID.ROW3_2).setBounds(75.5, 291.5, 19.5, 18.0);
            surface.getButton(ButtonID.ROW3_3).setBounds(136.5, 291.5, 19.5, 18.0);
            surface.getButton(ButtonID.ROW3_4).setBounds(197.75, 291.5, 19.5, 18.0);
            surface.getButton(ButtonID.ROW3_5).setBounds(259.0, 291.5, 19.5, 18.0);
            surface.getButton(ButtonID.ROW3_6).setBounds(320.0, 291.5, 19.5, 18.0);
            surface.getButton(ButtonID.ROW3_7).setBounds(381.25, 291.5, 19.5, 18.0);
            surface.getButton(ButtonID.ROW3_8).setBounds(442.5, 291.5, 19.5, 18.0);
            surface.getButton(ButtonID.ROW4_1).setBounds(44.5, 317.75, 19.5, 18.0);
            surface.getButton(ButtonID.ROW4_2).setBounds(105.75, 317.75, 19.5, 18.0);
            surface.getButton(ButtonID.ROW4_3).setBounds(167.0, 317.75, 19.5, 18.0);
            surface.getButton(ButtonID.ROW4_4).setBounds(228.25, 317.75, 19.5, 18.0);
            surface.getButton(ButtonID.ROW4_5).setBounds(289.5, 317.75, 19.5, 18.0);
            surface.getButton(ButtonID.ROW4_6).setBounds(350.75, 317.75, 19.5, 18.0);
            surface.getButton(ButtonID.ROW4_7).setBounds(411.75, 317.75, 19.5, 18.0);
            surface.getButton(ButtonID.ROW4_8).setBounds(473.0, 317.75, 19.5, 18.0);
            surface.getButton(ButtonID.ROW5_1).setBounds(44.75, 291.5, 19.5, 18.0);
            surface.getButton(ButtonID.ROW5_2).setBounds(106.0, 291.5, 19.5, 18.0);
            surface.getButton(ButtonID.ROW5_3).setBounds(167.25, 291.5, 19.5, 18.0);
            surface.getButton(ButtonID.ROW5_4).setBounds(228.25, 291.5, 19.5, 18.0);
            surface.getButton(ButtonID.ROW5_5).setBounds(289.5, 291.5, 19.5, 18.0);
            surface.getButton(ButtonID.ROW5_6).setBounds(350.75, 291.5, 19.5, 18.0);
            surface.getButton(ButtonID.ROW5_7).setBounds(411.75, 291.5, 19.5, 18.0);
            surface.getButton(ButtonID.ROW5_8).setBounds(473.0, 291.5, 19.5, 18.0);
            surface.getButton(ButtonID.ROW6_1).setBounds(21.25, 227.25, 31.5, 18.75);
            surface.getButton(ButtonID.ROW6_2).setBounds(82.75, 227.25, 31.5, 18.75);
            surface.getButton(ButtonID.ROW6_3).setBounds(144.25, 227.25, 31.5, 18.75);
            surface.getButton(ButtonID.ROW6_4).setBounds(205.75, 227.25, 31.5, 18.75);
            surface.getButton(ButtonID.ROW6_5).setBounds(267.0, 227.25, 31.5, 18.75);
            surface.getButton(ButtonID.ROW6_6).setBounds(328.5, 227.25, 31.5, 18.75);
            surface.getButton(ButtonID.ROW6_7).setBounds(390.0, 227.25, 31.5, 18.75);
            surface.getButton(ButtonID.ROW6_8).setBounds(451.5, 227.25, 31.5, 18.75);
            surface.getButton(ButtonID.BANK_LEFT).setBounds(686.0, 289.75, 33.25, 15.25);
            surface.getButton(ButtonID.BANK_RIGHT).setBounds(747.75, 289.75, 33.25, 15.25);
            surface.getButton(ButtonID.DEVICE_LEFT).setBounds(562.25, 289.75, 33.25, 15.25);
            surface.getButton(ButtonID.DEVICE_RIGHT).setBounds(624.0, 289.75, 33.25, 15.25);
            surface.getButton(ButtonID.BROWSE).setBounds(747.75, 359.75, 33.25, 15.25);
            surface.getContinuous(ContinuousID.FADER_MASTER).setBounds(500.25, 348.5, 40.5, 115.0);
            surface.getContinuous(ContinuousID.PLAY_POSITION).setBounds(497.75, 293.75, 40.25, 37.75);
            surface.getContinuous(ContinuousID.CROSSFADER).setBounds(651.25, 419.5, 104.0, 50.0);
            surface.getContinuous(ContinuousID.FADER1).setBounds(19.75, 348.5, 40.5, 115.0);
            surface.getContinuous(ContinuousID.KNOB1).setBounds(16.75, 19.0, 40.25, 37.75);
            surface.getContinuous(ContinuousID.DEVICE_KNOB1).setBounds(560.25, 173.75, 40.25, 37.75);
            surface.getContinuous(ContinuousID.FADER2).setBounds(80.75, 348.5, 40.5, 115.0);
            surface.getContinuous(ContinuousID.KNOB2).setBounds(78.5, 19.0, 40.25, 37.75);
            surface.getContinuous(ContinuousID.DEVICE_KNOB2).setBounds(620.75, 173.75, 40.25, 37.75);
            surface.getContinuous(ContinuousID.FADER3).setBounds(141.5, 348.5, 40.5, 115.0);
            surface.getContinuous(ContinuousID.KNOB3).setBounds(140.25, 19.0, 40.25, 37.75);
            surface.getContinuous(ContinuousID.DEVICE_KNOB3).setBounds(682.5, 173.75, 40.25, 37.75);
            surface.getContinuous(ContinuousID.FADER4).setBounds(202.5, 348.5, 40.5, 115.0);
            surface.getContinuous(ContinuousID.KNOB4).setBounds(202.0, 19.0, 40.25, 37.75);
            surface.getContinuous(ContinuousID.DEVICE_KNOB4).setBounds(744.25, 173.75, 40.25, 37.75);
            surface.getContinuous(ContinuousID.FADER5).setBounds(263.5, 348.5, 40.5, 115.0);
            surface.getContinuous(ContinuousID.KNOB5).setBounds(263.5, 19.0, 40.25, 37.75);
            surface.getContinuous(ContinuousID.DEVICE_KNOB5).setBounds(560.25, 235.75, 40.25, 37.75);
            surface.getContinuous(ContinuousID.FADER6).setBounds(324.25, 348.5, 40.5, 115.0);
            surface.getContinuous(ContinuousID.KNOB6).setBounds(325.25, 19.0, 40.25, 37.75);
            surface.getContinuous(ContinuousID.DEVICE_KNOB6).setBounds(620.75, 235.75, 40.25, 37.75);
            surface.getContinuous(ContinuousID.FADER7).setBounds(385.25, 348.5, 40.5, 115.0);
            surface.getContinuous(ContinuousID.KNOB7).setBounds(387.0, 19.0, 40.25, 37.75);
            surface.getContinuous(ContinuousID.DEVICE_KNOB7).setBounds(682.5, 235.75, 40.25, 37.75);
            surface.getContinuous(ContinuousID.FADER8).setBounds(446.25, 348.5, 40.5, 115.0);
            surface.getContinuous(ContinuousID.KNOB8).setBounds(448.75, 19.0, 40.25, 37.75);
            surface.getContinuous(ContinuousID.DEVICE_KNOB8).setBounds(744.25, 235.75, 40.25, 37.75);
            surface.getContinuous(ContinuousID.TEMPO).setBounds(743.25, 106.75, 40.25, 37.75);
        } else {
            surface.getButton(ButtonID.PAD1).setBounds(33.5, 228.0, 33.0, 32.0);
            surface.getButton(ButtonID.PAD2).setBounds(83.75, 228.0, 33.0, 32.0);
            surface.getButton(ButtonID.PAD3).setBounds(132.75, 228.0, 33.0, 32.0);
            surface.getButton(ButtonID.PAD4).setBounds(180.25, 228.0, 33.0, 32.0);
            surface.getButton(ButtonID.PAD5).setBounds(229.0, 228.0, 33.0, 32.0);
            surface.getButton(ButtonID.PAD6).setBounds(278.25, 228.0, 33.0, 32.0);
            surface.getButton(ButtonID.PAD7).setBounds(327.25, 228.0, 33.0, 32.0);
            surface.getButton(ButtonID.PAD8).setBounds(376.25, 228.0, 33.0, 32.0);
            surface.getButton(ButtonID.PAD9).setBounds(33.5, 184.75, 33.0, 32.0);
            surface.getButton(ButtonID.PAD10).setBounds(83.75, 184.75, 33.0, 32.0);
            surface.getButton(ButtonID.PAD11).setBounds(132.75, 184.75, 33.0, 32.0);
            surface.getButton(ButtonID.PAD12).setBounds(180.25, 184.75, 33.0, 32.0);
            surface.getButton(ButtonID.PAD13).setBounds(229.0, 184.75, 33.0, 32.0);
            surface.getButton(ButtonID.PAD14).setBounds(278.25, 184.75, 33.0, 32.0);
            surface.getButton(ButtonID.PAD15).setBounds(327.25, 184.75, 33.0, 32.0);
            surface.getButton(ButtonID.PAD16).setBounds(376.25, 184.75, 33.0, 32.0);
            surface.getButton(ButtonID.PAD17).setBounds(33.5, 138.5, 33.0, 32.0);
            surface.getButton(ButtonID.PAD18).setBounds(83.75, 138.5, 33.0, 32.0);
            surface.getButton(ButtonID.PAD19).setBounds(132.75, 138.5, 33.0, 32.0);
            surface.getButton(ButtonID.PAD20).setBounds(180.25, 138.5, 33.0, 32.0);
            surface.getButton(ButtonID.PAD21).setBounds(229.0, 138.5, 33.0, 32.0);
            surface.getButton(ButtonID.PAD22).setBounds(278.25, 138.5, 33.0, 32.0);
            surface.getButton(ButtonID.PAD23).setBounds(327.25, 138.5, 33.0, 32.0);
            surface.getButton(ButtonID.PAD24).setBounds(376.25, 138.5, 33.0, 32.0);
            surface.getButton(ButtonID.PAD25).setBounds(33.5, 94.25, 33.0, 32.0);
            surface.getButton(ButtonID.PAD26).setBounds(83.75, 94.25, 33.0, 32.0);
            surface.getButton(ButtonID.PAD27).setBounds(132.75, 94.25, 33.0, 32.0);
            surface.getButton(ButtonID.PAD28).setBounds(180.25, 94.25, 33.0, 32.0);
            surface.getButton(ButtonID.PAD29).setBounds(229.0, 94.25, 33.0, 32.0);
            surface.getButton(ButtonID.PAD30).setBounds(278.25, 94.25, 33.0, 32.0);
            surface.getButton(ButtonID.PAD31).setBounds(327.25, 94.25, 33.0, 32.0);
            surface.getButton(ButtonID.PAD32).setBounds(376.25, 94.25, 33.0, 32.0);
            surface.getButton(ButtonID.PAD33).setBounds(33.5, 51.0, 33.0, 32.0);
            surface.getButton(ButtonID.PAD34).setBounds(83.75, 51.0, 33.0, 32.0);
            surface.getButton(ButtonID.PAD35).setBounds(132.75, 51.0, 33.0, 32.0);
            surface.getButton(ButtonID.PAD36).setBounds(180.25, 51.0, 33.0, 32.0);
            surface.getButton(ButtonID.PAD37).setBounds(229.0, 51.0, 33.0, 32.0);
            surface.getButton(ButtonID.PAD38).setBounds(278.25, 51.0, 33.0, 32.0);
            surface.getButton(ButtonID.PAD39).setBounds(327.25, 51.0, 33.0, 32.0);
            surface.getButton(ButtonID.PAD40).setBounds(376.25, 51.0, 33.0, 32.0);
            surface.getButton(ButtonID.ROW1_1).setBounds(33.5, 338.5, 33.0, 32.0);
            surface.getButton(ButtonID.ROW2_1).setBounds(33.5, 421.5, 34.0, 18.0);
            surface.getButton(ButtonID.ROW3_1).setBounds(33.5, 393.25, 34.0, 18.0);
            surface.getButton(ButtonID.ROW4_1).setBounds(33.5, 449.25, 34.0, 18.0);
            surface.getButton(ButtonID.ROW6_1).setBounds(33.5, 279.75, 33.0, 32.0);
            surface.getButton(ButtonID.ROW1_2).setBounds(83.75, 338.5, 33.0, 32.0);
            surface.getButton(ButtonID.ROW2_2).setBounds(83.75, 421.5, 34.0, 18.0);
            surface.getButton(ButtonID.ROW3_2).setBounds(83.75, 393.25, 34.0, 18.0);
            surface.getButton(ButtonID.ROW4_2).setBounds(83.75, 449.25, 34.0, 18.0);
            surface.getButton(ButtonID.ROW6_2).setBounds(83.75, 279.75, 33.0, 32.0);
            surface.getButton(ButtonID.ROW1_3).setBounds(132.75, 338.5, 33.0, 32.0);
            surface.getButton(ButtonID.ROW2_3).setBounds(132.75, 421.5, 34.0, 18.0);
            surface.getButton(ButtonID.ROW3_3).setBounds(132.75, 393.25, 34.0, 18.0);
            surface.getButton(ButtonID.ROW4_3).setBounds(132.75, 449.25, 34.0, 18.0);
            surface.getButton(ButtonID.ROW6_3).setBounds(132.75, 279.75, 33.0, 32.0);
            surface.getButton(ButtonID.ROW1_4).setBounds(180.25, 338.5, 33.0, 32.0);
            surface.getButton(ButtonID.ROW2_4).setBounds(180.25, 421.5, 34.0, 18.0);
            surface.getButton(ButtonID.ROW3_4).setBounds(180.25, 393.25, 34.0, 18.0);
            surface.getButton(ButtonID.ROW4_4).setBounds(180.25, 449.25, 34.0, 18.0);
            surface.getButton(ButtonID.ROW6_4).setBounds(180.25, 279.75, 33.0, 32.0);
            surface.getButton(ButtonID.ROW1_5).setBounds(229.0, 338.5, 33.0, 32.0);
            surface.getButton(ButtonID.ROW2_5).setBounds(229.0, 421.5, 34.0, 18.0);
            surface.getButton(ButtonID.ROW3_5).setBounds(229.0, 393.25, 34.0, 18.0);
            surface.getButton(ButtonID.ROW4_5).setBounds(229.0, 449.25, 34.0, 18.0);
            surface.getButton(ButtonID.ROW6_5).setBounds(229.0, 279.75, 33.0, 32.0);
            surface.getButton(ButtonID.ROW1_6).setBounds(278.25, 338.5, 33.0, 32.0);
            surface.getButton(ButtonID.ROW2_6).setBounds(278.25, 421.5, 34.0, 18.0);
            surface.getButton(ButtonID.ROW3_6).setBounds(278.25, 393.25, 34.0, 18.0);
            surface.getButton(ButtonID.ROW4_6).setBounds(278.25, 449.25, 34.0, 18.0);
            surface.getButton(ButtonID.ROW6_6).setBounds(278.25, 279.75, 33.0, 32.0);
            surface.getButton(ButtonID.ROW1_7).setBounds(327.25, 338.5, 33.0, 32.0);
            surface.getButton(ButtonID.ROW2_7).setBounds(327.25, 421.5, 34.0, 18.0);
            surface.getButton(ButtonID.ROW3_7).setBounds(327.25, 393.25, 34.0, 18.0);
            surface.getButton(ButtonID.ROW4_7).setBounds(327.25, 449.25, 34.0, 18.0);
            surface.getButton(ButtonID.ROW6_7).setBounds(327.25, 279.75, 33.0, 32.0);
            surface.getButton(ButtonID.ROW1_8).setBounds(376.25, 338.5, 33.0, 32.0);
            surface.getButton(ButtonID.ROW2_8).setBounds(376.25, 421.5, 34.0, 18.0);
            surface.getButton(ButtonID.ROW3_8).setBounds(376.25, 393.25, 34.0, 18.0);
            surface.getButton(ButtonID.ROW4_8).setBounds(376.25, 449.25, 34.0, 18.0);
            surface.getButton(ButtonID.ROW6_8).setBounds(376.25, 279.75, 33.0, 32.0);
            surface.getButton(ButtonID.CLIP).setBounds(651.75, 489.25, 33.25, 15.25);
            surface.getButton(ButtonID.METRONOME).setBounds(723.5, 489.25, 33.25, 15.25);
            surface.getButton(ButtonID.NUDGE_MINUS).setBounds(660.0, 270.75, 33.25, 15.0);
            surface.getButton(ButtonID.NUDGE_PLUS).setBounds(716.0, 270.75, 33.25, 15.0);
            surface.getButton(ButtonID.DEVICE_ON_OFF).setBounds(579.75, 448.75, 33.25, 15.25);
            surface.getButton(ButtonID.TOGGLE_DEVICES_PANE).setBounds(508.25, 448.75, 33.25, 15.25);
            surface.getButton(ButtonID.LAYOUT).setBounds(508.25, 489.25, 33.25, 15.25);
            surface.getButton(ButtonID.BANK_LEFT).setBounds(651.75, 448.75, 33.25, 15.25);
            surface.getButton(ButtonID.BANK_RIGHT).setBounds(723.5, 448.75, 33.25, 15.25);
            surface.getButton(ButtonID.ARROW_DOWN).setBounds(582.0, 233.5, 33.25, 25.0);
            surface.getButton(ButtonID.ARROW_UP).setBounds(582.25, 256.75, 33.25, 25.0);
            surface.getButton(ButtonID.ARROW_LEFT).setBounds(565.0, 233.5, 15.75, 48.25);
            surface.getButton(ButtonID.ARROW_RIGHT).setBounds(616.75, 233.5, 15.75, 48.25);
            surface.getButton(ButtonID.SCENE1).setBounds(428.25, 51.0, 33.0, 32.0);
            surface.getButton(ButtonID.SCENE2).setBounds(428.25, 94.25, 33.0, 32.0);
            surface.getButton(ButtonID.SCENE3).setBounds(428.25, 138.5, 33.0, 32.0);
            surface.getButton(ButtonID.SCENE4).setBounds(428.25, 184.75, 33.0, 32.0);
            surface.getButton(ButtonID.SCENE5).setBounds(428.25, 228.0, 33.0, 32.0);
            surface.getButton(ButtonID.FOOTSWITCH1).setBounds(670.0, 1.25, 37.5, 21.0);
            surface.getButton(ButtonID.FOOTSWITCH2).setBounds(715.5, 1.25, 37.5, 21.0);
            surface.getButton(ButtonID.SHIFT).setBounds(508.25, 270.75, 33.25, 15.0);
            surface.getButton(ButtonID.PLAY).setBounds(551.0, 536.75, 32.5, 20.0);
            surface.getButton(ButtonID.STOP).setBounds(611.0, 537.5, 32.5, 20.0);
            surface.getButton(ButtonID.RECORD).setBounds(671.0, 536.75, 32.5, 20.0);
            surface.getButton(ButtonID.TAP_TEMPO).setBounds(687.5, 229.75, 33.25, 20.5);
            surface.getButton(ButtonID.QUANTIZE).setBounds(579.75, 489.25, 33.25, 15.25);
            surface.getButton(ButtonID.MASTERTRACK).setBounds(428.25, 338.5, 33.0, 32.0);
            surface.getButton(ButtonID.STOP_ALL_CLIPS).setBounds(428.25, 279.75, 33.0, 32.0);
            surface.getButton(ButtonID.PAN_SEND).setBounds(508.25, 183.25, 33.25, 15.25);
            surface.getButton(ButtonID.SEND1).setBounds(579.75, 183.25, 33.25, 15.25);
            surface.getButton(ButtonID.SEND2).setBounds(651.75, 183.25, 33.25, 15.25);
            surface.getButton(ButtonID.SEND3).setBounds(723.5, 183.25, 33.25, 15.25);
            surface.getContinuous(ContinuousID.FADER_MASTER).setBounds(428.25, 497.25, 38.25, 124.0);
            surface.getContinuous(ContinuousID.PLAY_POSITION).setBounds(428.25, 412.0, 40.25, 37.75);
            surface.getContinuous(ContinuousID.CROSSFADER).setBounds(564.5, 572.75, 135.25, 50.0);
            surface.getContinuous(ContinuousID.FADER1).setBounds(33.5, 497.25, 38.25, 124.0);
            surface.getContinuous(ContinuousID.KNOB1).setBounds(508.25, 44.5, 40.25, 37.75);
            surface.getContinuous(ContinuousID.DEVICE_KNOB1).setBounds(508.25, 315.0, 40.25, 37.75);
            surface.getContinuous(ContinuousID.FADER2).setBounds(83.75, 497.25, 38.25, 124.0);
            surface.getContinuous(ContinuousID.KNOB2).setBounds(579.75, 44.5, 40.25, 37.75);
            surface.getContinuous(ContinuousID.DEVICE_KNOB2).setBounds(579.75, 315.0, 40.25, 37.75);
            surface.getContinuous(ContinuousID.FADER3).setBounds(132.75, 497.25, 38.25, 124.0);
            surface.getContinuous(ContinuousID.KNOB3).setBounds(651.75, 44.5, 40.25, 37.75);
            surface.getContinuous(ContinuousID.DEVICE_KNOB3).setBounds(651.75, 315.0, 40.25, 37.75);
            surface.getContinuous(ContinuousID.FADER4).setBounds(180.25, 497.25, 38.25, 124.0);
            surface.getContinuous(ContinuousID.KNOB4).setBounds(723.5, 44.5, 40.25, 37.75);
            surface.getContinuous(ContinuousID.DEVICE_KNOB4).setBounds(723.5, 315.0, 40.25, 37.75);
            surface.getContinuous(ContinuousID.FADER5).setBounds(229.0, 497.25, 38.25, 124.0);
            surface.getContinuous(ContinuousID.KNOB5).setBounds(508.25, 120.0, 40.25, 37.75);
            surface.getContinuous(ContinuousID.DEVICE_KNOB5).setBounds(508.25, 389.5, 40.25, 37.75);
            surface.getContinuous(ContinuousID.FADER6).setBounds(278.25, 497.25, 38.25, 124.0);
            surface.getContinuous(ContinuousID.KNOB6).setBounds(579.75, 120.0, 40.25, 37.75);
            surface.getContinuous(ContinuousID.DEVICE_KNOB6).setBounds(579.75, 389.5, 40.25, 37.75);
            surface.getContinuous(ContinuousID.FADER7).setBounds(327.25, 497.25, 38.25, 124.0);
            surface.getContinuous(ContinuousID.KNOB7).setBounds(651.75, 120.0, 40.25, 37.75);
            surface.getContinuous(ContinuousID.DEVICE_KNOB7).setBounds(651.75, 389.5, 40.25, 37.75);
            surface.getContinuous(ContinuousID.FADER8).setBounds(376.25, 497.25, 38.25, 124.0);
            surface.getContinuous(ContinuousID.KNOB8).setBounds(723.5, 120.0, 40.25, 37.75);
            surface.getContinuous(ContinuousID.DEVICE_KNOB8).setBounds(723.5, 389.5, 40.25, 37.75);
        }
    }

    @Override
    public void startup() {
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        surface.getModeManager().setActive(Modes.PAN);
        surface.getViewManager().setActive(((APCConfiguration)this.configuration).shouldStartWithSessionView() ? Views.SESSION : ((APCConfiguration)this.configuration).getStartupView());
    }

    private int getCrossfadeButtonColor(int index) {
        ITrack track = (ITrack)this.model.getCurrentTrackBank().getItem(index);
        if (!track.doesExist()) {
            return 0;
        }
        String crossfadeMode = track.getCrossfadeParameter().getDisplayedValue();
        if ("AB".equals(crossfadeMode)) {
            return 0;
        }
        return "A".equals(crossfadeMode) ? 1 : 2;
    }

    private static boolean getMuteButtonState(boolean isShift, ITrack track) {
        return isShift ? track.isMonitor() : !track.isMute();
    }

    private static boolean getSoloButtonState(boolean isShift, ITrack track) {
        return isShift ? track.isAutoMonitor() : track.isSolo();
    }

    @Override
    public void flush() {
        super.flush();
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        IView view = (IView)surface.getViewManager().getActive();
        if (view == null) {
            return;
        }
        IParameterBank parameterBank = this.model.getCursorDevice().getParameterBank();
        for (int i = 0; i < 8; ++i) {
            IParameter item = (IParameter)parameterBank.getItem(i);
            surface.setLED(24 + i, item.doesExist() ? 1 : 2);
            surface.setLED(16 + i, item.doesExist() ? item.getValue() : 0);
        }
    }

    @Override
    protected BindType getTriggerBindType(ButtonID buttonID) {
        if (buttonID == ButtonID.FOOTSWITCH1 || buttonID == ButtonID.FOOTSWITCH2) {
            return BindType.CC;
        }
        return BindType.NOTE;
    }

    private boolean getButtonState(int index, int button) {
        APCControlSurface surface = (APCControlSurface)this.getSurface();
        int clipLength = ((APCConfiguration)surface.getConfiguration()).getNewClipLength();
        ModeManager modeManager = surface.getModeManager();
        ITrackBank tb = this.model.getCurrentTrackBank();
        ITrack track = (ITrack)tb.getItem(index);
        boolean trackExists = track.doesExist();
        boolean isShift = surface.isShiftPressed();
        switch (button) {
            case 51: {
                int selIndex;
                if (isShift) {
                    return index == clipLength;
                }
                Optional selTrack = tb.getSelectedItem();
                int n = selIndex = selTrack.isEmpty() ? -1 : ((ITrack)selTrack.get()).getIndex();
                if (surface.isMkII() && surface.isPressed(ButtonID.SEND2)) {
                    return ((UserMode)modeManager.get(Modes.USER)).isPageSelected(index);
                }
                return surface.isPressed(ButtonID.SEND1) ? modeManager.isActive(new Modes[]{Modes.get(Modes.SEND1, index)}) : index == selIndex;
            }
            case 49: {
                return trackExists && APCControllerSetup.getSoloButtonState(isShift, track);
            }
            case 50: {
                return trackExists && APCControllerSetup.getMuteButtonState(isShift, track);
            }
            case 48: {
                if (isShift) {
                    return this.getCrossfadeButtonColor(index) > 0;
                }
                return trackExists && track.isRecArm();
            }
        }
        return false;
    }

    @Override
    protected void addButton(APCControlSurface surface, ButtonID buttonID, String label, TriggerCommand command, int midiInputChannel, int midiOutputChannel, int midiControl, int value, boolean hasLight, IntSupplier supplier, String ... colorIds) {
        TriggerCommand shiftModeCloserCommand = buttonID == ButtonID.SHIFT ? command : (event, velocity) -> {
            ViewManager viewManager;
            if (surface.isShiftPressed() && event == ButtonEvent.DOWN && (viewManager = surface.getViewManager()).getActiveID() == Views.SHIFT) {
                viewManager.restore();
            }
            command.execute(event, velocity);
        };
        super.addButton(surface, buttonID, label, shiftModeCloserCommand, midiInputChannel, midiOutputChannel, midiControl, value, hasLight, supplier, colorIds);
    }
}

