/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.view;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.view.sequencer.AbstractDrumXoXView;

public class DrumXoXView
extends AbstractDrumXoXView<PushControlSurface, PushConfiguration> {
    public DrumXoXView(PushControlSurface surface, IModel model) {
        super("Drum XoX", surface, model, 8);
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.isActive()) {
            return;
        }
        int index = note - ((PushControlSurface)this.surface).getPadGrid().getStartNote();
        int x = index % this.numColumns;
        int y = index / this.numColumns;
        if (y < this.numStepRows) {
            ((PushControlSurface)this.surface).getButton(ButtonID.get(ButtonID.PAD1, index)).setConsumed();
            int offsetY = this.scales.getDrumOffset();
            NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), (this.numStepRows - 1 - y) * this.numColumns + x, offsetY + this.selectedPad);
            this.editNote(this.getClip(), notePosition, false);
        }
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int velocity) {
        boolean isSelectPressed = ((PushControlSurface)this.surface).isSelectPressed();
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, !isSelectPressed);
            }
            return true;
        }
        if (isSelectPressed) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
            if (velocity > 0) {
                this.editNote(clip, notePosition, true);
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, velocity);
    }
}

