/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.track;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.controller.ableton.push.mode.track.AddMode;
import de.mossgrabers.framework.command.trigger.BrowserCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IDeviceMetadata;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class AddTrackMode
extends BaseMode<IItem> {
    private static final AddMode[] TOP_MENU = new AddMode[]{AddMode.INSTRUMENT, AddMode.AUDIO, AddMode.EFFECT, null, AddMode.DEVICE, null, null, null};
    private static final String[] SUB_MENU = new String[]{"Add Track", "", "", "", "Add Device", "", "", ""};
    private final Map<ColorEx, Integer> buttonColorsHiFirst = new HashMap<ColorEx, Integer>();
    private final Map<ColorEx, Integer> buttonColorsLoFirst = new HashMap<ColorEx, Integer>();
    private final Map<ColorEx, Integer> buttonColorsHiSecond = new HashMap<ColorEx, Integer>();
    private final Map<ColorEx, Integer> buttonColorsLoSecond = new HashMap<ColorEx, Integer>();
    private AddMode addMode = AddMode.INSTRUMENT;
    private final BrowserCommand<PushControlSurface, PushConfiguration> browserCommand;

    public AddTrackMode(PushControlSurface surface, IModel model) {
        super("Add Track", surface, model);
        this.browserCommand = new BrowserCommand(model, surface);
        this.buttonColorsHiFirst.put(ColorEx.YELLOW, this.isPushModern ? 13 : 16);
        this.buttonColorsHiFirst.put(ColorEx.GREEN, this.isPushModern ? 21 : 22);
        this.buttonColorsHiFirst.put(ColorEx.BLUE, this.isPushModern ? 45 : 4);
        this.buttonColorsHiFirst.put(ColorEx.ORANGE, this.isPushModern ? 9 : 10);
        this.buttonColorsHiFirst.put(ColorEx.DARK_ORANGE, this.isPushModern ? 9 : 10);
        this.buttonColorsLoFirst.put(ColorEx.YELLOW, this.isPushModern ? 15 : 13);
        this.buttonColorsLoFirst.put(ColorEx.GREEN, this.isPushModern ? 23 : 19);
        this.buttonColorsLoFirst.put(ColorEx.BLUE, this.isPushModern ? 47 : 1);
        this.buttonColorsLoFirst.put(ColorEx.ORANGE, this.isPushModern ? 11 : 7);
        this.buttonColorsLoFirst.put(ColorEx.DARK_ORANGE, this.isPushModern ? 11 : 7);
        this.buttonColorsHiSecond.put(ColorEx.YELLOW, this.isPushModern ? 13 : 13);
        this.buttonColorsHiSecond.put(ColorEx.GREEN, this.isPushModern ? 21 : 21);
        this.buttonColorsHiSecond.put(ColorEx.BLUE, this.isPushModern ? 45 : 5);
        this.buttonColorsHiSecond.put(ColorEx.ORANGE, this.isPushModern ? 9 : 9);
        this.buttonColorsHiSecond.put(ColorEx.DARK_ORANGE, this.isPushModern ? 9 : 9);
        this.buttonColorsLoSecond.put(ColorEx.YELLOW, this.isPushModern ? 15 : 15);
        this.buttonColorsLoSecond.put(ColorEx.GREEN, this.isPushModern ? 23 : 23);
        this.buttonColorsLoSecond.put(ColorEx.BLUE, this.isPushModern ? 47 : 7);
        this.buttonColorsLoSecond.put(ColorEx.ORANGE, this.isPushModern ? 11 : 11);
        this.buttonColorsLoSecond.put(ColorEx.DARK_ORANGE, this.isPushModern ? 11 : 11);
    }

    public void setAddMode(AddMode addMode) {
        this.addMode = addMode;
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        Optional<Object> favorite;
        if (event != ButtonEvent.UP) {
            return;
        }
        ((PushControlSurface)this.surface).getModeManager().restore();
        ChannelType channelType = this.addMode.getChannelType();
        if (index == 0) {
            if (this.addMode == AddMode.DEVICE) {
                this.browserCommand.startBrowser(true, false);
                return;
            }
            favorite = Optional.empty();
        } else {
            PushConfiguration conf = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
            switch (this.addMode) {
                case INSTRUMENT: {
                    favorite = conf.getInstrumentFavorite(index - 1);
                    break;
                }
                case AUDIO: {
                    favorite = conf.getAudioFavorite(index - 1);
                    break;
                }
                case EFFECT: {
                    favorite = conf.getEffectFavorite(index - 1);
                    break;
                }
                case DEVICE: {
                    favorite = conf.getDeviceFavorite(index - 1);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        String channelName = null;
        IDeviceMetadata deviceMetadata = null;
        if (favorite.isPresent()) {
            deviceMetadata = (IDeviceMetadata)favorite.get();
            channelName = deviceMetadata.name();
        }
        if (channelType == ChannelType.UNKNOWN) {
            if (deviceMetadata != null) {
                this.model.getCursorTrack().addDevice(deviceMetadata);
            }
        } else {
            this.model.getTrackBank().addChannel(channelType, channelName, deviceMetadata == null ? Collections.emptyList() : Collections.singletonList(deviceMetadata));
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event == ButtonEvent.UP && TOP_MENU[index] != null) {
            this.addMode = TOP_MENU[index];
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            ColorEx color = this.addMode.getColor();
            return index == 0 ? this.buttonColorsHiFirst.get(color).intValue() : this.buttonColorsLoFirst.get(color).intValue();
        }
        index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            if (TOP_MENU[index] == null) {
                return this.colorManager.getColorIndex("BUTTON_COLOR_OFF");
            }
            ColorEx color = TOP_MENU[index].getColor();
            return TOP_MENU[index] == this.addMode ? this.buttonColorsHiSecond.get(color).intValue() : this.buttonColorsLoSecond.get(color).intValue();
        }
        return this.colorManager.getColorIndex("BUTTON_COLOR_OFF");
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        display.setBlock(1, 0, SUB_MENU[0]);
        display.setBlock(1, 2, SUB_MENU[4]);
        for (int i = 0; i < 8; ++i) {
            Optional<IDeviceMetadata> favorite;
            String lowerMenu = i == 0 ? (this.addMode == AddMode.DEVICE ? "Browse" : "Empty") : ((favorite = this.getFavorite(i - 1)).isEmpty() ? "" : StringUtils.limit(favorite.get().name(), 13));
            display.setCell(0, i, TOP_MENU[i] == null ? "" : TOP_MENU[i].getLabel());
            display.setCell(2, i, i == 0 ? this.addMode.getLabel() : "");
            display.setCell(3, i, lowerMenu);
        }
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        for (int i = 0; i < 8; ++i) {
            String lowerMenu;
            String lowerLabel = "";
            ColorEx lowerMenuColor = null;
            if (i == 0) {
                lowerMenu = this.addMode == AddMode.DEVICE ? "Browse" : "Empty";
                lowerLabel = this.addMode.getLabel();
                lowerMenuColor = this.addMode.getColor();
            } else {
                Optional<IDeviceMetadata> favorite = this.getFavorite(i - 1);
                lowerMenu = favorite.isEmpty() ? "" : StringUtils.limit(favorite.get().name(), 13);
            }
            String topLabel = TOP_MENU[i] == null ? "" : TOP_MENU[i].getLabel();
            ColorEx topColor = TOP_MENU[i] == null ? null : TOP_MENU[i].getColor();
            display.addOptionElement(SUB_MENU[i], topLabel, false, topColor, lowerLabel, lowerMenu, false, lowerMenuColor, false, false);
        }
    }

    private Optional<IDeviceMetadata> getFavorite(int index) {
        PushConfiguration conf = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        switch (this.addMode) {
            case INSTRUMENT: {
                return conf.getInstrumentFavorite(index);
            }
            case AUDIO: {
                return conf.getAudioFavorite(index);
            }
            case EFFECT: {
                return conf.getEffectFavorite(index);
            }
            case DEVICE: {
                return conf.getDeviceFavorite(index);
            }
        }
        return Optional.empty();
    }
}

