/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.trigger;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class PushAutomationCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    private boolean quitAutomationMode;

    public PushAutomationCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            if (event == ButtonEvent.DOWN) {
                this.model.getTransport().resetAutomationOverrides();
            }
            return;
        }
        switch (event) {
            case DOWN: {
                this.quitAutomationMode = false;
                break;
            }
            case LONG: {
                this.quitAutomationMode = true;
                ((PushControlSurface)this.surface).getModeManager().setTemporary(Modes.AUTOMATION);
                break;
            }
            case UP: {
                if (this.quitAutomationMode) {
                    ((PushControlSurface)this.surface).getModeManager().restore();
                    break;
                }
                this.doCommand();
            }
        }
    }

    private void doCommand() {
        boolean isShift = ((PushControlSurface)this.surface).isShiftPressed();
        boolean flipRecord = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isFlipRecord();
        if (isShift && !flipRecord || !isShift && flipRecord) {
            this.model.getTransport().toggleWriteClipLauncherAutomation();
        } else {
            this.model.getTransport().toggleWriteArrangerAutomation();
        }
    }
}

