/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.OSCMessageInfo;
import com.illposed.osc.OSCPacket;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class OSCMessage
implements OSCPacket {
    private static final long serialVersionUID = 1L;
    private static final Pattern ILLEGAL_ADDRESS_CHAR = Pattern.compile("[ #*,?\\[\\]{}]");
    private final String address;
    private final List<Object> arguments;
    private OSCMessageInfo info;

    public OSCMessage(String address) {
        this(address, Collections.emptyList());
    }

    public OSCMessage(String address, List<?> arguments) {
        this(address, arguments, null);
    }

    public OSCMessage(String address, List<?> arguments, OSCMessageInfo info) {
        this(address, arguments, info, true);
    }

    OSCMessage(String address, List<?> arguments, OSCMessageInfo info, boolean checkAddress) {
        if (checkAddress) {
            OSCMessage.checkAddress(address);
        }
        this.address = address;
        this.arguments = Collections.unmodifiableList(arguments);
        this.info = info;
    }

    public String getAddress() {
        return this.address;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public OSCMessageInfo getInfo() {
        return this.info;
    }

    public boolean isInfoSet() {
        return this.info != null;
    }

    public void setInfo(OSCMessageInfo info) {
        if (this.info != null) {
            throw new IllegalStateException("The meta-info of a message may only be set once");
        }
        this.info = info;
    }

    private static void checkAddress(String address) {
        if (!OSCMessage.isValidAddress(address)) {
            throw new IllegalArgumentException("Not a valid OSC address: " + address);
        }
    }

    public static boolean isValidAddress(String address) {
        return address != null && !address.isEmpty() && (address.equals("#reply") || address.charAt(0) == '/' && !address.contains("//") && !ILLEGAL_ADDRESS_CHAR.matcher(address).find());
    }
}

