/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.communication;

import de.mossgrabers.framework.controller.IControllerSetup;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.GrooveParameterID;
import de.mossgrabers.framework.daw.IGroove;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.AutomationMode;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.IMarker;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.bank.IDeviceBank;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.reaper.framework.daw.ApplicationImpl;
import de.mossgrabers.reaper.framework.daw.ArrangerImpl;
import de.mossgrabers.reaper.framework.daw.BrowserImpl;
import de.mossgrabers.reaper.framework.daw.ModelImpl;
import de.mossgrabers.reaper.framework.daw.Note;
import de.mossgrabers.reaper.framework.daw.ProjectImpl;
import de.mossgrabers.reaper.framework.daw.TransportImpl;
import de.mossgrabers.reaper.framework.daw.data.CursorDeviceImpl;
import de.mossgrabers.reaper.framework.daw.data.DeviceImpl;
import de.mossgrabers.reaper.framework.daw.data.EqualizerDeviceImpl;
import de.mossgrabers.reaper.framework.daw.data.MarkerImpl;
import de.mossgrabers.reaper.framework.daw.data.MasterTrackImpl;
import de.mossgrabers.reaper.framework.daw.data.SceneImpl;
import de.mossgrabers.reaper.framework.daw.data.SendImpl;
import de.mossgrabers.reaper.framework.daw.data.SpecificDeviceImpl;
import de.mossgrabers.reaper.framework.daw.data.TrackImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.MarkerBankImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.ParameterBankImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.SceneBankImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.SendBankImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.TrackBankImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.GrooveParameter;
import de.mossgrabers.reaper.framework.daw.data.parameter.IParameterEx;
import de.mossgrabers.reaper.framework.daw.data.parameter.MetronomeVolumeParameterImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.ParameterImpl;
import de.mossgrabers.reaper.framework.midi.NoteRepeatImpl;
import java.util.Collections;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;

public class MessageParser {
    private static final String TAG_ACTIVE = "active";
    private static final String TAG_PARAM = "param";
    private static final String TAG_COLOR = "color";
    private static final String TAG_SELECT = "select";
    private static final String TAG_NUMBER = "number";
    private static final String TAG_COUNT = "count";
    private static final String TAG_EXISTS = "exists";
    private static final String TAG_NAME = "name";
    private static final String TAG_VOLUME = "volume";
    private final IControllerSetup<?, ?> controllerSetup;
    private final IHost host;
    private final ProjectImpl project;
    private final ApplicationImpl application;
    private final ArrangerImpl arranger;
    private final MasterTrackImpl masterTrack;
    private final TransportImpl transport;
    private final CursorDeviceImpl cursorDevice;
    private final CursorDeviceImpl instrumentDevice;
    private final EqualizerDeviceImpl eqDevice;
    private final BrowserImpl browser;
    private final IModel model;

    public MessageParser(IControllerSetup<?, ?> controllerSetup) {
        this.controllerSetup = controllerSetup;
        this.model = controllerSetup.getModel();
        if (this.model == null) {
            this.host = null;
            this.project = null;
            this.application = null;
            this.arranger = null;
            this.transport = null;
            this.masterTrack = null;
            this.cursorDevice = null;
            this.instrumentDevice = null;
            this.eqDevice = null;
            this.browser = null;
        } else {
            this.host = this.model.getHost();
            this.project = (ProjectImpl)this.model.getProject();
            this.application = (ApplicationImpl)this.model.getApplication();
            this.arranger = (ArrangerImpl)this.model.getArranger();
            this.transport = (TransportImpl)this.model.getTransport();
            this.masterTrack = (MasterTrackImpl)this.model.getMasterTrack();
            this.cursorDevice = (CursorDeviceImpl)this.model.getCursorDevice();
            this.instrumentDevice = (CursorDeviceImpl)this.model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT);
            this.eqDevice = (EqualizerDeviceImpl)this.model.getSpecificDevice(DeviceID.EQ);
            this.browser = (BrowserImpl)this.model.getBrowser();
        }
    }

    public void parseOSC(String osc, String value) {
        if (this.model == null) {
            return;
        }
        Queue<String> parts = MessageParser.parsePath(osc);
        if (parts.isEmpty()) {
            return;
        }
        String command = parts.poll();
        if (this.parseTransport(command, parts, value)) {
            return;
        }
        block16 : switch (command) {
            case "project": {
                String projectCmd;
                switch (projectCmd = parts.poll()) {
                    case "name": {
                        this.project.setInternalName(value);
                        this.updateNoteMapping();
                        break block16;
                    }
                    case "engine": {
                        this.application.setInternalEngineActive(Integer.parseInt(value) > 0);
                        break block16;
                    }
                    case "canUndo": {
                        this.application.setCanUndoState(Integer.parseInt(value) > 0);
                        break block16;
                    }
                    case "canRedo": {
                        this.application.setCanRedoState(Integer.parseInt(value) > 0);
                        break block16;
                    }
                    case "isDirty": {
                        this.project.setDirty(Integer.parseInt(value) > 0);
                        break block16;
                    }
                }
                this.host.error("Unhandled Project parameter: " + projectCmd);
                break;
            }
            case "click": {
                this.parseClick(parts, value);
                break;
            }
            case "track": {
                this.parseTrack(parts, value);
                break;
            }
            case "master": {
                this.parseMasterTrackValue(this.masterTrack, parts, value);
                break;
            }
            case "device": {
                this.parseDevice(this.cursorDevice, value, parts);
                break;
            }
            case "primary": {
                if (this.instrumentDevice == null) break;
                this.parseDevice(this.instrumentDevice, value, parts);
                break;
            }
            case "eq": {
                if (this.eqDevice == null) break;
                this.parseDevice(this.eqDevice, value, parts);
                break;
            }
            case "clip": {
                this.parseClipValue(parts, value);
                break;
            }
            case "browser": {
                this.parseBrowserValue(parts, value);
                break;
            }
            case "marker": {
                this.parseMarker(parts, value);
                break;
            }
            case "scene": {
                this.parseScene(parts, value);
                break;
            }
            case "quantize": {
                if (!"strength".equals(parts.poll())) break;
                this.controllerSetup.getConfiguration().setQuantizeAmount(Integer.parseInt(value));
                break;
            }
            case "noterepeat": {
                this.parseNoteRepeat(parts, value);
                break;
            }
            case "groove": {
                this.parseGroove(parts, value);
                break;
            }
            default: {
                this.host.error("Unhandled OSC address: " + osc + " " + value);
                return;
            }
        }
    }

    private void parseClick(Queue<String> parts, String value) {
        String clickCommand;
        if (parts.isEmpty()) {
            this.transport.setMetronomeState(Double.parseDouble(value) > 0.0);
            return;
        }
        switch (clickCommand = parts.poll()) {
            case "preroll": {
                this.transport.setPrerollMetronomeInternal((Integer.parseInt(value) & 2) > 0);
                break;
            }
            case "prerollMeasures": {
                this.transport.setPrerollMeasuresInternal((int)Double.parseDouble(value));
                break;
            }
            case "volume": {
                this.transport.setInternalMetronomeVolume(Double.parseDouble(value));
                break;
            }
            case "volumeStr": {
                ((MetronomeVolumeParameterImpl)this.transport.getMetronomeVolumeParameter()).setMetronomeVolumeStr(value);
                break;
            }
            default: {
                this.host.error("Unhandled Click Parameter: " + clickCommand);
            }
        }
    }

    private boolean parseTransport(String command, Queue<String> parts, String value) {
        block13 : switch (command) {
            case "play": {
                this.transport.setPlayState(Double.parseDouble(value) > 0.0);
                break;
            }
            case "stop": {
                this.transport.setPlayState(Double.parseDouble(value) == 0.0);
                break;
            }
            case "repeat": {
                this.transport.setLoopingState(Double.parseDouble(value) > 0.0);
                break;
            }
            case "record": {
                this.transport.setRecordState(Double.parseDouble(value) > 0.0);
                break;
            }
            case "tempo": {
                this.transport.getTempoParameter().setInternalValue(Double.parseDouble(value));
                break;
            }
            case "time": {
                this.parseTime(parts, value);
                break;
            }
            case "beat": {
                this.transport.setBeats(value);
                break;
            }
            case "numerator": {
                int numerator = (int)Double.parseDouble(value);
                if (numerator <= 0) break;
                this.transport.setNumerator(numerator);
                break;
            }
            case "denominator": {
                int denominator = (int)Double.parseDouble(value);
                if (denominator <= 0) break;
                this.transport.setDenominator(denominator);
                break;
            }
            case "followPlayback": {
                this.arranger.setPlaybackFollow(Double.parseDouble(value) > 0.0);
                break;
            }
            case "automode": {
                switch ((int)Double.parseDouble(value)) {
                    case 0: {
                        this.transport.setAutomationWriteModeState(AutomationMode.TRIM_READ);
                        break block13;
                    }
                    case 1: {
                        this.transport.setAutomationWriteModeState(AutomationMode.READ);
                        break block13;
                    }
                    case 2: {
                        this.transport.setAutomationWriteModeState(AutomationMode.TOUCH);
                        break block13;
                    }
                    case 3: {
                        this.transport.setAutomationWriteModeState(AutomationMode.WRITE);
                        break block13;
                    }
                    case 4: {
                        this.transport.setAutomationWriteModeState(AutomationMode.LATCH);
                        break block13;
                    }
                    case 5: {
                        this.transport.setAutomationWriteModeState(AutomationMode.LATCH_PREVIEW);
                        break block13;
                    }
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected void parseTime(Queue<String> parts, String value) {
        String cmd;
        if (parts.isEmpty()) {
            this.transport.setPositionValue(Double.parseDouble(value));
            return;
        }
        block5 : switch (cmd = parts.poll()) {
            case "str": {
                this.transport.setPositionText(value);
                return;
            }
            case "hzoom": {
                this.transport.setHZoom(Double.parseDouble(value));
                return;
            }
            case "loop": {
                String loopCmd;
                if (!"loop".equals(cmd) || parts.isEmpty()) {
                    return;
                }
                switch (loopCmd = parts.poll()) {
                    case "start": {
                        if (parts.isEmpty()) {
                            this.transport.setLoopStartValue(Double.parseDouble(value));
                            return;
                        }
                        if ("str".equals(parts.poll())) {
                            this.transport.setLoopStartText(value);
                            break block5;
                        }
                        this.transport.setLoopStartBeatText(value);
                        break block5;
                    }
                    case "length": {
                        if (parts.isEmpty()) {
                            this.transport.setLoopLengthValue(Double.parseDouble(value));
                            break block5;
                        }
                        this.transport.setLoopLengthBeatText(value);
                        break block5;
                    }
                }
                this.host.error("Unhandled Loop parameter: " + loopCmd);
                return;
            }
            default: {
                this.host.error("Unhandled Time parameter: " + cmd);
            }
        }
    }

    private void parseTrack(Queue<String> parts, String value) {
        String part;
        TrackBankImpl tb = (TrackBankImpl)this.model.getTrackBank();
        switch (part = parts.poll()) {
            case "fx": {
                this.parseTrackFxParameter(value, parts);
                break;
            }
            case "count": {
                tb.setItemCount(Integer.parseInt(value));
                tb.markDirty();
                this.rebindKnobs();
                break;
            }
            default: {
                try {
                    int position = Integer.parseInt(part);
                    this.parseTrackValue(tb, (TrackImpl)tb.getUnpagedItem(position), parts, value);
                    break;
                }
                catch (NumberFormatException ex) {
                    this.host.error("Unhandled Track command: " + part);
                }
            }
        }
    }

    private void parseMasterTrackValue(MasterTrackImpl masterTrack, Queue<String> parts, String value) {
        String type = parts.peek();
        if ("fx".equals(type)) {
            parts.poll();
            String cmd = parts.poll();
            if (TAG_PARAM.equals(cmd)) {
                ParameterBankImpl parameterBank = (ParameterBankImpl)this.model.getProject().getParameterBank();
                if (parameterBank == null) {
                    return;
                }
                String paramCmd = parts.poll();
                try {
                    int paramNo = Integer.parseInt(paramCmd);
                    this.parseDeviceParamValue(paramNo, parameterBank, parts, value);
                    if (paramNo == 0) {
                        ParameterImpl crossfaderParam = masterTrack.getCrossfaderParameter();
                        IParameter param = parameterBank.getItem(paramNo);
                        if (crossfaderParam instanceof ParameterImpl) {
                            ParameterImpl destParam = crossfaderParam;
                            if (param instanceof ParameterImpl) {
                                ParameterImpl sourceParam = (ParameterImpl)param;
                                sourceParam.copyValues(destParam);
                            }
                        }
                    }
                }
                catch (NumberFormatException ex) {
                    if (TAG_COUNT.equals(paramCmd)) {
                        parameterBank.setItemCount(Integer.parseInt(value));
                        this.rebindKnobs();
                    }
                    this.host.error("Unhandled Track FX Param parameter: " + cmd);
                }
            }
            return;
        }
        this.parseTrackValue(null, masterTrack, parts, value);
    }

    private void parseTrackValue(TrackBankImpl tb, TrackImpl track, Queue<String> parts, String value) {
        String command;
        switch (command = parts.poll()) {
            case "exists": {
                track.setExists(Double.parseDouble(value) > 0.0);
                break;
            }
            case "depth": {
                track.setDepth(Integer.parseInt(value));
                ((TrackBankImpl)this.model.getTrackBank()).markDirty();
                break;
            }
            case "active": {
                track.setInternalIsActivated(Double.parseDouble(value) > 0.0);
                ((TrackBankImpl)this.model.getTrackBank()).markDirty();
                break;
            }
            case "type": {
                track.setType(ChannelType.valueOf(value));
                break;
            }
            case "isGroupExpanded": {
                track.setIsGroupExpanded(Integer.parseInt(value) > 0);
                break;
            }
            case "select": {
                boolean isSelected = Double.parseDouble(value) > 0.0;
                track.setSelected(isSelected);
                ((TrackBankImpl)this.model.getCurrentTrackBank()).handleBankTrackSelection(track, isSelected);
                if (!isSelected) break;
                this.updateNoteMapping();
                break;
            }
            case "number": {
                track.setPosition(Integer.parseInt(value));
                break;
            }
            case "name": {
                track.setInternalName(value);
                break;
            }
            case "volume": {
                if (parts.isEmpty()) {
                    track.setInternalVolume(Double.parseDouble(value));
                    break;
                }
                if (!"str".equals(parts.poll())) break;
                track.setVolumeStr(value);
                break;
            }
            case "pan": {
                if (parts.isEmpty()) {
                    track.setInternalPan(Double.parseDouble(value));
                    break;
                }
                if (!"str".equals(parts.poll())) break;
                track.setPanStr(value);
                break;
            }
            case "vu": {
                track.setVu(Double.parseDouble(value));
                break;
            }
            case "vuleft": {
                track.setVuLeft(Double.parseDouble(value));
                break;
            }
            case "vuright": {
                track.setVuRight(Double.parseDouble(value));
                break;
            }
            case "vuholdleft": {
                track.setVuHoldLeft(Double.parseDouble(value));
                break;
            }
            case "vuholdright": {
                track.setVuHoldRight(Double.parseDouble(value));
                break;
            }
            case "mute": {
                track.setMuteState(Double.parseDouble(value) > 0.0);
                break;
            }
            case "solo": {
                track.setSoloState(Double.parseDouble(value) > 0.0);
                break;
            }
            case "recarm": {
                track.setRecArmState(Double.parseDouble(value) > 0.0);
                break;
            }
            case "monitor": {
                track.setMonitorState(Double.parseDouble(value) > 0.0);
                break;
            }
            case "autoMonitor": {
                track.setAutoMonitorState(Double.parseDouble(value) > 0.0);
                break;
            }
            case "overdub": {
                track.setOverdub(Double.parseDouble(value) > 0.0);
                break;
            }
            case "color": {
                Optional<double[]> color = ((ModelImpl)this.model).parseColor(value);
                track.setColorState(color.isPresent() ? color.get() : ColorEx.GRAY.toDoubleRGB());
                break;
            }
            case "send": {
                this.parseSend(track, parts, value);
                break;
            }
            case "playingnotes": {
                if (tb == null) break;
                tb.handleNotes(track.getPosition(), Note.parseNotes(value));
                break;
            }
            case "inQuantLengthEnabled": {
                track.setRecordQuantizationNoteLengthState(Double.parseDouble(value) > 0.0);
                break;
            }
            case "inQuantResolution": {
                track.setRecordQuantizationGrid(Double.parseDouble(value));
                break;
            }
            default: {
                this.host.error("Unhandled Track Parameter: " + command);
            }
        }
    }

    private void parseSend(TrackImpl track, Queue<String> parts, String value) {
        if (parts.isEmpty()) {
            return;
        }
        String sendCmd = parts.poll();
        SendBankImpl sendBank = (SendBankImpl)track.getSendBank();
        try {
            int position = Integer.parseInt(sendCmd);
            this.parseSendValue((ISend)sendBank.getUnpagedItem(position), parts, value);
        }
        catch (NumberFormatException ex) {
            if (TAG_COUNT.equals(sendCmd)) {
                sendBank.setItemCount(Integer.parseInt(value));
                this.rebindKnobs();
            }
            this.host.error("Unhandled Send command: " + String.valueOf(sendBank));
        }
    }

    private void parseSendValue(ISend send, Queue<String> parts, String value) {
        String command = parts.poll();
        SendImpl sendImpl = (SendImpl)send;
        switch (command) {
            case "active": {
                sendImpl.setInternalEnabled(value != null && Integer.parseInt(value) > 0);
                break;
            }
            case "name": {
                sendImpl.setInternalName(value);
                sendImpl.setExists(value != null && !value.isEmpty());
                break;
            }
            case "volume": {
                if (parts.isEmpty()) {
                    sendImpl.setInternalValue(Double.parseDouble(value));
                    break;
                }
                if (!"str".equals(parts.poll())) break;
                sendImpl.setValueStr(value);
                break;
            }
            case "color": {
                Optional<double[]> color = ((ModelImpl)this.model).parseColor(value);
                sendImpl.setColorState(color.isPresent() ? color.get() : ColorEx.GRAY.toDoubleRGB());
                break;
            }
            default: {
                this.host.error("Unhandled Send command: " + command);
            }
        }
    }

    private void parseDevice(SpecificDeviceImpl device, String value, Queue<String> parts) {
        String command;
        switch (command = parts.poll()) {
            case "count": {
                if (!(device instanceof CursorDeviceImpl)) break;
                CursorDeviceImpl cdi = (CursorDeviceImpl)device;
                cdi.setDeviceCount(Integer.parseInt(value));
                break;
            }
            case "exists": {
                device.setExists(Integer.parseInt(value) > 0);
                break;
            }
            case "position": {
                device.setPosition(Integer.parseInt(value));
                break;
            }
            case "bypass": {
                device.setEnabled(Integer.parseInt(value) == 0);
                break;
            }
            case "name": {
                device.setName(value);
                break;
            }
            case "window": {
                device.setWindowOpen(Double.parseDouble(value) > 0.0);
                break;
            }
            case "expand": {
                device.setExpanded(Double.parseDouble(value) > 0.0);
                break;
            }
            case "sibling": {
                if (!(device instanceof CursorDeviceImpl)) break;
                CursorDeviceImpl cdi = (CursorDeviceImpl)device;
                this.parseSibling(cdi, parts, value);
                break;
            }
            case "param": {
                this.parseParameter(device, value, parts);
                break;
            }
            case "touchedParam": {
                device.setLastTouchedParameterIndex(Integer.parseInt(value));
                break;
            }
            case "band": {
                if (!(device instanceof EqualizerDeviceImpl)) break;
                EqualizerDeviceImpl edi = (EqualizerDeviceImpl)device;
                String bandIndex = parts.poll();
                try {
                    int position = Integer.parseInt(bandIndex);
                    edi.setTypeInternal(position, Integer.parseInt(value));
                }
                catch (NumberFormatException ex) {
                    this.host.error("Unhandled Equalizer command: " + bandIndex);
                }
                break;
            }
            default: {
                this.host.error("Unhandled Device parameter: " + command);
            }
        }
    }

    private void parseParameter(SpecificDeviceImpl device, String value, Queue<String> parts) {
        String cmd = parts.poll();
        try {
            int paramNo = Integer.parseInt(cmd);
            ParameterBankImpl parameterBank = (ParameterBankImpl)device.getParameterBank();
            if (parameterBank != null) {
                this.parseDeviceParamValue(paramNo, parameterBank, parts, value);
            }
        }
        catch (NumberFormatException ex) {
            if (TAG_COUNT.equals(cmd)) {
                device.setParameterCount(Integer.parseInt(value));
                this.rebindKnobs();
            }
            this.host.error("Unhandled Device Param parameter: " + cmd);
        }
    }

    private void parseTrackFxParameter(String value, Queue<String> parts) {
        String type = parts.poll();
        if (!type.equals(TAG_PARAM)) {
            this.host.error("Unhandled Track FX parameter: " + type);
            return;
        }
        Optional selectedTrack = this.model.getTrackBank().getSelectedItem();
        if (selectedTrack.isEmpty()) {
            return;
        }
        String cmd = parts.poll();
        ParameterBankImpl parameterBank = (ParameterBankImpl)((TrackImpl)selectedTrack.get()).getParameterBank();
        if (parameterBank == null) {
            return;
        }
        try {
            int paramNo = Integer.parseInt(cmd);
            this.parseDeviceParamValue(paramNo, parameterBank, parts, value);
        }
        catch (NumberFormatException ex) {
            if (TAG_COUNT.equals(cmd)) {
                parameterBank.setItemCount(Integer.parseInt(value));
                this.rebindKnobs();
            }
            this.host.error("Unhandled Track FX Param parameter: " + cmd);
        }
    }

    private void parseSibling(CursorDeviceImpl device, Queue<String> parts, String value) {
        String siblingCmd = parts.poll();
        try {
            int siblingNo = Integer.parseInt(siblingCmd) - 1;
            IDeviceBank deviceBank = device.getDeviceBank();
            if (siblingNo < deviceBank.getPageSize()) {
                String subCmd;
                DeviceImpl sibling = (DeviceImpl)deviceBank.getItem(siblingNo);
                switch (subCmd = parts.poll()) {
                    case "name": {
                        sibling.setName(value);
                        sibling.setExists(value != null && !value.isEmpty());
                        break;
                    }
                    case "bypass": {
                        sibling.setEnabled(Integer.parseInt(value) == 0);
                        break;
                    }
                    case "position": {
                        sibling.setPosition(Integer.parseInt(value));
                        break;
                    }
                    case "selected": {
                        sibling.setSelected(Integer.parseInt(value) > 0);
                        break;
                    }
                    default: {
                        this.host.error("Unhandled device indexed sibling parameter: " + subCmd);
                    }
                }
            }
        }
        catch (NumberFormatException ex) {
            this.host.error("Unhandled device sibling parameter: " + siblingCmd);
        }
    }

    private void parseDeviceParamValue(int paramNo, ParameterBankImpl parameterBank, Queue<String> parts, String value) {
        String command = parts.poll();
        IParameterEx p = (IParameterEx)parameterBank.getUnpagedItem(paramNo);
        switch (command) {
            case "name": {
                p.setInternalName(value);
                p.setPosition(paramNo);
                p.setExists(value != null && !value.isEmpty());
                break;
            }
            case "value": {
                if (parts.isEmpty()) {
                    p.setInternalValue(Double.parseDouble(value));
                    parameterBank.notifyValueObservers(paramNo);
                    break;
                }
                if (!"str".equals(parts.poll())) break;
                p.setValueStr(value);
                break;
            }
            case "steps": {
                p.setInternalNumberOfSteps(Integer.parseInt(value));
                break;
            }
            default: {
                this.host.error("Unhandled FX Param Value: " + command);
            }
        }
    }

    private void parseBrowserValue(Queue<String> parts, String value) {
        String command;
        if (this.browser == null) {
            return;
        }
        block4 : switch (command = parts.poll()) {
            case "presetsfile": {
                this.browser.setPresetsFile(value);
                break;
            }
            case "selected": {
                switch (parts.poll()) {
                    case "name": {
                        break block4;
                    }
                    case "index": {
                        this.browser.setPresetSelected(Integer.parseInt(value));
                        break block4;
                    }
                }
                this.host.error("Unhandled Browser Parameter Selected: " + command);
                break;
            }
            default: {
                this.host.error("Unhandled Browser Parameter: " + command);
            }
        }
    }

    private void parseMarker(Queue<String> parts, String value) {
        MarkerBankImpl markerBank = (MarkerBankImpl)this.model.getMarkerBank();
        String part = parts.poll();
        try {
            int position = Integer.parseInt(part);
            this.parseMarkerValue((IMarker)markerBank.getUnpagedItem(position), parts, value);
        }
        catch (NumberFormatException ex) {
            if (TAG_COUNT.equals(part)) {
                markerBank.setItemCount(Integer.parseInt(value));
            }
            this.host.error("Unhandled Marker command: " + part);
        }
    }

    private void parseScene(Queue<String> parts, String value) {
        for (SceneBankImpl sceneBank : ((ModelImpl)this.model).getSceneBanks()) {
            LinkedBlockingDeque<String> partsCopy = new LinkedBlockingDeque<String>(parts);
            String part = (String)partsCopy.poll();
            if (TAG_COUNT.equals(part)) {
                sceneBank.setItemCount(Integer.parseInt(value));
                continue;
            }
            try {
                this.parseSceneValue((IScene)sceneBank.getUnpagedItem(Integer.parseInt(part)), partsCopy, value);
            }
            catch (NumberFormatException ex) {
                this.host.error("Unhandled Scene command: " + part);
            }
        }
    }

    private void parseMarkerValue(IMarker marker, Queue<String> parts, String value) {
        String command = parts.poll();
        MarkerImpl markerImpl = (MarkerImpl)marker;
        switch (command) {
            case "exists": {
                markerImpl.setExists(Double.parseDouble(value) > 0.0);
                break;
            }
            case "number": {
                markerImpl.setPosition(Integer.parseInt(value));
                break;
            }
            case "name": {
                markerImpl.setInternalName(value);
                break;
            }
            case "color": {
                Optional<double[]> color = ((ModelImpl)this.model).parseColor(value);
                markerImpl.setColorState(color.isPresent() ? color.get() : ColorEx.GRAY.toDoubleRGB());
                break;
            }
            case "position": 
            case "endPosition": {
                break;
            }
            default: {
                this.host.error("Unhandled Marker Parameter: " + command);
            }
        }
    }

    private void parseSceneValue(IScene scene, Queue<String> parts, String value) {
        String command = parts.poll();
        SceneImpl sceneImpl = (SceneImpl)scene;
        switch (command) {
            case "exists": {
                sceneImpl.setExists(Double.parseDouble(value) > 0.0);
                break;
            }
            case "number": {
                sceneImpl.setPosition(Integer.parseInt(value));
                break;
            }
            case "name": {
                sceneImpl.setInternalName(value);
                break;
            }
            case "color": {
                Optional<double[]> color = ((ModelImpl)this.model).parseColor(value);
                sceneImpl.setColorState(color.isPresent() ? new ColorEx(color.get()) : ColorEx.GRAY);
                break;
            }
            case "position": {
                sceneImpl.setBeginPosition(Double.parseDouble(value));
                break;
            }
            case "endPosition": {
                sceneImpl.setEndPosition(Double.parseDouble(value));
                break;
            }
            default: {
                this.host.error("Unhandled Scene Parameter: " + command);
            }
        }
    }

    private void parseClipValue(Queue<String> parts, String value) {
        String command = parts.poll();
        ModelImpl modelImpl = (ModelImpl)this.model;
        switch (command) {
            case "exists": {
                modelImpl.setCursorClipExists(Double.parseDouble(value) > 0.0);
                break;
            }
            case "start": {
                modelImpl.setCursorClipPlayStart(Double.parseDouble(value));
                break;
            }
            case "end": {
                modelImpl.setCursorClipPlayEnd(Double.parseDouble(value));
                break;
            }
            case "playposition": {
                modelImpl.setCursorClipPlayPosition(Double.parseDouble(value));
                break;
            }
            case "color": {
                Optional<double[]> color = modelImpl.parseColor(value);
                modelImpl.setCursorClipColorValue(color.isPresent() ? color.get() : ColorEx.GRAY.toDoubleRGB());
                break;
            }
            case "loop": {
                modelImpl.setCursorClipLoopIsEnabled(Double.parseDouble(value) > 0.0);
                break;
            }
            case "notes": {
                modelImpl.setCursorClipNotes(Note.parseNotes(value));
                break;
            }
            case "all": {
                modelImpl.setClips(value);
                break;
            }
            default: {
                this.host.error("Unhandled Clip Parameter: " + command);
            }
        }
    }

    private void parseNoteRepeat(Queue<String> parts, String value) {
        String command;
        if (this.controllerSetup.getSurfaces().isEmpty()) {
            return;
        }
        Object surface = this.controllerSetup.getSurface();
        IMidiInput input = surface.getMidiInput();
        if (input == null) {
            return;
        }
        NoteRepeatImpl noteRepeat = (NoteRepeatImpl)input.getDefaultNoteInput().getNoteRepeat();
        switch (command = parts.poll()) {
            case "active": {
                boolean isActive = Double.parseDouble(value) > 0.0;
                surface.getConfiguration().setNoteRepeatActive(isActive);
                break;
            }
            case "period": {
                noteRepeat.setInternalPeriod(1.0 / Double.parseDouble(value));
                break;
            }
            case "notelength": {
                noteRepeat.setInternalNoteLength(Double.parseDouble(value));
                break;
            }
            case "mode": {
                noteRepeat.setInternalMode(Integer.parseInt(value));
                break;
            }
            case "velocity": {
                noteRepeat.setInternalUsePressure(Integer.parseInt(value) > 0);
                break;
            }
            default: {
                this.host.error("Unhandled NoteRepeat Parameter: " + command);
            }
        }
    }

    private void parseGroove(Queue<String> parts, String value) {
        String command;
        IGroove groove = this.model.getGroove();
        switch (command = parts.poll()) {
            case "active": {
                ((GrooveParameter)groove.getParameter(GrooveParameterID.ENABLED)).setInternalValue(Double.parseDouble(value));
                break;
            }
            case "amount": {
                ((GrooveParameter)groove.getParameter(GrooveParameterID.SHUFFLE_AMOUNT)).setInternalValue(Double.parseDouble(value));
                break;
            }
            default: {
                this.host.error("Unhandled Groove Parameter: " + command);
            }
        }
    }

    private static Queue<String> parsePath(String osc) {
        String[] parts = osc.split("/");
        ArrayBlockingQueue<String> oscParts = new ArrayBlockingQueue<String>(parts.length);
        Collections.addAll(oscParts, parts);
        if (oscParts.size() <= 1) {
            oscParts.clear();
            return oscParts;
        }
        oscParts.poll();
        return oscParts;
    }

    private void updateNoteMapping() {
        this.host.scheduleTask(() -> ((IView)this.controllerSetup.getSurface().getViewManager().getActive()).updateNoteMapping(), 1000L);
    }

    private void rebindKnobs() {
        this.controllerSetup.getSurfaces().forEach(surface -> {
            IMode mode = (IMode)surface.getModeManager().getActive();
            if (mode == null) {
                return;
            }
            mode.onActivate();
        });
    }
}

