/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.parameterprovider.device;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.data.bank.IBank;
import de.mossgrabers.framework.observer.IBankPageObserver;
import de.mossgrabers.framework.observer.IParametersAdjustObserver;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.AbstractParameterProvider;
import java.util.Optional;

public class BankParameterProvider
extends AbstractParameterProvider
implements IBankPageObserver {
    private final IBank<IParameter> bank;

    public BankParameterProvider(IBank<IParameter> bank) {
        this.bank = bank;
    }

    @Override
    public int size() {
        return this.bank.getPageSize();
    }

    @Override
    public IParameter get(int index) {
        return this.bank.getItem(index);
    }

    @Override
    public Optional<ColorEx> getColor(int index) {
        return Optional.empty();
    }

    @Override
    public void addParametersObserver(IParametersAdjustObserver observer) {
        super.addParametersObserver(observer);
        this.bank.addPageObserver(this);
    }

    @Override
    public void removeParametersObserver(IParametersAdjustObserver observer) {
        super.removeParametersObserver(observer);
        if (!this.hasObservers()) {
            this.bank.removePageObserver(this);
        }
    }

    @Override
    public void pageAdjusted() {
        this.notifyParametersObservers();
    }
}

