/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.view;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.ISessionAlternative;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractShiftView;
import de.mossgrabers.framework.view.Views;

public class ToggleShiftViewCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    protected final ViewManager viewManager;
    protected final IView shiftView;

    public ToggleShiftViewCommand(IModel model, S surface) {
        super(model, surface);
        this.viewManager = this.surface.getViewManager();
        this.shiftView = (IView)this.viewManager.get(Views.SHIFT);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (this.surface.isPressed(ButtonID.ALT)) {
            return;
        }
        switch (event) {
            case DOWN: {
                this.surface.setKnobSensitivityIsSlow(true);
                this.handleOnDown();
                break;
            }
            case LONG: {
                return;
            }
            case UP: {
                this.surface.setKnobSensitivityIsSlow(false);
                this.handleUp();
            }
        }
    }

    private void handleOnDown() {
        if (this.viewManager.isActive(new Views[]{Views.SHIFT})) {
            this.viewManager.restore();
            this.surface.setTriggerConsumed(ButtonID.SHIFT);
            this.surface.setKnobSensitivityIsSlow(false);
            return;
        }
        if (!(this.viewManager.getActive() instanceof ISessionAlternative)) {
            this.viewManager.setTemporary(Views.SHIFT);
        }
    }

    private void handleUp() {
        if (this.viewManager.isActive(new Views[]{Views.SHIFT}) && this.wasShiftViewUsed()) {
            this.viewManager.restore();
            return;
        }
        if (this.viewManager.getActive() instanceof ISessionAlternative) {
            if (this.wasAlternateInteractionUsed()) {
                this.clearAlternateInteractionUsed();
            } else {
                this.viewManager.setTemporary(Views.SHIFT);
            }
        }
    }

    protected void clearAlternateInteractionUsed() {
        Object f = this.viewManager.getActive();
        if (f instanceof ISessionAlternative) {
            ISessionAlternative sessionAlternative = (ISessionAlternative)f;
            sessionAlternative.setAlternateInteractionUsed(false);
        }
    }

    protected boolean wasAlternateInteractionUsed() {
        ISessionAlternative sessionAlternative;
        Object f = this.viewManager.getActive();
        return f instanceof ISessionAlternative && (sessionAlternative = (ISessionAlternative)f).wasAlternateInteractionUsed();
    }

    protected boolean wasShiftViewUsed() {
        return ((AbstractShiftView)this.shiftView).wasUsed();
    }
}

